/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.openaire.mapper;

import eu.openaire.oaf.QualifierType;
import eu.openaire.oaf.Result;
import eu.openaire.oaf.StructuredPropertyElementType;
import generated.Response;
import jakarta.xml.bind.JAXBElement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.damap.base.enums.EAccessRight;
import org.damap.base.enums.EDataAccessType;
import org.damap.base.enums.EDataSource;
import org.damap.base.enums.EDataType;
import org.damap.base.enums.EIdentifierType;
import org.damap.base.rest.dmp.domain.DatasetDO;
import org.damap.base.rest.dmp.domain.IdentifierDO;

public final class OpenAireMapper {
    public static DatasetDO mapAtoB(String doi, Response openaireResponse, DatasetDO datasetDO) {
        datasetDO.setSource(EDataSource.REUSED);
        try {
            Result result = openaireResponse.getResults().getResult().getMetadata().getEntity().getResult();
            List<JAXBElement<?>> elements = result.getCreatorOrResulttypeOrLanguage();
            for (JAXBElement<?> element : elements) {
                if (element.getDeclaredType() == StructuredPropertyElementType.class) {
                    datasetDO = OpenAireMapper.mapAtoB(element.getName().getLocalPart(), (StructuredPropertyElementType)element.getValue(), datasetDO);
                    continue;
                }
                if (element.getDeclaredType() == QualifierType.class) {
                    datasetDO = OpenAireMapper.mapAtoB(element.getName().getLocalPart(), (QualifierType)element.getValue(), datasetDO);
                    continue;
                }
                if (element.getDeclaredType() != String.class) continue;
                datasetDO = OpenAireMapper.mapAtoB(element.getName().getLocalPart(), (String)element.getValue(), datasetDO);
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        IdentifierDO identifierDO = new IdentifierDO();
        identifierDO.setType(EIdentifierType.DOI);
        identifierDO.setIdentifier(doi);
        datasetDO.setDatasetId(identifierDO);
        datasetDO.setSelectedProjectMembersAccess(EAccessRight.READ);
        datasetDO.setOtherProjectMembersAccess(EAccessRight.READ);
        datasetDO.setPublicAccess(EAccessRight.READ);
        return datasetDO;
    }

    public static DatasetDO mapAtoB(String propertyName, StructuredPropertyElementType elementType, DatasetDO datasetDO) {
        if ("title".equals(propertyName)) {
            if (datasetDO.getTitle() == null) {
                datasetDO.setTitle(elementType.getValue());
            } else {
                datasetDO.setTitle(datasetDO.getTitle() + " " + elementType.getValue());
            }
            if (datasetDO.getTitle().length() > 255) {
                datasetDO.setTitle(datasetDO.getTitle().substring(0, 255));
            }
        }
        return datasetDO;
    }

    public static DatasetDO mapAtoB(String propertyName, QualifierType qualifierType, DatasetDO datasetDO) {
        if ("bestaccessright".equals(propertyName)) {
            datasetDO.setDataAccess(OpenAireMapper.getDataAccessType(qualifierType.getClassid().toLowerCase()));
        } else if ("resourcetype".equals(propertyName)) {
            String type;
            List<EDataType> types = datasetDO.getType();
            switch (type = qualifierType.getClassname().toLowerCase()) {
                case "image": {
                    OpenAireMapper.addType(EDataType.IMAGES, types);
                    break;
                }
                case "film": 
                case "sound": {
                    OpenAireMapper.addType(EDataType.AUDIOVISUAL_DATA, types);
                    break;
                }
                case "software": {
                    OpenAireMapper.addType(EDataType.SOFTWARE_APPLICATIONS, types);
                    break;
                }
                case "text": {
                    OpenAireMapper.addType(EDataType.PLAIN_TEXT, types);
                    break;
                }
                default: {
                    OpenAireMapper.addType(EDataType.OTHER, types);
                }
            }
        }
        return datasetDO;
    }

    public static DatasetDO mapAtoB(String propertyName, String string, DatasetDO datasetDO) {
        switch (propertyName) {
            case "description": {
                if (datasetDO.getDescription() == null) {
                    datasetDO.setDescription(string);
                    break;
                }
                datasetDO.setDescription(datasetDO.getDescription() + " " + string);
                break;
            }
            case "size": {
                try {
                    Long size = Long.valueOf(string);
                    datasetDO.setSize(size);
                }
                catch (NumberFormatException size) {}
                break;
            }
            case "dateofacceptance": {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                try {
                    datasetDO.setStartDate(formatter.parse(string));
                }
                catch (ParseException parseException) {}
                break;
            }
        }
        return datasetDO;
    }

    private static EDataAccessType getDataAccessType(String bestAccessRight) {
        switch (bestAccessRight) {
            case "open": {
                return EDataAccessType.OPEN;
            }
            case "restricted": {
                return EDataAccessType.RESTRICTED;
            }
            case "closed": {
                return EDataAccessType.CLOSED;
            }
        }
        return null;
    }

    private static void addType(EDataType type, List<EDataType> types) {
        if (!types.contains((Object)type)) {
            types.add(type);
        }
    }

    @Generated
    private OpenAireMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

