/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.persons.orcid;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.damap.base.rest.base.ResultList;
import org.damap.base.rest.base.Search;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.persons.PersonService;
import org.damap.base.rest.persons.orcid.ORCIDMapper;
import org.damap.base.rest.persons.orcid.OrcidPersonService;
import org.damap.base.rest.persons.orcid.models.ORCIDExpandedSearchResult;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.logging.Logger;

@ApplicationScoped
public class ORCIDPersonServiceImpl
implements PersonService {
    @Generated
    private static final Logger log = Logger.getLogger(ORCIDPersonServiceImpl.class);
    @Inject
    @RestClient
    OrcidPersonService orcidRestClient;

    @Override
    public ContributorDO read(String id, MultivaluedMap<String, String> queryParams) {
        return ORCIDMapper.mapRecordEntityToPersonDO(this.orcidRestClient.get(id), new ContributorDO());
    }

    @Override
    public ResultList<ContributorDO> search(MultivaluedMap<String, String> queryParams) {
        Search search = Search.fromMap(queryParams);
        List contributors = null;
        try {
            ORCIDExpandedSearchResult orcidSearch = this.orcidRestClient.getAll(search.getQuery(), search.getPagination().getPerPage());
            if (orcidSearch.getNumFound() > 0L && orcidSearch.getPersons() != null) {
                contributors = orcidSearch.getPersons().stream().map(o -> {
                    ContributorDO c = new ContributorDO();
                    ORCIDMapper.mapExpandedSearchPersonEntityToDO(o, c);
                    return c;
                }).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            log.error((Object)"Issue searching ORCID persons", (Throwable)e);
        }
        return ResultList.fromItemsAndSearch(contributors, search);
    }
}

