/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.version;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.damap.base.domain.DmpVersion;
import org.damap.base.repo.DmpRepo;
import org.damap.base.repo.DmpVersionRepo;
import org.damap.base.rest.version.VersionDO;
import org.damap.base.rest.version.VersionDOMapper;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.jboss.logging.Logger;

@ApplicationScoped
public class VersionService {
    @Generated
    private static final Logger log = Logger.getLogger(VersionService.class);
    @Inject
    DmpVersionRepo dmpVersionRepo;
    @Inject
    DmpRepo dmpRepo;

    public List<VersionDO> getDmpVersions(long dmpId) {
        ArrayList<VersionDO> versionDOList = new ArrayList<VersionDO>();
        this.dmpVersionRepo.getAllByDmp(dmpId).forEach(version -> versionDOList.add(VersionDOMapper.mapEntityToDO(version, new VersionDO())));
        return versionDOList;
    }

    @Transactional
    public VersionDO createOrUpdate(VersionDO versionDO) {
        if (versionDO.getId() != null) {
            return this.update(versionDO);
        }
        return this.create(versionDO);
    }

    @Transactional
    public VersionDO create(VersionDO versionDO) {
        log.info((Object)"Creating new DMP Version");
        versionDO.setRevisionNumber(this.getCurrentRevisionNumber().longValue());
        DmpVersion version = VersionDOMapper.mapDOtoEntity(versionDO, new DmpVersion(), this.dmpRepo);
        version.setVersionDate(new Date());
        version.persist();
        return this.getVersionById(version.id);
    }

    @Transactional
    public VersionDO update(VersionDO versionDO) {
        log.info((Object)("Updating DMP Version with id " + versionDO.getId()));
        DmpVersion version = (DmpVersion)((Object)this.dmpVersionRepo.findById(versionDO.getId()));
        VersionDOMapper.mapDOtoEntity(versionDO, version, this.dmpRepo);
        version.persist();
        return this.getVersionById(version.id);
    }

    public void delete(long versionId) {
        log.info((Object)("Deleting DMP Version with id " + versionId));
        this.dmpVersionRepo.deleteById(versionId);
    }

    private VersionDO getVersionById(long versionId) {
        return VersionDOMapper.mapEntityToDO((DmpVersion)((Object)this.dmpVersionRepo.findById(versionId)), new VersionDO());
    }

    private Number getCurrentRevisionNumber() {
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.dmpRepo.getEntityManager());
        return reader.getRevisionNumberForDate(new Date());
    }
}

