/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.security;

import io.quarkus.arc.Unremovable;
import io.quarkus.oidc.runtime.OidcJwtCallerPrincipal;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;
import lombok.Generated;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Unremovable
@ApplicationScoped
public class SecurityService {
    @Generated
    private static final Logger log = Logger.getLogger(SecurityService.class);
    @Inject
    SecurityIdentity securityIdentity;
    @ConfigProperty(name="damap.auth.user")
    String authUser;

    public String getUserId() {
        Principal principal = this.securityIdentity.getPrincipal();
        if (!(principal instanceof OidcJwtCallerPrincipal)) {
            return null;
        }
        return ((OidcJwtCallerPrincipal)principal).getClaims().getClaimValue(this.authUser).toString();
    }

    public String getUserName() {
        Principal principal = this.securityIdentity.getPrincipal();
        if (!(principal instanceof OidcJwtCallerPrincipal)) {
            return null;
        }
        return ((OidcJwtCallerPrincipal)principal).getName();
    }

    public boolean isAdmin() {
        return this.securityIdentity.hasRole("Damap Admin");
    }
}

