
package org.damap.base.rest.madmp.dto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * The Dataset Items Schema
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "data_quality_assurance",
    "dataset_id",
    "description",
    "distribution",
    "issued",
    "keyword",
    "language",
    "metadata",
    "personal_data",
    "preservation_statement",
    "security_and_privacy",
    "sensitive_data",
    "technical_resource",
    "title",
    "type"
})
@Generated("jsonschema2pojo")
public class Dataset {

    /**
     * The Data Quality Assurance Schema
     * <p>
     * Data Quality Assurance
     * 
     */
    @JsonProperty("data_quality_assurance")
    @JsonPropertyDescription("Data Quality Assurance")
    private List<String> dataQualityAssurance = new ArrayList<String>();
    /**
     * The Dataset ID Schema
     * <p>
     * Dataset ID
     * (Required)
     * 
     */
    @JsonProperty("dataset_id")
    @JsonPropertyDescription("Dataset ID")
    private DatasetId datasetId;
    /**
     * The Dataset Description Schema
     * <p>
     * Description is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("Description is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.")
    private String description;
    /**
     * The Dataset Distribution Schema
     * <p>
     * To provide technical information on a specific instance of data.
     * 
     */
    @JsonProperty("distribution")
    @JsonPropertyDescription("To provide technical information on a specific instance of data.")
    private List<Distribution> distribution = new ArrayList<Distribution>();
    /**
     * The Dataset Date of Issue Schema
     * <p>
     * Issued. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * 
     */
    @JsonProperty("issued")
    @JsonPropertyDescription("Issued. Encoded using the relevant ISO 8601 Date and Time compliant string.")
    private String issued;
    /**
     * The Dataset Keyword(s) Schema
     * <p>
     * Keywords
     * 
     */
    @JsonProperty("keyword")
    @JsonPropertyDescription("Keywords")
    private List<String> keyword = new ArrayList<String>();
    /**
     * The Dataset Language Schema
     * <p>
     * Language of the dataset expressed using ISO 639-3.
     * 
     */
    @JsonProperty("language")
    @JsonPropertyDescription("Language of the dataset expressed using ISO 639-3.")
    private Dataset.Language language;
    /**
     * The Dataset Metadata Schema
     * <p>
     * To describe metadata standards used.
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("To describe metadata standards used.")
    private List<Metadatum> metadata = new ArrayList<Metadatum>();
    /**
     * The Dataset Personal Data Schema
     * <p>
     * If any personal data is contained. Allowed values: yes, no, unknown
     * (Required)
     * 
     */
    @JsonProperty("personal_data")
    @JsonPropertyDescription("If any personal data is contained. Allowed values: yes, no, unknown")
    private Dataset.PersonalData personalData;
    /**
     * The Dataset Preservation Statement Schema
     * <p>
     * Preservation Statement
     * 
     */
    @JsonProperty("preservation_statement")
    @JsonPropertyDescription("Preservation Statement")
    private String preservationStatement;
    /**
     * The Dataset Security and Policy Schema
     * <p>
     * To list all issues and requirements related to security and privacy
     * 
     */
    @JsonProperty("security_and_privacy")
    @JsonPropertyDescription("To list all issues and requirements related to security and privacy")
    private List<SecurityAndPrivacy> securityAndPrivacy = new ArrayList<SecurityAndPrivacy>();
    /**
     * The Dataset Sensitive Data Schema
     * <p>
     * If any sensitive data is contained. Allowed values: yes, no, unknown
     * (Required)
     * 
     */
    @JsonProperty("sensitive_data")
    @JsonPropertyDescription("If any sensitive data is contained. Allowed values: yes, no, unknown")
    private Dataset.SensitiveData sensitiveData;
    /**
     * The Dataset Technical Resource Schema
     * <p>
     * To list all technical resources needed to implement a DMP
     * 
     */
    @JsonProperty("technical_resource")
    @JsonPropertyDescription("To list all technical resources needed to implement a DMP")
    private List<TechnicalResource> technicalResource = new ArrayList<TechnicalResource>();
    /**
     * The Dataset Title Schema
     * <p>
     * Title is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.
     * (Required)
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("Title is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.")
    private String title;
    /**
     * The Dataset Type Schema
     * <p>
     * If appropriate, type according to: DataCite and/or COAR dictionary. Otherwise use the common name for the type, e.g. raw data, software, survey, etc. https://schema.datacite.org/meta/kernel-4.1/doc/DataCite-MetadataKernel_v4.1.pdf http://vocabularies.coar-repositories.org/pubby/resource_type.html
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("If appropriate, type according to: DataCite and/or COAR dictionary. Otherwise use the common name for the type, e.g. raw data, software, survey, etc. https://schema.datacite.org/meta/kernel-4.1/doc/DataCite-MetadataKernel_v4.1.pdf http://vocabularies.coar-repositories.org/pubby/resource_type.html")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The Data Quality Assurance Schema
     * <p>
     * Data Quality Assurance
     * 
     */
    @JsonProperty("data_quality_assurance")
    public List<String> getDataQualityAssurance() {
        return dataQualityAssurance;
    }

    /**
     * The Data Quality Assurance Schema
     * <p>
     * Data Quality Assurance
     * 
     */
    @JsonProperty("data_quality_assurance")
    public void setDataQualityAssurance(List<String> dataQualityAssurance) {
        this.dataQualityAssurance = dataQualityAssurance;
    }

    /**
     * The Dataset ID Schema
     * <p>
     * Dataset ID
     * (Required)
     * 
     */
    @JsonProperty("dataset_id")
    public DatasetId getDatasetId() {
        return datasetId;
    }

    /**
     * The Dataset ID Schema
     * <p>
     * Dataset ID
     * (Required)
     * 
     */
    @JsonProperty("dataset_id")
    public void setDatasetId(DatasetId datasetId) {
        this.datasetId = datasetId;
    }

    /**
     * The Dataset Description Schema
     * <p>
     * Description is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * The Dataset Description Schema
     * <p>
     * Description is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The Dataset Distribution Schema
     * <p>
     * To provide technical information on a specific instance of data.
     * 
     */
    @JsonProperty("distribution")
    public List<Distribution> getDistribution() {
        return distribution;
    }

    /**
     * The Dataset Distribution Schema
     * <p>
     * To provide technical information on a specific instance of data.
     * 
     */
    @JsonProperty("distribution")
    public void setDistribution(List<Distribution> distribution) {
        this.distribution = distribution;
    }

    /**
     * The Dataset Date of Issue Schema
     * <p>
     * Issued. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * 
     */
    @JsonProperty("issued")
    public String getIssued() {
        return issued;
    }

    /**
     * The Dataset Date of Issue Schema
     * <p>
     * Issued. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * 
     */
    @JsonProperty("issued")
    public void setIssued(String issued) {
        this.issued = issued;
    }

    /**
     * The Dataset Keyword(s) Schema
     * <p>
     * Keywords
     * 
     */
    @JsonProperty("keyword")
    public List<String> getKeyword() {
        return keyword;
    }

    /**
     * The Dataset Keyword(s) Schema
     * <p>
     * Keywords
     * 
     */
    @JsonProperty("keyword")
    public void setKeyword(List<String> keyword) {
        this.keyword = keyword;
    }

    /**
     * The Dataset Language Schema
     * <p>
     * Language of the dataset expressed using ISO 639-3.
     * 
     */
    @JsonProperty("language")
    public Dataset.Language getLanguage() {
        return language;
    }

    /**
     * The Dataset Language Schema
     * <p>
     * Language of the dataset expressed using ISO 639-3.
     * 
     */
    @JsonProperty("language")
    public void setLanguage(Dataset.Language language) {
        this.language = language;
    }

    /**
     * The Dataset Metadata Schema
     * <p>
     * To describe metadata standards used.
     * 
     */
    @JsonProperty("metadata")
    public List<Metadatum> getMetadata() {
        return metadata;
    }

    /**
     * The Dataset Metadata Schema
     * <p>
     * To describe metadata standards used.
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(List<Metadatum> metadata) {
        this.metadata = metadata;
    }

    /**
     * The Dataset Personal Data Schema
     * <p>
     * If any personal data is contained. Allowed values: yes, no, unknown
     * (Required)
     * 
     */
    @JsonProperty("personal_data")
    public Dataset.PersonalData getPersonalData() {
        return personalData;
    }

    /**
     * The Dataset Personal Data Schema
     * <p>
     * If any personal data is contained. Allowed values: yes, no, unknown
     * (Required)
     * 
     */
    @JsonProperty("personal_data")
    public void setPersonalData(Dataset.PersonalData personalData) {
        this.personalData = personalData;
    }

    /**
     * The Dataset Preservation Statement Schema
     * <p>
     * Preservation Statement
     * 
     */
    @JsonProperty("preservation_statement")
    public String getPreservationStatement() {
        return preservationStatement;
    }

    /**
     * The Dataset Preservation Statement Schema
     * <p>
     * Preservation Statement
     * 
     */
    @JsonProperty("preservation_statement")
    public void setPreservationStatement(String preservationStatement) {
        this.preservationStatement = preservationStatement;
    }

    /**
     * The Dataset Security and Policy Schema
     * <p>
     * To list all issues and requirements related to security and privacy
     * 
     */
    @JsonProperty("security_and_privacy")
    public List<SecurityAndPrivacy> getSecurityAndPrivacy() {
        return securityAndPrivacy;
    }

    /**
     * The Dataset Security and Policy Schema
     * <p>
     * To list all issues and requirements related to security and privacy
     * 
     */
    @JsonProperty("security_and_privacy")
    public void setSecurityAndPrivacy(List<SecurityAndPrivacy> securityAndPrivacy) {
        this.securityAndPrivacy = securityAndPrivacy;
    }

    /**
     * The Dataset Sensitive Data Schema
     * <p>
     * If any sensitive data is contained. Allowed values: yes, no, unknown
     * (Required)
     * 
     */
    @JsonProperty("sensitive_data")
    public Dataset.SensitiveData getSensitiveData() {
        return sensitiveData;
    }

    /**
     * The Dataset Sensitive Data Schema
     * <p>
     * If any sensitive data is contained. Allowed values: yes, no, unknown
     * (Required)
     * 
     */
    @JsonProperty("sensitive_data")
    public void setSensitiveData(Dataset.SensitiveData sensitiveData) {
        this.sensitiveData = sensitiveData;
    }

    /**
     * The Dataset Technical Resource Schema
     * <p>
     * To list all technical resources needed to implement a DMP
     * 
     */
    @JsonProperty("technical_resource")
    public List<TechnicalResource> getTechnicalResource() {
        return technicalResource;
    }

    /**
     * The Dataset Technical Resource Schema
     * <p>
     * To list all technical resources needed to implement a DMP
     * 
     */
    @JsonProperty("technical_resource")
    public void setTechnicalResource(List<TechnicalResource> technicalResource) {
        this.technicalResource = technicalResource;
    }

    /**
     * The Dataset Title Schema
     * <p>
     * Title is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.
     * (Required)
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * The Dataset Title Schema
     * <p>
     * Title is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.
     * (Required)
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * The Dataset Type Schema
     * <p>
     * If appropriate, type according to: DataCite and/or COAR dictionary. Otherwise use the common name for the type, e.g. raw data, software, survey, etc. https://schema.datacite.org/meta/kernel-4.1/doc/DataCite-MetadataKernel_v4.1.pdf http://vocabularies.coar-repositories.org/pubby/resource_type.html
     * 
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * The Dataset Type Schema
     * <p>
     * If appropriate, type according to: DataCite and/or COAR dictionary. Otherwise use the common name for the type, e.g. raw data, software, survey, etc. https://schema.datacite.org/meta/kernel-4.1/doc/DataCite-MetadataKernel_v4.1.pdf http://vocabularies.coar-repositories.org/pubby/resource_type.html
     * 
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Dataset.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataQualityAssurance");
        sb.append('=');
        sb.append(((this.dataQualityAssurance == null)?"<null>":this.dataQualityAssurance));
        sb.append(',');
        sb.append("datasetId");
        sb.append('=');
        sb.append(((this.datasetId == null)?"<null>":this.datasetId));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("distribution");
        sb.append('=');
        sb.append(((this.distribution == null)?"<null>":this.distribution));
        sb.append(',');
        sb.append("issued");
        sb.append('=');
        sb.append(((this.issued == null)?"<null>":this.issued));
        sb.append(',');
        sb.append("keyword");
        sb.append('=');
        sb.append(((this.keyword == null)?"<null>":this.keyword));
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(((this.language == null)?"<null>":this.language));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("personalData");
        sb.append('=');
        sb.append(((this.personalData == null)?"<null>":this.personalData));
        sb.append(',');
        sb.append("preservationStatement");
        sb.append('=');
        sb.append(((this.preservationStatement == null)?"<null>":this.preservationStatement));
        sb.append(',');
        sb.append("securityAndPrivacy");
        sb.append('=');
        sb.append(((this.securityAndPrivacy == null)?"<null>":this.securityAndPrivacy));
        sb.append(',');
        sb.append("sensitiveData");
        sb.append('=');
        sb.append(((this.sensitiveData == null)?"<null>":this.sensitiveData));
        sb.append(',');
        sb.append("technicalResource");
        sb.append('=');
        sb.append(((this.technicalResource == null)?"<null>":this.technicalResource));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.securityAndPrivacy == null)? 0 :this.securityAndPrivacy.hashCode()));
        result = ((result* 31)+((this.personalData == null)? 0 :this.personalData.hashCode()));
        result = ((result* 31)+((this.technicalResource == null)? 0 :this.technicalResource.hashCode()));
        result = ((result* 31)+((this.sensitiveData == null)? 0 :this.sensitiveData.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.language == null)? 0 :this.language.hashCode()));
        result = ((result* 31)+((this.distribution == null)? 0 :this.distribution.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.preservationStatement == null)? 0 :this.preservationStatement.hashCode()));
        result = ((result* 31)+((this.dataQualityAssurance == null)? 0 :this.dataQualityAssurance.hashCode()));
        result = ((result* 31)+((this.datasetId == null)? 0 :this.datasetId.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.issued == null)? 0 :this.issued.hashCode()));
        result = ((result* 31)+((this.keyword == null)? 0 :this.keyword.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Dataset) == false) {
            return false;
        }
        Dataset rhs = ((Dataset) other);
        return (((((((((((((((((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata)))&&((this.securityAndPrivacy == rhs.securityAndPrivacy)||((this.securityAndPrivacy!= null)&&this.securityAndPrivacy.equals(rhs.securityAndPrivacy))))&&((this.personalData == rhs.personalData)||((this.personalData!= null)&&this.personalData.equals(rhs.personalData))))&&((this.technicalResource == rhs.technicalResource)||((this.technicalResource!= null)&&this.technicalResource.equals(rhs.technicalResource))))&&((this.sensitiveData == rhs.sensitiveData)||((this.sensitiveData!= null)&&this.sensitiveData.equals(rhs.sensitiveData))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.language == rhs.language)||((this.language!= null)&&this.language.equals(rhs.language))))&&((this.distribution == rhs.distribution)||((this.distribution!= null)&&this.distribution.equals(rhs.distribution))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.preservationStatement == rhs.preservationStatement)||((this.preservationStatement!= null)&&this.preservationStatement.equals(rhs.preservationStatement))))&&((this.dataQualityAssurance == rhs.dataQualityAssurance)||((this.dataQualityAssurance!= null)&&this.dataQualityAssurance.equals(rhs.dataQualityAssurance))))&&((this.datasetId == rhs.datasetId)||((this.datasetId!= null)&&this.datasetId.equals(rhs.datasetId))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.issued == rhs.issued)||((this.issued!= null)&&this.issued.equals(rhs.issued))))&&((this.keyword == rhs.keyword)||((this.keyword!= null)&&this.keyword.equals(rhs.keyword))));
    }


    /**
     * The Dataset Language Schema
     * <p>
     * Language of the dataset expressed using ISO 639-3.
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Language {

        AAR("aar"),
        ABK("abk"),
        AFR("afr"),
        AKA("aka"),
        AMH("amh"),
        ARA("ara"),
        ARG("arg"),
        ASM("asm"),
        AVA("ava"),
        AVE("ave"),
        AYM("aym"),
        AZE("aze"),
        BAK("bak"),
        BAM("bam"),
        BEL("bel"),
        BEN("ben"),
        BIH("bih"),
        BIS("bis"),
        BOD("bod"),
        BOS("bos"),
        BRE("bre"),
        BUL("bul"),
        CAT("cat"),
        CES("ces"),
        CHA("cha"),
        CHE("che"),
        CHU("chu"),
        CHV("chv"),
        COR("cor"),
        COS("cos"),
        CRE("cre"),
        CYM("cym"),
        DAN("dan"),
        DEU("deu"),
        DIV("div"),
        DZO("dzo"),
        ELL("ell"),
        ENG("eng"),
        EPO("epo"),
        EST("est"),
        EUS("eus"),
        EWE("ewe"),
        FAO("fao"),
        FAS("fas"),
        FIJ("fij"),
        FIN("fin"),
        FRA("fra"),
        FRY("fry"),
        FUL("ful"),
        GLA("gla"),
        GLE("gle"),
        GLG("glg"),
        GLV("glv"),
        GRN("grn"),
        GUJ("guj"),
        HAT("hat"),
        HAU("hau"),
        HBS("hbs"),
        HEB("heb"),
        HER("her"),
        HIN("hin"),
        HMO("hmo"),
        HRV("hrv"),
        HUN("hun"),
        HYE("hye"),
        IBO("ibo"),
        IDO("ido"),
        III("iii"),
        IKU("iku"),
        ILE("ile"),
        INA("ina"),
        IND("ind"),
        IPK("ipk"),
        ISL("isl"),
        ITA("ita"),
        JAV("jav"),
        JPN("jpn"),
        KAL("kal"),
        KAN("kan"),
        KAS("kas"),
        KAT("kat"),
        KAU("kau"),
        KAZ("kaz"),
        KHM("khm"),
        KIK("kik"),
        KIN("kin"),
        KIR("kir"),
        KOM("kom"),
        KON("kon"),
        KOR("kor"),
        KUA("kua"),
        KUR("kur"),
        LAO("lao"),
        LAT("lat"),
        LAV("lav"),
        LIM("lim"),
        LIN("lin"),
        LIT("lit"),
        LTZ("ltz"),
        LUB("lub"),
        LUG("lug"),
        MAH("mah"),
        MAL("mal"),
        MAR("mar"),
        MKD("mkd"),
        MLG("mlg"),
        MLT("mlt"),
        MON("mon"),
        MRI("mri"),
        MSA("msa"),
        MYA("mya"),
        NAU("nau"),
        NAV("nav"),
        NBL("nbl"),
        NDE("nde"),
        NDO("ndo"),
        NEP("nep"),
        NLD("nld"),
        NNO("nno"),
        NOB("nob"),
        NOR("nor"),
        NYA("nya"),
        OCI("oci"),
        OJI("oji"),
        ORI("ori"),
        ORM("orm"),
        OSS("oss"),
        PAN("pan"),
        PLI("pli"),
        POL("pol"),
        POR("por"),
        PUS("pus"),
        QUE("que"),
        ROH("roh"),
        RON("ron"),
        RUN("run"),
        RUS("rus"),
        SAG("sag"),
        SAN("san"),
        SIN("sin"),
        SLK("slk"),
        SLV("slv"),
        SME("sme"),
        SMO("smo"),
        SNA("sna"),
        SND("snd"),
        SOM("som"),
        SOT("sot"),
        SPA("spa"),
        SQI("sqi"),
        SRD("srd"),
        SRP("srp"),
        SSW("ssw"),
        SUN("sun"),
        SWA("swa"),
        SWE("swe"),
        TAH("tah"),
        TAM("tam"),
        TAT("tat"),
        TEL("tel"),
        TGK("tgk"),
        TGL("tgl"),
        THA("tha"),
        TIR("tir"),
        TON("ton"),
        TSN("tsn"),
        TSO("tso"),
        TUK("tuk"),
        TUR("tur"),
        TWI("twi"),
        UIG("uig"),
        UKR("ukr"),
        URD("urd"),
        UZB("uzb"),
        VEN("ven"),
        VIE("vie"),
        VOL("vol"),
        WLN("wln"),
        WOL("wol"),
        XHO("xho"),
        YID("yid"),
        YOR("yor"),
        ZHA("zha"),
        ZHO("zho"),
        ZUL("zul");
        private final String value;
        private final static Map<String, Dataset.Language> CONSTANTS = new HashMap<String, Dataset.Language>();

        static {
            for (Dataset.Language c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Language(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Dataset.Language fromValue(String value) {
            Dataset.Language constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * The Dataset Personal Data Schema
     * <p>
     * If any personal data is contained. Allowed values: yes, no, unknown
     * 
     */
    @Generated("jsonschema2pojo")
    public enum PersonalData {

        YES("yes"),
        NO("no"),
        UNKNOWN("unknown");
        private final String value;
        private final static Map<String, Dataset.PersonalData> CONSTANTS = new HashMap<String, Dataset.PersonalData>();

        static {
            for (Dataset.PersonalData c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PersonalData(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Dataset.PersonalData fromValue(String value) {
            Dataset.PersonalData constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * The Dataset Sensitive Data Schema
     * <p>
     * If any sensitive data is contained. Allowed values: yes, no, unknown
     * 
     */
    @Generated("jsonschema2pojo")
    public enum SensitiveData {

        YES("yes"),
        NO("no"),
        UNKNOWN("unknown");
        private final String value;
        private final static Map<String, Dataset.SensitiveData> CONSTANTS = new HashMap<String, Dataset.SensitiveData>();

        static {
            for (Dataset.SensitiveData c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        SensitiveData(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Dataset.SensitiveData fromValue(String value) {
            Dataset.SensitiveData constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
