
package org.damap.base.rest.madmp.dto;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * The DMP Project Funding Items Schema
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "funder_id",
    "funding_status",
    "grant_id"
})
@Generated("jsonschema2pojo")
public class Funding {

    /**
     * The Funder ID Schema
     * <p>
     * Funder ID of the associated project
     * (Required)
     * 
     */
    @JsonProperty("funder_id")
    @JsonPropertyDescription("Funder ID of the associated project")
    private FunderId funderId;
    /**
     * The Funding Status Schema
     * <p>
     * To express different phases of project lifecycle. Allowed values: planned, applied, granted, rejected
     * 
     */
    @JsonProperty("funding_status")
    @JsonPropertyDescription("To express different phases of project lifecycle. Allowed values: planned, applied, granted, rejected")
    private Funding.FundingStatus fundingStatus;
    /**
     * The Funding Grant ID Schema
     * <p>
     * Grant ID of the associated project
     * 
     */
    @JsonProperty("grant_id")
    @JsonPropertyDescription("Grant ID of the associated project")
    private GrantId grantId;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The Funder ID Schema
     * <p>
     * Funder ID of the associated project
     * (Required)
     * 
     */
    @JsonProperty("funder_id")
    public FunderId getFunderId() {
        return funderId;
    }

    /**
     * The Funder ID Schema
     * <p>
     * Funder ID of the associated project
     * (Required)
     * 
     */
    @JsonProperty("funder_id")
    public void setFunderId(FunderId funderId) {
        this.funderId = funderId;
    }

    /**
     * The Funding Status Schema
     * <p>
     * To express different phases of project lifecycle. Allowed values: planned, applied, granted, rejected
     * 
     */
    @JsonProperty("funding_status")
    public Funding.FundingStatus getFundingStatus() {
        return fundingStatus;
    }

    /**
     * The Funding Status Schema
     * <p>
     * To express different phases of project lifecycle. Allowed values: planned, applied, granted, rejected
     * 
     */
    @JsonProperty("funding_status")
    public void setFundingStatus(Funding.FundingStatus fundingStatus) {
        this.fundingStatus = fundingStatus;
    }

    /**
     * The Funding Grant ID Schema
     * <p>
     * Grant ID of the associated project
     * 
     */
    @JsonProperty("grant_id")
    public GrantId getGrantId() {
        return grantId;
    }

    /**
     * The Funding Grant ID Schema
     * <p>
     * Grant ID of the associated project
     * 
     */
    @JsonProperty("grant_id")
    public void setGrantId(GrantId grantId) {
        this.grantId = grantId;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Funding.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("funderId");
        sb.append('=');
        sb.append(((this.funderId == null)?"<null>":this.funderId));
        sb.append(',');
        sb.append("fundingStatus");
        sb.append('=');
        sb.append(((this.fundingStatus == null)?"<null>":this.fundingStatus));
        sb.append(',');
        sb.append("grantId");
        sb.append('=');
        sb.append(((this.grantId == null)?"<null>":this.grantId));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.funderId == null)? 0 :this.funderId.hashCode()));
        result = ((result* 31)+((this.grantId == null)? 0 :this.grantId.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.fundingStatus == null)? 0 :this.fundingStatus.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Funding) == false) {
            return false;
        }
        Funding rhs = ((Funding) other);
        return (((((this.funderId == rhs.funderId)||((this.funderId!= null)&&this.funderId.equals(rhs.funderId)))&&((this.grantId == rhs.grantId)||((this.grantId!= null)&&this.grantId.equals(rhs.grantId))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.fundingStatus == rhs.fundingStatus)||((this.fundingStatus!= null)&&this.fundingStatus.equals(rhs.fundingStatus))));
    }


    /**
     * The Funding Status Schema
     * <p>
     * To express different phases of project lifecycle. Allowed values: planned, applied, granted, rejected
     * 
     */
    @Generated("jsonschema2pojo")
    public enum FundingStatus {

        PLANNED("planned"),
        APPLIED("applied"),
        GRANTED("granted"),
        REJECTED("rejected");
        private final String value;
        private final static Map<String, Funding.FundingStatus> CONSTANTS = new HashMap<String, Funding.FundingStatus>();

        static {
            for (Funding.FundingStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FundingStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Funding.FundingStatus fromValue(String value) {
            Funding.FundingStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
