
package org.damap.base.rest.madmp.dto;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * The Dataset Distribution License Items
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "license_ref",
    "start_date"
})
@Generated("jsonschema2pojo")
public class License {

    /**
     * The Dataset Distribution License Reference Schema
     * <p>
     * Link to license document.
     * (Required)
     * 
     */
    @JsonProperty("license_ref")
    @JsonPropertyDescription("Link to license document.")
    private URI licenseRef;
    /**
     * The Dataset Distribution License Start Date Schema
     * <p>
     * If date is set in the future, it indicates embargo period. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * (Required)
     * 
     */
    @JsonProperty("start_date")
    @JsonPropertyDescription("If date is set in the future, it indicates embargo period. Encoded using the relevant ISO 8601 Date and Time compliant string.")
    private String startDate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The Dataset Distribution License Reference Schema
     * <p>
     * Link to license document.
     * (Required)
     * 
     */
    @JsonProperty("license_ref")
    public URI getLicenseRef() {
        return licenseRef;
    }

    /**
     * The Dataset Distribution License Reference Schema
     * <p>
     * Link to license document.
     * (Required)
     * 
     */
    @JsonProperty("license_ref")
    public void setLicenseRef(URI licenseRef) {
        this.licenseRef = licenseRef;
    }

    /**
     * The Dataset Distribution License Start Date Schema
     * <p>
     * If date is set in the future, it indicates embargo period. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * (Required)
     * 
     */
    @JsonProperty("start_date")
    public String getStartDate() {
        return startDate;
    }

    /**
     * The Dataset Distribution License Start Date Schema
     * <p>
     * If date is set in the future, it indicates embargo period. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * (Required)
     * 
     */
    @JsonProperty("start_date")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(License.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("licenseRef");
        sb.append('=');
        sb.append(((this.licenseRef == null)?"<null>":this.licenseRef));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.licenseRef == null)? 0 :this.licenseRef.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof License) == false) {
            return false;
        }
        License rhs = ((License) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.licenseRef == rhs.licenseRef)||((this.licenseRef!= null)&&this.licenseRef.equals(rhs.licenseRef))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }

}
