
package org.damap.base.rest.madmp.dto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * The DMP Project Items Schema
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "description",
    "end",
    "funding",
    "start",
    "title"
})
@Generated("jsonschema2pojo")
public class Project {

    /**
     * The DMP Project Description Schema
     * <p>
     * Project description
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("Project description")
    private String description;
    /**
     * The DMP Project End Date Schema
     * <p>
     * Project end date. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * 
     */
    @JsonProperty("end")
    @JsonPropertyDescription("Project end date. Encoded using the relevant ISO 8601 Date and Time compliant string.")
    private String end;
    /**
     * The DMP Project Funding Schema
     * <p>
     * Funding related with a project
     * 
     */
    @JsonProperty("funding")
    @JsonPropertyDescription("Funding related with a project")
    private List<Funding> funding = new ArrayList<Funding>();
    /**
     * The DMP Project Start Date Schema
     * <p>
     * Project start date. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * 
     */
    @JsonProperty("start")
    @JsonPropertyDescription("Project start date. Encoded using the relevant ISO 8601 Date and Time compliant string.")
    private String start;
    /**
     * The DMP Project Title Schema
     * <p>
     * Project title
     * (Required)
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("Project title")
    private String title;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The DMP Project Description Schema
     * <p>
     * Project description
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * The DMP Project Description Schema
     * <p>
     * Project description
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The DMP Project End Date Schema
     * <p>
     * Project end date. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * 
     */
    @JsonProperty("end")
    public String getEnd() {
        return end;
    }

    /**
     * The DMP Project End Date Schema
     * <p>
     * Project end date. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * 
     */
    @JsonProperty("end")
    public void setEnd(String end) {
        this.end = end;
    }

    /**
     * The DMP Project Funding Schema
     * <p>
     * Funding related with a project
     * 
     */
    @JsonProperty("funding")
    public List<Funding> getFunding() {
        return funding;
    }

    /**
     * The DMP Project Funding Schema
     * <p>
     * Funding related with a project
     * 
     */
    @JsonProperty("funding")
    public void setFunding(List<Funding> funding) {
        this.funding = funding;
    }

    /**
     * The DMP Project Start Date Schema
     * <p>
     * Project start date. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * 
     */
    @JsonProperty("start")
    public String getStart() {
        return start;
    }

    /**
     * The DMP Project Start Date Schema
     * <p>
     * Project start date. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * 
     */
    @JsonProperty("start")
    public void setStart(String start) {
        this.start = start;
    }

    /**
     * The DMP Project Title Schema
     * <p>
     * Project title
     * (Required)
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * The DMP Project Title Schema
     * <p>
     * Project title
     * (Required)
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Project.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("end");
        sb.append('=');
        sb.append(((this.end == null)?"<null>":this.end));
        sb.append(',');
        sb.append("funding");
        sb.append('=');
        sb.append(((this.funding == null)?"<null>":this.funding));
        sb.append(',');
        sb.append("start");
        sb.append('=');
        sb.append(((this.start == null)?"<null>":this.start));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.funding == null)? 0 :this.funding.hashCode()));
        result = ((result* 31)+((this.start == null)? 0 :this.start.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.end == null)? 0 :this.end.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Project) == false) {
            return false;
        }
        Project rhs = ((Project) other);
        return (((((((this.funding == rhs.funding)||((this.funding!= null)&&this.funding.equals(rhs.funding)))&&((this.start == rhs.start)||((this.start!= null)&&this.start.equals(rhs.start))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.end == rhs.end)||((this.end!= null)&&this.end.equals(rhs.end))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))));
    }

}
