/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.conversion;

import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.damap.base.conversion.AbstractTemplateExportSetup;
import org.damap.base.domain.Contributor;
import org.damap.base.domain.Cost;
import org.damap.base.domain.Dataset;
import org.damap.base.domain.DatasetSizeRange;
import org.damap.base.domain.Distribution;
import org.damap.base.domain.ExternalStorage;
import org.damap.base.domain.Host;
import org.damap.base.domain.Identifier;
import org.damap.base.domain.InternalStorageTranslation;
import org.damap.base.domain.Project;
import org.damap.base.domain.Repository;
import org.damap.base.domain.Storage;
import org.damap.base.domain.TechnicalResource;
import org.damap.base.enums.EAgreement;
import org.damap.base.enums.EComplianceType;
import org.damap.base.enums.EContributorRole;
import org.damap.base.enums.EDataAccessType;
import org.damap.base.enums.EDataQualityType;
import org.damap.base.enums.EDataSource;
import org.damap.base.enums.EDataType;
import org.damap.base.enums.EIdentifierType;
import org.damap.base.enums.ELicense;
import org.damap.base.enums.ESecurityMeasure;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.domain.ProjectDO;
import org.damap.base.rest.dmp.mapper.ContributorDOMapper;
import org.damap.base.utils.EqualityUtils;
import org.jboss.logging.Logger;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;

public abstract class AbstractTemplateExportScienceEuropeComponents
extends AbstractTemplateExportSetup {
    @Generated
    private static final Logger log = Logger.getLogger(AbstractTemplateExportScienceEuropeComponents.class);
    protected Map<Long, String> datasetTableIDs = new HashMap<Long, String>();
    private List<String> projectCoordinatorOrInvestigatorIds = new ArrayList<String>();
    private static final char[] SUFFIXES = new char[]{'K', 'M', 'G', 'T', 'P', 'E'};

    @Override
    protected void exportSetup(long dmpId) {
        super.exportSetup(dmpId);
        this.determineDatasetIDs();
    }

    public void loadScienceEuropeContent() {
        this.titlePage();
        this.contributorInformation();
        this.datasetsInformation();
        this.storageIntroInformation();
        this.storageInformation();
        this.dataQuality();
        this.sensitiveDataInformation();
        this.legalEthicalInformation();
        this.repoinfoAndToolsInformation();
        this.costInformation();
    }

    public void determineDatasetIDs() {
        int newIDprogression = 0;
        int reuseIDprogression = 0;
        for (Dataset dataset : this.datasets) {
            if (EqualityUtils.nullExclusiveEquals((Object)dataset.getSource(), (Object)EDataSource.NEW)) {
                this.datasetTableIDs.put(dataset.id, "P" + ++newIDprogression);
            }
            if (!EqualityUtils.nullExclusiveEquals((Object)dataset.getSource(), (Object)EDataSource.REUSED)) continue;
            this.datasetTableIDs.put(dataset.id, "R" + ++reuseIDprogression);
        }
    }

    public void titlePage() {
        Project project = this.dmp.getProject();
        if (project == null) {
            this.addReplacement(this.replacements, "[startdate]", "");
            this.addReplacement(this.replacements, "[enddate]", "");
            this.addReplacement(this.replacements, "[funderid]", "");
            this.addReplacement(this.replacements, "[grantid]", "");
            this.addReplacement(this.replacements, "[projectid]", "");
            return;
        }
        Integer titleLength = project.getTitle() == null ? 0 : project.getTitle().length();
        if (titleLength / 25 > 2) {
            this.addReplacement(this.replacements, "[projectname]", project.getTitle() + "#oversize");
        } else {
            this.addReplacement(this.replacements, "[projectname]", project.getTitle());
        }
        this.addReplacement(this.replacements, "[projectnameText]", project.getTitle());
        this.addReplacement(this.footerMap, "[projectnameText]", project.getTitle());
        this.addReplacement(this.replacements, "[acronym]", project.getAcronym());
        this.addReplacement(this.footerMap, "[acronym]", project.getAcronym());
        this.addReplacement(this.replacements, "[startdate]", project.getStart() == null ? "" : this.formatter.format(project.getStart()));
        this.addReplacement(this.replacements, "[enddate]", project.getEnd() == null ? "" : this.formatter.format(project.getEnd()));
        ProjectDO projectCRIS = null;
        if (project.getUniversityId() != null) {
            projectCRIS = (ProjectDO)this.projectService.read(project.getUniversityId());
        }
        this.titlePageFunding(project, projectCRIS);
        this.addReplacement(this.replacements, "[projectid]", project.getUniversityId());
    }

    private void titlePageFunding(Project project, ProjectDO projectCRIS) {
        ArrayList<String> fundingItems = new ArrayList<String>();
        if (projectCRIS != null && projectCRIS.getFunding() != null && projectCRIS.getFunding().getFundingProgram() != null) {
            fundingItems.add(projectCRIS.getFunding().getFundingProgram());
        }
        if (project.getFundingGrantIdentifierIdentifier() != null) {
            fundingItems.add(project.getFundingGrantIdentifierIdentifier());
        }
        if (project.getFundingFunderIdentifierIdentifier() != null) {
            this.addReplacement(this.replacements, "[funderid]", project.getFundingFunderIdentifierIdentifier());
        } else {
            this.addReplacement(this.replacements, "[funderid]", "");
        }
        if (!fundingItems.isEmpty()) {
            this.addReplacement(this.replacements, "[grantid]", String.join((CharSequence)", ", fundingItems));
        } else {
            this.addReplacement(this.replacements, "[grantid]", "");
        }
        this.addReplacement(this.footerMap, "[grantid]", this.replacements.get("[grantid]"));
    }

    private String getContributorPersonIdentifier(Contributor contributor) {
        Identifier personIdentifier;
        String identifier = null;
        Identifier identifier2 = personIdentifier = contributor != null ? contributor.getPersonIdentifier() : null;
        if (personIdentifier != null && personIdentifier.getIdentifier() != null) {
            String contactIdentifierId = personIdentifier.getIdentifier();
            if (EqualityUtils.nullExclusiveEquals((Object)personIdentifier.getIdentifierType(), (Object)EIdentifierType.ORCID)) {
                identifier = "ORCID: " + contactIdentifierId;
            }
        }
        return identifier;
    }

    private String getContributorAffiliationIdentifier(Contributor contributor) {
        String identifier = null;
        Identifier affiliationIdentifier = contributor.getAffiliationId();
        if (affiliationIdentifier != null) {
            String contactAffiliationIdentifierId = affiliationIdentifier.getIdentifier();
            if (EqualityUtils.nullExclusiveEquals((Object)affiliationIdentifier.getIdentifierType(), (Object)EIdentifierType.ROR)) {
                identifier = "ROR: " + contactAffiliationIdentifierId;
            }
        }
        return identifier;
    }

    private void contactPersonInformation() {
        Contributor contact = this.dmp.getContact();
        ArrayList<String> contactItems = new ArrayList<String>();
        Object contactName = "";
        String contactMail = "";
        String contactId = "";
        String contactAffiliation = "";
        String contactAffiliationId = "";
        if (contact == null) {
            this.addReplacement(this.replacements, "[contact]", this.joinWithComma(contactItems));
            return;
        }
        if (contact.getFirstName() != null && contact.getLastName() != null) {
            contactName = contact.getFirstName() + " " + contact.getLastName();
            contactItems.add((String)contactName);
        }
        if (contact.getMbox() != null) {
            contactMail = contact.getMbox();
            contactItems.add(contactMail);
        }
        if ((contactId = this.getContributorPersonIdentifier(contact)) != null) {
            contactItems.add(contactId);
        }
        if (contact.getAffiliation() != null) {
            contactAffiliation = contact.getAffiliation();
            contactItems.add(contactAffiliation);
        }
        if ((contactAffiliationId = this.getContributorAffiliationIdentifier(contact)) != null) {
            contactItems.add(contactAffiliationId);
        }
        this.addReplacement(this.replacements, "[contact]", this.joinWithComma(contactItems));
    }

    private void projectCoordinatorInformation() {
        if (this.projectCoordinators == null) {
            this.addReplacement(this.replacements, "[coordinator]", "");
            return;
        }
        StringBuilder coordinatorInfos = new StringBuilder();
        for (ContributorDO contributor : this.projectCoordinators) {
            ArrayList<String> coordinatorProperties = new ArrayList<String>();
            String coordinatorIdentifierId = "";
            String coordinatorAffiliationIdentifierId = "";
            if (contributor == null) {
                this.addReplacement(this.replacements, "[coordinator]", this.joinWithComma(coordinatorProperties));
                return;
            }
            if (contributor.getFirstName() != null && contributor.getLastName() != null) {
                coordinatorProperties.add(contributor.getFirstName() + " " + contributor.getLastName());
            }
            if (contributor.getMbox() != null) {
                coordinatorProperties.add(contributor.getMbox());
            }
            if (contributor.getPersonId() != null) {
                coordinatorIdentifierId = contributor.getPersonId().getIdentifier();
                if (EqualityUtils.nullExclusiveEquals((Object)contributor.getPersonId().getType(), (Object)EIdentifierType.ORCID)) {
                    String coordinatorId = "ORCID iD: " + coordinatorIdentifierId;
                    coordinatorProperties.add(coordinatorId);
                }
            }
            if (contributor.getAffiliation() != null) {
                coordinatorProperties.add(contributor.getAffiliation());
            }
            if (contributor.getAffiliationId() != null) {
                coordinatorAffiliationIdentifierId = contributor.getAffiliationId().getIdentifier();
                if (EqualityUtils.nullExclusiveEquals((Object)contributor.getAffiliationId().getType(), (Object)EIdentifierType.ROR)) {
                    String coordinatorAffiliationIdentifierType = "ROR: ";
                    String coordinatorAffiliationId = coordinatorAffiliationIdentifierType + coordinatorAffiliationIdentifierId;
                    coordinatorProperties.add(coordinatorAffiliationId);
                }
            }
            if (contributor.getRole() != null) {
                String coordinatorRole = contributor.getRole().toString();
                coordinatorProperties.add(coordinatorRole);
            }
            coordinatorInfos.append(this.joinWithComma(coordinatorProperties));
            coordinatorInfos.append(";");
            this.projectCoordinatorOrInvestigatorIds.add(contributor.getUniversityId());
        }
        this.addReplacement(this.replacements, "[coordinator]", coordinatorInfos.toString());
    }

    private void dmpContributorInformation() {
        ArrayList<String> contributorList = new ArrayList<String>();
        String contributorPerson = "";
        List contributors = Optional.ofNullable(this.dmp.getContributorList()).orElse(List.of());
        for (Contributor contributor : contributors) {
            ArrayList<String> contributorProperties = new ArrayList<String>();
            Object contributorName = "";
            String contributorMail = "";
            String contributorId = "";
            String contributorRole = "";
            String contributorAffiliation = "";
            String contributorAffiliationId = "";
            if (contributor.getFirstName() != null && contributor.getLastName() != null) {
                contributorName = contributor.getFirstName() + " " + contributor.getLastName();
                contributorProperties.add((String)contributorName);
            }
            if (contributor.getMbox() != null) {
                contributorMail = contributor.getMbox();
                contributorProperties.add(contributorMail);
            }
            if ((contributorId = this.getContributorPersonIdentifier(contributor)) != null) {
                contributorProperties.add(contributorId);
            }
            if (contributor.getAffiliation() != null) {
                contributorAffiliation = contributor.getAffiliation();
                contributorProperties.add(contributorAffiliation);
            }
            if ((contributorAffiliationId = this.getContributorAffiliationIdentifier(contributor)) != null) {
                contributorProperties.add(contributorAffiliationId);
            }
            if (contributor.getContributorRole() != null) {
                contributorRole = contributor.getContributorRole().getRole();
                contributorProperties.add(contributorRole);
            }
            if (EqualityUtils.nullExclusiveEquals((Object)contributor.getContributorRole(), (Object)EContributorRole.PRINCIPAL_INVESTIGATOR) || EqualityUtils.nullExclusiveEquals((Object)contributor.getContributorRole(), (Object)EContributorRole.PROJECT_LEADER) || EqualityUtils.nullExclusiveEquals((Object)contributor.getContributorRole(), (Object)EContributorRole.PROJECT_COORDINATOR) || this.projectCoordinatorOrInvestigatorIds.contains(contributor.getUniversityId())) continue;
            contributorPerson = this.joinWithComma(contributorProperties);
            contributorList.add(contributorPerson);
        }
        this.addReplacement(this.replacements, "[contributors]", String.join((CharSequence)";", contributorList));
    }

    public void contributorInformation() {
        this.contactPersonInformation();
        this.projectCoordinatorInformation();
        this.dmpContributorInformation();
    }

    public void costInformation() {
        StringBuilder newDescription = new StringBuilder();
        if (EqualityUtils.nullExclusiveEquals(Boolean.TRUE, this.dmp.getCostsExist())) {
            this.addReplacement(this.replacements, "[costs]", this.loadResourceService.loadVariableFromResource(this.prop, "costs.avail"));
        } else {
            this.addReplacement(this.replacements, "[costs]", this.loadResourceService.loadVariableFromResource(this.prop, "costs.no"));
            this.addReplacement(this.replacements, "[costsDescriptions]", "");
        }
        if (!this.costList.isEmpty()) {
            boolean longDescriptionExists = false;
            for (Cost cost : this.costList) {
                if (cost.getDescription() != null && cost.getDescription().length() >= 255) {
                    newDescription.append("Description for \"");
                    newDescription.append(cost.getTitle()).append("\": ");
                    newDescription.append(cost.getDescription()).append(";");
                    longDescriptionExists = true;
                }
                this.addReplacement(this.replacements, "[costsDescriptions]", newDescription.toString());
            }
            this.addReplacement(this.replacements, "[costCoverage]", (longDescriptionExists ? ";" : "") + this.loadResourceService.loadVariableFromResource(this.prop, "costCoverage"));
        } else {
            this.addReplacement(this.replacements, "[costsDescriptions]", "");
            this.addReplacement(this.replacements, "[costCoverage]", "");
        }
    }

    public void datasetsInformation() {
        this.addReplacement(this.replacements, "[datageneration]", this.dmp.getDataGeneration());
        this.addReplacement(this.replacements, "[documentation]", this.dmp.getDocumentation());
        if (this.dmp.getTargetAudience() != null) {
            this.addReplacement(this.replacements, "[targetaudience]", this.dmp.getTargetAudience());
        } else {
            this.addReplacement(this.replacements, "[targetaudience]", "");
        }
        StringBuilder reusedDescription = new StringBuilder();
        List<Dataset> reusedDatasets = this.getReusedDatasets();
        for (int i = 0; i < reusedDatasets.size(); ++i) {
            Dataset dataset = reusedDatasets.get(i);
            if (dataset.getDescription() == null || dataset.getDescription().isEmpty()) continue;
            reusedDescription.append("Description for \"");
            reusedDescription.append(dataset.getTitle()).append("\": ;");
            reusedDescription.append(dataset.getDescription()).append(";");
        }
        this.addReplacement(this.replacements, "[reuseddatadescription]", reusedDescription.toString());
        StringBuilder newDescription = new StringBuilder();
        List<Dataset> newDatasets = this.getNewDatasets();
        for (int i = 0; i < newDatasets.size(); ++i) {
            Dataset dataset = newDatasets.get(i);
            if (dataset.getDescription() == null || dataset.getDescription().isEmpty()) continue;
            newDescription.append("Description for \"");
            newDescription.append(dataset.getTitle()).append("\": ;");
            newDescription.append(dataset.getDescription()).append(";");
        }
        this.addReplacement(this.replacements, "[produceddatadescription]", newDescription.toString());
        StringBuilder newDatasetTechnicalResources = new StringBuilder();
        for (Dataset dataset : newDatasets) {
            if (dataset.getTechnicalResources() == null || dataset.getTechnicalResources().isEmpty()) continue;
            newDatasetTechnicalResources.append("Technical resources for \"");
            newDatasetTechnicalResources.append(dataset.getTitle()).append("\": ;");
            List<TechnicalResource> technicalResource = dataset.getTechnicalResources();
            for (int i = 0; i < technicalResource.size(); ++i) {
                newDatasetTechnicalResources.append(technicalResource.get(i).getName());
                if (i + 1 >= technicalResource.size()) continue;
                newDatasetTechnicalResources.append(", ");
            }
        }
        this.addReplacement(this.replacements, "[datasetTechnicalResources]", newDatasetTechnicalResources.toString());
    }

    public void storageIntroInformation() {
        Object coordinatorFullName = null;
        List<Contributor> contributorPool = this.dmp.getContributorList();
        for (ContributorDO contributorDO : this.projectCoordinators) {
            contributorPool.add(ContributorDOMapper.mapDOtoEntity(contributorDO, new Contributor()));
        }
        for (Contributor contributor : contributorPool) {
            if (contributor == null || contributor.getContributorRole() == null || !EqualityUtils.nullExclusiveEquals((Object)contributor.getContributorRole(), (Object)EContributorRole.DATA_MANAGER)) continue;
            coordinatorFullName = contributor.getFirstName() + " " + contributor.getLastName();
            break;
        }
        if (coordinatorFullName == null) {
            for (Contributor contributor : contributorPool) {
                if (contributor == null || contributor.getContributorRole() == null || !EqualityUtils.nullExclusiveEquals((Object)contributor.getContributorRole(), (Object)EContributorRole.PROJECT_LEADER)) continue;
                coordinatorFullName = contributor.getFirstName() + " " + contributor.getLastName();
                break;
            }
        }
        if (coordinatorFullName == null) {
            for (Contributor contributor : contributorPool) {
                if (contributor == null || contributor.getContributorRole() == null || !EqualityUtils.nullExclusiveEquals((Object)contributor.getContributorRole(), (Object)EContributorRole.PRINCIPAL_INVESTIGATOR)) continue;
                coordinatorFullName = contributor.getFirstName() + " " + contributor.getLastName();
                break;
            }
        }
        if (coordinatorFullName == null) {
            for (Contributor contributor : contributorPool) {
                if (contributor == null || !EqualityUtils.nullExclusiveEquals((Object)contributor.getContributorRole(), (Object)EContributorRole.PROJECT_COORDINATOR)) continue;
                coordinatorFullName = contributor.getFirstName() + " " + contributor.getLastName();
                break;
            }
        }
        if (coordinatorFullName == null && this.dmp.getContact() != null) {
            coordinatorFullName = this.dmp.getContact().getFirstName() + " " + this.dmp.getContact().getLastName();
        }
        if (coordinatorFullName == null) {
            coordinatorFullName = "the project leader ";
        }
        boolean usesExternalStorage = this.dmp.getHostList().stream().anyMatch(ExternalStorage.class::isInstance);
        boolean usesInternalStorage = this.dmp.getHostList().stream().anyMatch(Storage.class::isInstance);
        String propName = "storageIntro.none";
        if (usesExternalStorage && !usesInternalStorage) {
            propName = "storageIntro.external";
        } else if (usesInternalStorage && !usesExternalStorage) {
            propName = "storageIntro.internal";
        } else if (usesInternalStorage && usesExternalStorage) {
            propName = "storageIntro.both";
        }
        String storageIntroReplacement = this.loadResourceService.loadVariableFromResource(this.prop, propName);
        storageIntroReplacement = storageIntroReplacement.replace("[name]", (CharSequence)coordinatorFullName);
        this.addReplacement(this.replacements, "[storageintro]", storageIntroReplacement);
    }

    public void storageInformation() {
        List<Host> hostList = this.dmp.getHostList();
        String storageVar = "";
        for (Host host : hostList) {
            List<Distribution> distributions = host.getDistributionList();
            String hostVar = "";
            StringBuilder distVar = new StringBuilder();
            if (host.getTitle() != null) {
                hostVar = host.getTitle();
            }
            for (Distribution dist : distributions) {
                distVar.append(this.datasetTableIDs.get(dist.getDataset().getId())).append(" (").append(dist.getDataset().getTitle()).append(")");
                if (distributions.indexOf((Object)dist) + 1 >= distributions.size()) continue;
                distVar.append(", ");
            }
            if (Storage.class.isAssignableFrom(((Object)((Object)host)).getClass())) {
                if (!distVar.toString().isEmpty()) {
                    String storageDescription = "";
                    InternalStorageTranslation storageTranslation = this.internalStorageTranslationRepo.getInternalStorageById(((Storage)host).getInternalStorageId().id, "eng");
                    if (storageTranslation == null) {
                        storageTranslation = this.internalStorageTranslationRepo.getAllInternalStorageTranslationsByStorageId(((Storage)host).getInternalStorageId().id).get(0);
                    }
                    storageDescription = storageTranslation.getDescription();
                    storageVar = storageVar.concat(String.valueOf(distVar) + " " + this.loadResourceService.loadVariableFromResource(this.prop, "distributionStorage") + " " + hostVar);
                    if (storageDescription != null && !storageDescription.isEmpty()) {
                        storageVar = storageVar.concat(": " + storageDescription);
                    }
                }
            } else if (ExternalStorage.class.isAssignableFrom(((Object)((Object)host)).getClass()) && !distVar.toString().isEmpty()) {
                storageVar = storageVar.concat(String.valueOf(distVar) + " " + this.loadResourceService.loadVariableFromResource(this.prop, "distributionStorage") + " " + hostVar + ".");
                if (this.dmp.getExternalStorageInfo() != null && !this.dmp.getExternalStorageInfo().isEmpty()) {
                    storageVar = storageVar.concat(" " + this.loadResourceService.loadVariableFromResource(this.prop, "distributionExternal") + " " + this.dmp.getExternalStorageInfo().toLowerCase());
                }
            }
            if (hostList.indexOf((Object)host) + 1 >= hostList.size() || distributions.isEmpty()) continue;
            storageVar = storageVar.concat(";");
        }
        this.addReplacement(this.replacements, "[storage]", storageVar);
    }

    public void dataQuality() {
        Object metadata = "";
        if (this.dmp.getMetadata() == null) {
            this.addReplacement(this.replacements, "[metadata]", this.loadResourceService.loadVariableFromResource(this.prop, "metadata.no"));
        } else if (this.dmp.getMetadata().isEmpty()) {
            this.addReplacement(this.replacements, "[metadata]", this.loadResourceService.loadVariableFromResource(this.prop, "metadata.no"));
        } else {
            metadata = this.dmp.getMetadata();
            if (((String)metadata).charAt(((String)metadata).length() - 1) != '.') {
                metadata = (String)metadata + ".";
            }
            this.addReplacement(this.replacements, "[metadata]", (String)metadata + " " + this.loadResourceService.loadVariableFromResource(this.prop, "metadata.avail"));
        }
        if (this.dmp.getStructure() == null) {
            this.addReplacement(this.replacements, "[dataorganisation]", this.loadResourceService.loadVariableFromResource(this.prop, "dataOrganisation.no"));
        } else if (this.dmp.getStructure().isEmpty()) {
            this.addReplacement(this.replacements, "[dataorganisation]", this.loadResourceService.loadVariableFromResource(this.prop, "dataOrganisation.no"));
        } else {
            this.addReplacement(this.replacements, "[dataorganisation]", this.dmp.getStructure());
        }
        if (this.dmp.getDataQuality() != null && !this.dmp.getDataQuality().isEmpty()) {
            StringBuilder dataQuality = new StringBuilder();
            dataQuality.append(this.loadResourceService.loadVariableFromResource(this.prop, "dataQualityControl.avail"));
            ArrayList<String> dataQualityList = new ArrayList<String>();
            for (int i = 0; i < this.dmp.getDataQuality().size(); ++i) {
                if (EqualityUtils.nullExclusiveEquals((Object)this.dmp.getDataQuality().get(i), (Object)EDataQualityType.OTHERS) && this.dmp.getOtherDataQuality() != null && !this.dmp.getOtherDataQuality().isEmpty()) {
                    dataQualityList.add(this.dmp.getOtherDataQuality());
                    continue;
                }
                dataQualityList.add(this.dmp.getDataQuality().get(i).toString());
            }
            dataQuality.append(" ").append(this.joinWithCommaAnd(dataQualityList)).append(".");
            this.addReplacement(this.replacements, "[dataqualitycontrol]", dataQuality.toString());
        } else {
            this.addReplacement(this.replacements, "[dataqualitycontrol]", this.loadResourceService.loadVariableFromResource(this.prop, "dataQualityControl.default"));
        }
    }

    public void sensitiveDataInformation() {
        log.debug((Object)"sensitive data part");
        Object sensitiveData = "";
        if (EqualityUtils.nullExclusiveEquals(Boolean.TRUE, this.dmp.getSensitiveData())) {
            String sensitiveDataSentence = this.loadResourceService.loadVariableFromResource(this.prop, "sensitive.avail");
            Object sensitiveDataset = "";
            Object datasetSentence = "";
            Object sensitiveDataMeasure = "";
            Object authorisedAccess = "";
            ArrayList<String> sensitiveDatasetList = new ArrayList<String>();
            for (Dataset dataset : this.datasets) {
                if (dataset.getSensitiveData() == null || !dataset.getSensitiveData().booleanValue()) continue;
                sensitiveDataset = this.datasetTableIDs.get(dataset.getId()) + " (" + dataset.getTitle() + ")";
                sensitiveDatasetList.add((String)sensitiveDataset);
            }
            if (!sensitiveDatasetList.isEmpty()) {
                datasetSentence = " " + this.loadResourceService.loadVariableFromResource(this.prop, "sensitive.avail.data") + " ";
                sensitiveDataset = this.joinWithCommaAnd(sensitiveDatasetList) + ". ";
            } else {
                datasetSentence = ". ";
            }
            ArrayList<String> dataSecurityList = new ArrayList<String>();
            if (this.dmp.getSensitiveDataSecurity() != null) {
                for (ESecurityMeasure securityMeasure : this.dmp.getSensitiveDataSecurity()) {
                    if (EqualityUtils.nullExclusiveEquals((Object)securityMeasure, (Object)ESecurityMeasure.OTHER) && this.dmp.getOtherDataSecurityMeasures() != null && !this.dmp.getOtherDataSecurityMeasures().isEmpty()) {
                        dataSecurityList.add(this.dmp.getOtherDataSecurityMeasures());
                        continue;
                    }
                    dataSecurityList.add(securityMeasure.toString());
                }
            }
            sensitiveDataMeasure = dataSecurityList.isEmpty() ? this.loadResourceService.loadVariableFromResource(this.prop, "sensitiveMeasure.no") : (dataSecurityList.size() == 1 ? this.loadResourceService.loadVariableFromResource(this.prop, "sensitiveMeasure.avail") + " " + this.joinWithCommaAnd(dataSecurityList) + " " + this.loadResourceService.loadVariableFromResource(this.prop, "sensitiveMeasure.singular") : this.loadResourceService.loadVariableFromResource(this.prop, "sensitiveMeasure.avail") + " " + this.joinWithCommaAnd(dataSecurityList) + " " + this.loadResourceService.loadVariableFromResource(this.prop, "sensitiveMeasure.multiple"));
            if (this.dmp.getSensitiveDataAccess() != null && !this.dmp.getSensitiveDataAccess().isEmpty()) {
                authorisedAccess = " " + this.loadResourceService.loadVariableFromResource(this.prop, "sensitiveAccess") + " " + this.dmp.getSensitiveDataAccess() + " " + this.loadResourceService.loadVariableFromResource(this.prop, "sensitiveAccess.avail");
            }
            sensitiveData = sensitiveDataSentence + (String)datasetSentence + (String)sensitiveDataset + (String)sensitiveDataMeasure + (String)authorisedAccess;
        } else {
            sensitiveData = this.loadResourceService.loadVariableFromResource(this.prop, "sensitive.no");
        }
        this.addReplacement(this.replacements, "[sensitivedata]", sensitiveData);
    }

    protected void repoInformation() {
        String repoInformation = "";
        HashSet<Repository> repositories = new HashSet<Repository>();
        ArrayList repoTexts = new ArrayList();
        for (Dataset dataset : this.datasets) {
            repositories.addAll(dataset.getRepositories());
        }
        if (!repositories.isEmpty()) {
            repositories.forEach(repo -> repoTexts.add(this.repositoriesService.getDescription(repo.getRepositoryId()) + " " + this.repositoriesService.getRepositoryURL(repo.getRepositoryId())));
            repoInformation = String.join((CharSequence)"; ", repoTexts);
        }
        this.addReplacement(this.replacements, "[repoinformation]", (!repoInformation.isEmpty() ? "Repository description: ;" : "") + repoInformation + (!repoInformation.isEmpty() ? "" : ";"));
    }

    protected void closeAndRestrictedDataInformation() {
        Object closedRestrictedReasons = "";
        if (this.dmp.getClosedAccessInfo() != null && !this.dmp.getClosedAccessInfo().isBlank()) {
            closedRestrictedReasons = this.loadResourceService.loadVariableFromResource(this.prop, "closeddatasetreasons.intro") + ";" + this.dmp.getClosedAccessInfo();
        }
        if (this.dmp.getRestrictedAccessInfo() != null && !this.dmp.getRestrictedAccessInfo().isBlank()) {
            if (!((String)closedRestrictedReasons).isEmpty()) {
                closedRestrictedReasons = (String)closedRestrictedReasons + ";";
            }
            closedRestrictedReasons = (String)closedRestrictedReasons + this.loadResourceService.loadVariableFromResource(this.prop, "restricteddatasetreasons.intro") + ";" + this.dmp.getRestrictedAccessInfo();
            closedRestrictedReasons = (String)closedRestrictedReasons + ";";
        }
        if (!((String)closedRestrictedReasons).isEmpty()) {
            closedRestrictedReasons = (String)closedRestrictedReasons + ";";
        }
        this.addReplacement(this.replacements, "[closedrestricteddatasetreasons]", closedRestrictedReasons);
    }

    public void repoinfoAndToolsInformation() {
        this.repoInformation();
        this.closeAndRestrictedDataInformation();
        if (this.dmp.getTools() != null) {
            if (!EqualityUtils.nullExclusiveEquals(this.dmp.getTools(), "")) {
                this.addReplacement(this.replacements, "[tools]", this.loadResourceService.loadVariableFromResource(this.prop, "tools.avail") + " " + this.dmp.getTools());
            } else {
                this.addReplacement(this.replacements, "[tools]", this.loadResourceService.loadVariableFromResource(this.prop, "tools.no"));
            }
        } else {
            this.addReplacement(this.replacements, "[tools]", this.loadResourceService.loadVariableFromResource(this.prop, "tools.no"));
        }
        if (this.dmp.getRestrictedDataAccess() != null) {
            if (!EqualityUtils.nullExclusiveEquals(this.dmp.getRestrictedDataAccess(), "")) {
                this.addReplacement(this.replacements, "[restrictedAccessInfo]", this.loadResourceService.loadVariableFromResource(this.prop, "restrictedAccess.avail") + " " + this.dmp.getRestrictedDataAccess());
            } else {
                this.addReplacement(this.replacements, "[restrictedAccessInfo]", this.loadResourceService.loadVariableFromResource(this.prop, ""));
            }
        } else {
            this.addReplacement(this.replacements, "[restrictedAccessInfo]", this.loadResourceService.loadVariableFromResource(this.prop, ""));
        }
    }

    public void legalEthicalInformation() {
        this.personalDataText();
        this.intellectualPropertyText();
        this.ethicalIssuesText();
    }

    public void personalDataText() {
        log.debug((Object)"personal data part");
        Object personalData = "";
        if (EqualityUtils.nullExclusiveEquals(Boolean.TRUE, this.dmp.getPersonalData())) {
            personalData = this.loadResourceService.loadVariableFromResource(this.prop, "personal.avail") + " ";
            ArrayList<String> personalDatasetList = new ArrayList<String>();
            for (Dataset dataset : this.datasets) {
                if (!EqualityUtils.nullExclusiveEquals(Boolean.TRUE, dataset.getPersonalData())) continue;
                personalDatasetList.add(this.datasetTableIDs.get(dataset.getId()) + " (" + dataset.getTitle() + ")");
            }
            if (!personalDatasetList.isEmpty()) {
                personalData = (String)personalData + this.joinWithCommaAnd(personalDatasetList);
                personalData = (String)personalData + " " + this.loadResourceService.loadVariableFromResource(this.prop, "personalDataset") + " ";
            }
            if (!this.dmp.getPersonalDataCompliance().isEmpty()) {
                ArrayList<String> dataComplianceList = new ArrayList<String>();
                for (EComplianceType personalCompliance : this.dmp.getPersonalDataCompliance()) {
                    if (EqualityUtils.nullExclusiveEquals((Object)personalCompliance, (Object)EComplianceType.OTHER) && this.dmp.getOtherPersonalDataCompliance() != null && !this.dmp.getOtherPersonalDataCompliance().isEmpty()) {
                        dataComplianceList.add(this.dmp.getOtherPersonalDataCompliance());
                        continue;
                    }
                    dataComplianceList.add(personalCompliance.toString());
                }
                personalData = (String)personalData + this.loadResourceService.loadVariableFromResource(this.prop, "personalCompliance") + " ";
                personalData = (String)personalData + this.joinWithCommaAnd(dataComplianceList) + ".";
            }
        } else {
            personalData = this.loadResourceService.loadVariableFromResource(this.prop, "personal.no");
        }
        this.addReplacement(this.replacements, "[personaldata]", personalData);
    }

    public void intellectualPropertyText() {
        log.debug((Object)"legal restriction part");
        Object legalRestrictionText = "";
        if (EqualityUtils.nullExclusiveEquals(Boolean.TRUE, this.dmp.getLegalRestrictions())) {
            if (!this.dmp.getLegalRestrictionsDocuments().isEmpty()) {
                legalRestrictionText = this.loadResourceService.loadVariableFromResource(this.prop, "legal.avail") + " ";
                ArrayList<String> agreementList = new ArrayList<String>();
                for (EAgreement agreement : this.dmp.getLegalRestrictionsDocuments()) {
                    if (EqualityUtils.nullExclusiveEquals((Object)agreement, (Object)EAgreement.OTHER) && this.dmp.getOtherLegalRestrictionsDocument() != null && !this.dmp.getOtherLegalRestrictionsDocument().isEmpty()) {
                        agreementList.add(this.dmp.getOtherLegalRestrictionsDocument());
                        continue;
                    }
                    agreementList.add(agreement.toString());
                }
                legalRestrictionText = (String)legalRestrictionText + this.joinWithCommaAnd(agreementList) + ". ";
            } else {
                legalRestrictionText = this.loadResourceService.loadVariableFromResource(this.prop, "legal.avail.default") + " ";
            }
            ArrayList<String> datasetList = new ArrayList<String>();
            for (Dataset dataset : this.datasets) {
                if (!EqualityUtils.nullExclusiveEquals(Boolean.TRUE, dataset.getLegalRestrictions())) continue;
                datasetList.add(this.datasetTableIDs.get(dataset.getId()) + " (" + dataset.getTitle() + ")");
            }
            if (!datasetList.isEmpty()) {
                legalRestrictionText = (String)legalRestrictionText + this.loadResourceService.loadVariableFromResource(this.prop, "legalDataset") + " ";
                legalRestrictionText = (String)legalRestrictionText + this.joinWithCommaAnd(datasetList) + ". ";
            }
            if (this.dmp.getLegalRestrictionsComment() != null && !this.dmp.getLegalRestrictionsComment().isEmpty()) {
                legalRestrictionText = (String)legalRestrictionText + this.loadResourceService.loadVariableFromResource(this.prop, "legalComment") + " " + this.dmp.getLegalRestrictionsComment();
            }
            legalRestrictionText = this.dmp.getDataRightsAndAccessControl() != null && !this.dmp.getDataRightsAndAccessControl().isEmpty() ? (String)legalRestrictionText + ";" + this.loadResourceService.loadVariableFromResource(this.prop, "legalRights.owners") + ": " + this.dmp.getDataRightsAndAccessControl() : (String)legalRestrictionText + ";" + this.loadResourceService.loadVariableFromResource(this.prop, "legalRights.owners.no");
        } else {
            legalRestrictionText = this.dmp.getDataRightsAndAccessControl() != null ? this.loadResourceService.loadVariableFromResource(this.prop, "legalRights.owners") + ": " + this.dmp.getDataRightsAndAccessControl() : this.loadResourceService.loadVariableFromResource(this.prop, "legalRights.owners.no");
        }
        this.addReplacement(this.replacements, "[legalrestriction]", legalRestrictionText);
    }

    public void ethicalIssuesText() {
        log.debug((Object)"ethical part");
        Object ethicalStatement = "";
        ethicalStatement = EqualityUtils.nullExclusiveEquals(Boolean.TRUE, this.dmp.getHumanParticipants()) || EqualityUtils.nullExclusiveEquals(Boolean.TRUE, this.dmp.getEthicalIssuesExist()) ? this.loadResourceService.loadVariableFromResource(this.prop, "ethicalStatement") + " " : this.loadResourceService.loadVariableFromResource(this.prop, "ethical.no") + " ";
        if (EqualityUtils.nullExclusiveEquals(Boolean.TRUE, this.dmp.getCommitteeReviewed())) {
            ethicalStatement = (String)ethicalStatement + this.loadResourceService.loadVariableFromResource(this.prop, "ethicalReviewed.avail");
            if (this.dmp.getEthicalIssuesReport() != null && !this.dmp.getEthicalIssuesReport().isEmpty()) {
                ethicalStatement = (String)ethicalStatement + " " + this.loadResourceService.loadVariableFromResource(this.prop, "ethicalReportIntro") + " " + this.dmp.getEthicalIssuesReport();
            }
        }
        this.addReplacement(this.replacements, "[ethicalissues]", ethicalStatement);
    }

    protected static String format(long number) {
        if (number < 1000L) {
            return String.valueOf(number);
        }
        String string = String.valueOf(number);
        int magnitude = (string.length() - 1) / 3;
        int digits = (string.length() - 1) % 3 + 1;
        char[] value = new char[digits + 4];
        for (int i = 0; i < digits; ++i) {
            value[i] = string.charAt(i);
        }
        int valueLength = digits;
        if (digits == 1 && string.charAt(1) != '0') {
            value[valueLength++] = 46;
            value[valueLength++] = string.charAt(1);
        }
        value[valueLength++] = 32;
        value[valueLength++] = SUFFIXES[magnitude - 1];
        return new String(value, 0, valueLength);
    }

    public void tableContent(XWPFDocument document, List<XWPFTable> xwpfTables) {
        for (XWPFTable xwpfTable : new ArrayList<XWPFTable>(xwpfTables)) {
            XWPFTableRow tableIdentifierRow = xwpfTable.getRow(1);
            if (tableIdentifierRow == null) continue;
            XWPFTableCell tableIdentifierCell = tableIdentifierRow.getCell(1);
            String tableIdentifier = "";
            if (tableIdentifierCell != null) {
                if (((XWPFParagraph)tableIdentifierCell.getParagraphs().get(0)).getRuns().isEmpty()) {
                    ((XWPFParagraph)tableIdentifierCell.getParagraphs().get(0)).createRun();
                }
                tableIdentifier = ((XWPFRun)((XWPFParagraph)tableIdentifierCell.getParagraphs().get(0)).getRuns().get(0)).getText(0);
            }
            switch (tableIdentifier = tableIdentifier == null ? "" : tableIdentifier) {
                case "[datasetTable]": {
                    this.composeTableNewDatasets(xwpfTable);
                    break;
                }
                case "[reusedDatasetTable]": {
                    this.composeTableReusedDatasets(document, xwpfTable);
                    break;
                }
                case "[datasetAccessTable]": {
                    this.composeTableDataAccess(xwpfTable);
                    break;
                }
                case "[datasetPublicationTable]": {
                    this.composeTableDatasetPublication(xwpfTable);
                    break;
                }
                case "[datasetRepositoryTable]": {
                    this.composeTableDatasetRepository(xwpfTable);
                    break;
                }
                case "[datasetDeleteTable]": {
                    this.composeTableDatasetDeletion(document, xwpfTable);
                    break;
                }
                case "[costTable]": {
                    this.composeTableCost(document, xwpfTable);
                    break;
                }
            }
        }
        for (XWPFTable table : this.getAllTables(document)) {
            AbstractTemplateExportScienceEuropeComponents.replaceTableVariables(table, this.replacements);
        }
    }

    public void composeTableNewDatasets(XWPFTable xwpfTable) {
        log.debug((Object)"Export steps: New Dataset Table");
        List<Dataset> newDatasets = this.getNewDatasets();
        if (!newDatasets.isEmpty()) {
            for (int i = 0; i < newDatasets.size(); ++i) {
                XWPFTableRow sourceTableRow = xwpfTable.getRow(2);
                XWPFTableRow newRow = new XWPFTableRow(sourceTableRow.getCtRow(), xwpfTable);
                Dataset dataset = newDatasets.get(i);
                try {
                    newRow = this.insertNewTableRow(sourceTableRow, i + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList<String> docVar = new ArrayList<String>();
                docVar.add(this.datasetTableIDs.get(dataset.id));
                docVar.add(Optional.ofNullable(dataset.getTitle()).orElse(""));
                if (dataset.getType() != null) {
                    docVar.add(dataset.getType().stream().map(EDataType::getValue).collect(Collectors.joining(", ")));
                } else {
                    docVar.add("");
                }
                docVar.add(Optional.ofNullable(dataset.getFileFormat()).orElse(""));
                if (dataset.getSize() != null) {
                    docVar.add(DatasetSizeRange.getLabelForSize(dataset.getSize()));
                } else {
                    docVar.add("");
                }
                if (EqualityUtils.nullExclusiveEquals(Boolean.TRUE, dataset.getSensitiveData())) {
                    docVar.add("yes");
                } else {
                    docVar.add("no");
                }
                docVar.add(Optional.ofNullable(dataset.getDescription()).orElse(""));
                AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, newRow, docVar);
            }
            xwpfTable.removeRow(xwpfTable.getRows().size() - 1);
        } else {
            ArrayList<String> emptyContent = new ArrayList<String>(Arrays.asList("", "", "", "", "", "", ""));
            AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, (XWPFTableRow)xwpfTable.getRows().get(xwpfTable.getRows().size() - 1), emptyContent);
        }
        xwpfTable.removeRow(1);
    }

    public List<Dataset> getNewDatasets() {
        return this.datasets.stream().filter(dataset -> EqualityUtils.nullExclusiveEquals((Object)dataset.getSource(), (Object)EDataSource.NEW)).toList();
    }

    public List<Dataset> getReusedDatasets() {
        return this.datasets.stream().filter(dataset -> EqualityUtils.nullExclusiveEquals((Object)dataset.getSource(), (Object)EDataSource.REUSED)).toList();
    }

    public void composeTableReusedDatasets(XWPFDocument document, XWPFTable xwpfTable) {
        log.debug((Object)"Export steps: Reused Dataset Table");
        List<Dataset> reusedDatasets = this.getReusedDatasets();
        if (!reusedDatasets.isEmpty()) {
            for (int i = 0; i < reusedDatasets.size(); ++i) {
                XWPFTableRow sourceTableRow = xwpfTable.getRow(2);
                XWPFTableRow newRow = new XWPFTableRow(sourceTableRow.getCtRow(), xwpfTable);
                Dataset dataset = reusedDatasets.get(i);
                try {
                    newRow = this.insertNewTableRow(sourceTableRow, i + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList<String> docVar = new ArrayList<String>();
                docVar.add(this.datasetTableIDs.get(dataset.id));
                docVar.add(Optional.ofNullable(dataset.getTitle()).orElse(""));
                if (dataset.getDatasetIdentifier() != null && dataset.getDatasetIdentifier().getIdentifier() != null) {
                    docVar.add(dataset.getDatasetIdentifier().getIdentifier());
                } else {
                    docVar.add("");
                }
                if (dataset.getLicense() != null) {
                    docVar.add("");
                } else {
                    docVar.add("");
                }
                if (dataset.getSensitiveData() != null) {
                    if (EqualityUtils.nullExclusiveEquals(Boolean.TRUE, dataset.getSensitiveData())) {
                        docVar.add("yes");
                    } else {
                        docVar.add("no");
                    }
                } else {
                    docVar.add("no");
                }
                AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, newRow, docVar);
            }
            xwpfTable.removeRow(xwpfTable.getRows().size() - 1);
            xwpfTable.removeRow(1);
        } else {
            this.removeTableAndParagraphAbove(document, xwpfTable);
        }
    }

    public void composeTableDataAccess(XWPFTable xwpfTable) {
        log.debug((Object)"Export steps: Data Access Table");
        List<Dataset> newDatasets = this.getNewDatasets();
        List<Dataset> reusedDatasets = this.getReusedDatasets();
        if (!this.datasets.isEmpty()) {
            this.insertComposeTableDataAccess(xwpfTable, reusedDatasets);
            this.insertComposeTableDataAccess(xwpfTable, newDatasets);
            xwpfTable.removeRow(xwpfTable.getRows().size() - 1);
        } else {
            ArrayList<String> emptyContent = new ArrayList<String>(Arrays.asList("", "", "", ""));
            AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, (XWPFTableRow)xwpfTable.getRows().get(xwpfTable.getRows().size() - 1), emptyContent);
        }
        xwpfTable.removeRow(1);
        AbstractTemplateExportScienceEuropeComponents.replaceTableVariables(xwpfTable, this.replacements);
    }

    private void insertComposeTableDataAccess(XWPFTable xwpfTable, List<Dataset> currentDatasets) {
        for (int i = 0; i < currentDatasets.size(); ++i) {
            XWPFTableRow sourceTableRow = xwpfTable.getRow(2);
            XWPFTableRow newRow = new XWPFTableRow(sourceTableRow.getCtRow(), xwpfTable);
            try {
                newRow = this.insertNewTableRow(sourceTableRow, i + 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<String> docVar = new ArrayList<String>();
            docVar.add(this.datasetTableIDs.get(currentDatasets.get((int)i).id));
            if (currentDatasets.get(i).getSelectedProjectMembersAccess() != null) {
                docVar.add(currentDatasets.get(i).getSelectedProjectMembersAccess().toString().toLowerCase());
            } else {
                docVar.add("");
            }
            if (currentDatasets.get(i).getOtherProjectMembersAccess() != null) {
                docVar.add(currentDatasets.get(i).getOtherProjectMembersAccess().toString().toLowerCase());
            } else {
                docVar.add("");
            }
            if (currentDatasets.get(i).getPublicAccess() != null) {
                docVar.add(currentDatasets.get(i).getPublicAccess().toString().toLowerCase());
            } else {
                docVar.add("");
            }
            AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, newRow, docVar);
        }
    }

    public void composeTableDatasetPublication(XWPFTable xwpfTable) {
        log.debug((Object)"Export steps: Data Publication Table");
        List<Dataset> newDatasets = this.getNewDatasets();
        if (!newDatasets.isEmpty()) {
            for (int i = 0; i < newDatasets.size(); ++i) {
                XWPFTableRow sourceTableRow = xwpfTable.getRow(i + 2);
                XWPFTableRow newRow = null;
                try {
                    newRow = this.insertNewTableRow(sourceTableRow, i + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList<String> docVar = new ArrayList<String>();
                docVar.add(this.datasetTableIDs.get(newDatasets.get((int)i).id));
                if (newDatasets.get(i).getDataAccess() != null) {
                    docVar.add(newDatasets.get(i).getDataAccess().toString());
                } else {
                    docVar.add("");
                }
                if (newDatasets.get(i).getDataAccess() == EDataAccessType.CLOSED) {
                    docVar.add("");
                } else if (newDatasets.get(i).getStart() != null) {
                    docVar.add(this.formatter.format(newDatasets.get(i).getStart()));
                } else if (this.dmp.getProject() != null && this.dmp.getProject().getEnd() != null) {
                    docVar.add(this.formatter.format(Date.from(ZonedDateTime.from(this.dmp.getProject().getEnd().toInstant().atZone(ZoneId.systemDefault())).minusMonths(2L).toInstant())));
                } else {
                    docVar.add("");
                }
                List<Repository> repositories = newDatasets.get(i).getRepositories();
                List<String> repositoryTitles = repositories.stream().map(Host::getTitle).toList();
                docVar.add(this.joinWithComma(repositoryTitles));
                HashSet<EIdentifierType> pids = new HashSet<EIdentifierType>();
                for (Repository repository : repositories) {
                    pids.addAll(this.repositoriesService.getPidSystems(repository.getRepositoryId()));
                }
                docVar.add(this.joinWithComma(pids.stream().map(EIdentifierType::getType).toList()));
                if (newDatasets.get(i).getLicense() != null && !EqualityUtils.nullExclusiveEquals((Object)newDatasets.get(i).getDataAccess(), (Object)EDataAccessType.CLOSED)) {
                    docVar.add(newDatasets.get(i).getLicense().getAcronym());
                } else {
                    docVar.add("");
                }
                AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, newRow, docVar);
                if (newDatasets.get(i).getLicense() == null || EqualityUtils.nullExclusiveEquals((Object)newDatasets.get(i).getDataAccess(), (Object)EDataAccessType.CLOSED)) continue;
                ELicense license = newDatasets.get(i).getLicense();
                XWPFParagraph paragraph = (XWPFParagraph)newRow.getCell(5).getParagraphs().get(0);
                this.turnRunIntoHyperlinkRun((XWPFRun)paragraph.getRuns().get(0), license.getUrl());
                AbstractTemplateExportScienceEuropeComponents.commitTableRows(xwpfTable);
            }
            xwpfTable.removeRow(xwpfTable.getRows().size() - 1);
        } else {
            ArrayList<String> emptyContent = new ArrayList<String>(Arrays.asList("", "", "", "", "", "", ""));
            AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, (XWPFTableRow)xwpfTable.getRows().get(xwpfTable.getRows().size() - 1), emptyContent);
        }
        xwpfTable.removeRow(1);
    }

    public void composeTableDatasetRepository(XWPFTable xwpfTable) {
        log.debug((Object)"Export steps: Dataset Repository Table");
        List<Dataset> newDatasets = this.getNewDatasets().stream().filter(dataset -> dataset.getDelete() == false).toList();
        if (!newDatasets.isEmpty()) {
            for (int i = 0; i < newDatasets.size(); ++i) {
                XWPFTableRow sourceTableRow = xwpfTable.getRow(2);
                XWPFTableRow newRow = new XWPFTableRow(sourceTableRow.getCtRow(), xwpfTable);
                try {
                    newRow = this.insertNewTableRow(sourceTableRow, i + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList<String> docVar = new ArrayList<String>();
                docVar.add(this.datasetTableIDs.get(newDatasets.get((int)i).id));
                List<Repository> repositories = newDatasets.get(i).getRepositories();
                List<String> repositoryTitles = repositories.stream().map(Host::getTitle).toList();
                docVar.add(this.joinWithComma(repositoryTitles));
                if (newDatasets.get(i).getRetentionPeriod() != null) {
                    docVar.add(newDatasets.get(i).getRetentionPeriod() + " years");
                } else {
                    docVar.add("");
                }
                if (newDatasets.get(i).getDmpTargetAudience() != null) {
                    docVar.add(newDatasets.get(i).getDmpTargetAudience());
                } else {
                    docVar.add("");
                }
                AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, newRow, docVar);
            }
            xwpfTable.removeRow(xwpfTable.getRows().size() - 1);
        } else {
            ArrayList<String> emptyContent = new ArrayList<String>(Arrays.asList("", "", "", ""));
            AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, (XWPFTableRow)xwpfTable.getRows().get(xwpfTable.getRows().size() - 1), emptyContent);
        }
        xwpfTable.removeRow(1);
        CTVMerge vMerge = CTVMerge.Factory.newInstance();
        List rowList = xwpfTable.getRows();
        for (int i = 1; i < rowList.size(); ++i) {
            xwpfTable.getRow(i).getCell(3).getCTTc().getTcPr().setVMerge(vMerge);
        }
        AbstractTemplateExportScienceEuropeComponents.commitTableRows(xwpfTable);
    }

    public void composeTableDatasetDeletion(XWPFDocument document, XWPFTable xwpfTable) {
        log.debug((Object)"Export steps: Dataset Deletion Table");
        if (!this.deletedDatasets.isEmpty()) {
            for (int i = 0; i < this.deletedDatasets.size(); ++i) {
                XWPFTableRow sourceTableRow = xwpfTable.getRow(2);
                XWPFTableRow newRow = new XWPFTableRow(sourceTableRow.getCtRow(), xwpfTable);
                try {
                    newRow = this.insertNewTableRow(sourceTableRow, i + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList<String> docVar = new ArrayList<String>();
                docVar.add(this.datasetTableIDs.get(((Dataset)((Object)this.deletedDatasets.get((int)i))).id));
                if (((Dataset)((Object)this.deletedDatasets.get(i))).getTitle() != null) {
                    docVar.add(((Dataset)((Object)this.deletedDatasets.get(i))).getTitle());
                } else {
                    docVar.add("");
                }
                if (((Dataset)((Object)this.deletedDatasets.get(i))).getDateOfDeletion() != null) {
                    docVar.add(this.formatter.format(((Dataset)((Object)this.deletedDatasets.get(i))).getDateOfDeletion()));
                } else {
                    docVar.add("");
                }
                if (((Dataset)((Object)this.deletedDatasets.get(i))).getReasonForDeletion() != null) {
                    docVar.add(((Dataset)((Object)this.deletedDatasets.get(i))).getReasonForDeletion());
                } else {
                    docVar.add("");
                }
                if (((Dataset)((Object)this.deletedDatasets.get(i))).getDeletionPerson() != null) {
                    docVar.add(((Dataset)((Object)this.deletedDatasets.get(i))).getDeletionPerson().getFirstName() + " " + ((Dataset)((Object)this.deletedDatasets.get(i))).getDeletionPerson().getLastName());
                } else {
                    docVar.add("");
                }
                AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, newRow, docVar);
            }
            xwpfTable.removeRow(xwpfTable.getRows().size() - 1);
            xwpfTable.removeRow(1);
        } else {
            this.removeTableAndParagraphAbove(document, xwpfTable);
        }
    }

    public void composeTableCost(XWPFDocument xwpfDocument, XWPFTable xwpfTable) {
        log.debug((Object)"Export steps: Cost Table");
        Float totalCost = Float.valueOf(0.0f);
        if (!this.costList.isEmpty()) {
            for (int i = 0; i < this.costList.size(); ++i) {
                XWPFTableRow sourceTableRow = xwpfTable.getRow(2);
                XWPFTableRow newRow = new XWPFTableRow(sourceTableRow.getCtRow(), xwpfTable);
                try {
                    newRow = this.insertNewTableRow(sourceTableRow, i + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList<String> docVar = new ArrayList<String>();
                docVar.add(Optional.ofNullable(((Cost)((Object)this.costList.get(i))).getTitle()).orElse(""));
                docVar.add(((Cost)((Object)this.costList.get(i))).getType() != null ? ((Cost)((Object)this.costList.get(i))).getType().toString() : "");
                if (((Cost)((Object)this.costList.get(i))).getDescription() != null) {
                    docVar.add(((Cost)((Object)this.costList.get(i))).getDescription().length() < 255 ? ((Cost)((Object)this.costList.get(i))).getDescription() : "");
                } else {
                    docVar.add("");
                }
                docVar.add(Optional.ofNullable(((Cost)((Object)this.costList.get(i))).getCurrencyCode()).orElse("\u20ac"));
                if (((Cost)((Object)this.costList.get(i))).getValue() != null) {
                    docVar.add(NumberFormat.getNumberInstance(Locale.GERMAN).format(((Cost)((Object)this.costList.get(i))).getValue()));
                    totalCost = Float.valueOf(totalCost.floatValue() + ((Cost)((Object)this.costList.get(i))).getValue().floatValue());
                } else {
                    docVar.add("");
                }
                AbstractTemplateExportScienceEuropeComponents.insertTableCells(xwpfTable, newRow, docVar);
            }
            xwpfTable.removeRow(xwpfTable.getRows().size() - 2);
            xwpfTable.removeRow(1);
        } else {
            this.removeTable(xwpfDocument, xwpfTable);
        }
        Optional<Cost> costCurrencyTotal = this.costList.stream().filter(cost -> cost.getCurrencyCode() != null).findFirst();
        this.addReplacement(this.replacements, "[costcurrency]", costCurrencyTotal.isPresent() ? costCurrencyTotal.get().getCurrencyCode() : "");
        this.addReplacement(this.replacements, "[costtotal]", NumberFormat.getNumberInstance(Locale.GERMAN).format(totalCost));
    }
}

