/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.conversion;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.damap.base.conversion.AbstractTemplateExportFunctions;
import org.damap.base.conversion.LoadResourceService;
import org.damap.base.conversion.TemplateFileBrokerService;
import org.damap.base.domain.Contributor;
import org.damap.base.domain.Cost;
import org.damap.base.domain.Dataset;
import org.damap.base.domain.Dmp;
import org.damap.base.enums.EContributorRole;
import org.damap.base.r3data.RepositoriesService;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.mapper.ContributorDOMapper;
import org.damap.base.rest.projects.ProjectService;
import org.jboss.logging.Logger;

public abstract class AbstractTemplateExportSetup
extends AbstractTemplateExportFunctions {
    @Generated
    private static final Logger log = Logger.getLogger(AbstractTemplateExportSetup.class);
    @Inject
    RepositoriesService repositoriesService;
    @Inject
    ProjectService projectService;
    @Inject
    TemplateFileBrokerService templateFileBrokerService;
    @Inject
    LoadResourceService loadResourceService;
    protected Map<String, String> replacements = new HashMap<String, String>();
    protected Map<String, String> footerMap = new HashMap<String, String>();
    protected Dmp dmp = null;
    protected List<Dataset> datasets = null;
    protected List<Dataset> deletedDatasets = null;
    protected List<Cost> costList = null;
    protected Properties prop = null;
    protected List<XWPFParagraph> xwpfParagraphs = null;
    protected List<XWPFTable> xwpfTables = null;
    protected List<ContributorDO> projectCoordinators = new ArrayList<ContributorDO>();

    protected void exportSetup(long dmpId) {
        this.dmp = (Dmp)((Object)this.dmpRepo.findById(dmpId));
        this.datasets = this.dmp.getDatasetList();
        this.deletedDatasets = this.getDeletedDatasets(this.datasets);
        this.costList = this.dmp.getCosts();
        this.projectCoordinators = this.dmp.getContributorList().stream().filter(contributor -> contributor.getContributorRole() == EContributorRole.PROJECT_LEADER || contributor.getContributorRole() == EContributorRole.PROJECT_COORDINATOR || contributor.getContributorRole() == EContributorRole.PRINCIPAL_INVESTIGATOR).map(contributor -> ContributorDOMapper.mapEntityToDO(contributor, new ContributorDO())).toList();
        if (this.projectCoordinators.isEmpty()) {
            try {
                if (this.dmp.getProjectUniversityId() != null) {
                    ContributorDO projectLeader = this.projectService.getProjectLeader(this.dmp.getProjectUniversityId());
                    if (projectLeader.getRole() == null) {
                        projectLeader.setRole(EContributorRole.PROJECT_LEADER);
                    }
                    this.projectCoordinators = List.of(projectLeader);
                }
            }
            catch (Exception e) {
                log.error((Object)"Project API not functioning");
            }
        }
    }

    private List<Dataset> getDeletedDatasets(List<Dataset> datasets) {
        return datasets.stream().filter(Dataset::getDelete).toList();
    }

    protected List<Contributor> getContributorsByRole(List<Contributor> contributors, EContributorRole role) {
        return contributors.stream().filter(c -> c.getContributorRole() == role).toList();
    }

    protected String getContributorsText(List<Contributor> contributors) {
        if (contributors.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)", ", contributors.stream().map(c -> String.format("%s %s%s", c.getFirstName(), c.getLastName(), c.getMbox() == null ? "" : " (" + c.getMbox() + ")")).toList());
    }
}

