/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.conversion;

import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.damap.base.conversion.TemplateFileBrokerService;
import org.jboss.logging.Logger;

@ApplicationScoped
@DefaultBean
public class TemplateFileBrokerServiceImpl
implements TemplateFileBrokerService {
    @Generated
    private static final Logger log = Logger.getLogger(TemplateFileBrokerServiceImpl.class);

    @Override
    public Properties getScienceEuropeTemplateResource() {
        return this.loadResource("org/damap/base/template/scienceEuropeTemplate.resource");
    }

    @Override
    public InputStream loadScienceEuropeTemplate() {
        return this.loadTemplate("org/damap/base/template/scienceEuropeTemplate.docx");
    }

    @Override
    public Properties getFWFTemplateResource() {
        return this.loadResource("org/damap/base/template/FWFTemplate.resource");
    }

    @Override
    public InputStream loadFWFTemplate() {
        return this.loadTemplate("org/damap/base/template/FWFTemplate.docx");
    }

    @Override
    public InputStream loadHorizonEuropeTemplate() {
        return this.loadTemplate("org/damap/base/template/horizonEuropeTemplate.docx");
    }

    @Override
    public Properties getHorizonEuropeTemplateResource() {
        return this.loadResource("org/damap/base/template/horizonEuropeTemplate.resource");
    }

    public Properties loadResource(String resource) {
        Properties prop = new Properties();
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(resource);){
            prop.load(input);
        }
        catch (IOException ex) {
            log.error((Object)("could not load resource file: " + resource));
        }
        return prop;
    }

    public InputStream loadTemplate(String template) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream(template);
    }
}

