/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkus.hibernate.orm.panache.PanacheEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Version;
import lombok.Generated;
import org.damap.base.annotations.gdpr.Gdpr;
import org.damap.base.annotations.gdpr.GdprBase;
import org.damap.base.annotations.gdpr.GdprContext;
import org.damap.base.annotations.gdpr.GdprExtended;
import org.damap.base.annotations.gdpr.GdprKey;
import org.damap.base.domain.Dmp;
import org.damap.base.domain.Identifier;
import org.damap.base.enums.EContributorRole;
import org.hibernate.envers.Audited;

@Gdpr
@Entity
@Audited
public class Contributor
extends PanacheEntity {
    @Version
    private long version;
    @GdprContext(properties={"id", "project.title"})
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dmp_id", nullable=false, updatable=false)
    private Dmp dmp;
    @GdprBase
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="person_id")
    private Identifier personIdentifier;
    @GdprKey
    @Column(name="university_id")
    private String universityId;
    @GdprBase
    private String mbox;
    @GdprBase
    @Column(name="first_name")
    private String firstName;
    @GdprBase
    @Column(name="last_name")
    private String lastName;
    @GdprExtended
    private String affiliation;
    @GdprExtended
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="affiliation_id")
    private Identifier affiliationId;
    private Boolean contact;
    @GdprExtended
    @Enumerated(value=EnumType.STRING)
    @Column(name="contributor_role")
    private EContributorRole contributorRole;

    @Generated
    public Contributor() {
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public Dmp getDmp() {
        return this.dmp;
    }

    @Generated
    public Identifier getPersonIdentifier() {
        return this.personIdentifier;
    }

    @Generated
    public String getUniversityId() {
        return this.universityId;
    }

    @Generated
    public String getMbox() {
        return this.mbox;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getAffiliation() {
        return this.affiliation;
    }

    @Generated
    public Identifier getAffiliationId() {
        return this.affiliationId;
    }

    @Generated
    public Boolean getContact() {
        return this.contact;
    }

    @Generated
    public EContributorRole getContributorRole() {
        return this.contributorRole;
    }

    @JsonIgnore
    @Generated
    public void setDmp(Dmp dmp) {
        this.dmp = dmp;
    }

    @Generated
    public void setPersonIdentifier(Identifier personIdentifier) {
        this.personIdentifier = personIdentifier;
    }

    @Generated
    public void setUniversityId(String universityId) {
        this.universityId = universityId;
    }

    @Generated
    public void setMbox(String mbox) {
        this.mbox = mbox;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    @Generated
    public void setAffiliationId(Identifier affiliationId) {
        this.affiliationId = affiliationId;
    }

    @Generated
    public void setContact(Boolean contact) {
        this.contact = contact;
    }

    @Generated
    public void setContributorRole(EContributorRole contributorRole) {
        this.contributorRole = contributorRole;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contributor)) {
            return false;
        }
        Contributor other = (Contributor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Boolean this$contact = this.getContact();
        Boolean other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !((Object)this$contact).equals(other$contact)) {
            return false;
        }
        Identifier this$personIdentifier = this.getPersonIdentifier();
        Identifier other$personIdentifier = other.getPersonIdentifier();
        if (this$personIdentifier == null ? other$personIdentifier != null : !((Object)((Object)this$personIdentifier)).equals((Object)other$personIdentifier)) {
            return false;
        }
        String this$universityId = this.getUniversityId();
        String other$universityId = other.getUniversityId();
        if (this$universityId == null ? other$universityId != null : !this$universityId.equals(other$universityId)) {
            return false;
        }
        String this$mbox = this.getMbox();
        String other$mbox = other.getMbox();
        if (this$mbox == null ? other$mbox != null : !this$mbox.equals(other$mbox)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$affiliation = this.getAffiliation();
        String other$affiliation = other.getAffiliation();
        if (this$affiliation == null ? other$affiliation != null : !this$affiliation.equals(other$affiliation)) {
            return false;
        }
        Identifier this$affiliationId = this.getAffiliationId();
        Identifier other$affiliationId = other.getAffiliationId();
        if (this$affiliationId == null ? other$affiliationId != null : !((Object)((Object)this$affiliationId)).equals((Object)other$affiliationId)) {
            return false;
        }
        EContributorRole this$contributorRole = this.getContributorRole();
        EContributorRole other$contributorRole = other.getContributorRole();
        return !(this$contributorRole == null ? other$contributorRole != null : !((Object)((Object)this$contributorRole)).equals((Object)other$contributorRole));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Contributor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Boolean $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : ((Object)$contact).hashCode());
        Identifier $personIdentifier = this.getPersonIdentifier();
        result = result * 59 + ($personIdentifier == null ? 43 : ((Object)((Object)$personIdentifier)).hashCode());
        String $universityId = this.getUniversityId();
        result = result * 59 + ($universityId == null ? 43 : $universityId.hashCode());
        String $mbox = this.getMbox();
        result = result * 59 + ($mbox == null ? 43 : $mbox.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $affiliation = this.getAffiliation();
        result = result * 59 + ($affiliation == null ? 43 : $affiliation.hashCode());
        Identifier $affiliationId = this.getAffiliationId();
        result = result * 59 + ($affiliationId == null ? 43 : ((Object)((Object)$affiliationId)).hashCode());
        EContributorRole $contributorRole = this.getContributorRole();
        result = result * 59 + ($contributorRole == null ? 43 : ((Object)((Object)$contributorRole)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Contributor(version=" + this.getVersion() + ", personIdentifier=" + String.valueOf((Object)this.getPersonIdentifier()) + ", universityId=" + this.getUniversityId() + ", mbox=" + this.getMbox() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", affiliation=" + this.getAffiliation() + ", affiliationId=" + String.valueOf((Object)this.getAffiliationId()) + ", contact=" + this.getContact() + ", contributorRole=" + String.valueOf((Object)this.getContributorRole()) + ")";
    }
}

