/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.domain;

import io.quarkus.hibernate.orm.panache.PanacheEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Version;
import java.util.Date;
import lombok.Generated;
import org.damap.base.domain.Funding;
import org.hibernate.envers.Audited;

@Entity
@Audited
public class Project
extends PanacheEntity {
    @Version
    private long version;
    @Column(name="university_id")
    private String universityId;
    private String title;
    @Column(length=0x7FFFFFFF)
    private String description;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="funding_id")
    private Funding funding;
    @Column(name="project_start")
    private Date start;
    @Column(name="project_end")
    private Date end;
    @Column(name="acronym")
    private String acronym;

    public String getFundingGrantIdentifierIdentifier() {
        if (this.getFunding() == null || this.getFunding().getGrantIdentifier() == null || this.getFunding().getGrantIdentifier().getIdentifier() == null) {
            return null;
        }
        return this.getFunding().getGrantIdentifier().getIdentifier();
    }

    public String getFundingFunderIdentifierIdentifier() {
        if (this.getFunding() == null || this.getFunding().getFunderIdentifier() == null || this.getFunding().getFunderIdentifier().getIdentifier() == null) {
            return null;
        }
        return this.getFunding().getFunderIdentifier().getIdentifier();
    }

    @Generated
    public Project() {
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public String getUniversityId() {
        return this.universityId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Funding getFunding() {
        return this.funding;
    }

    @Generated
    public Date getStart() {
        return this.start;
    }

    @Generated
    public Date getEnd() {
        return this.end;
    }

    @Generated
    public String getAcronym() {
        return this.acronym;
    }

    @Generated
    public void setUniversityId(String universityId) {
        this.universityId = universityId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFunding(Funding funding) {
        this.funding = funding;
    }

    @Generated
    public void setStart(Date start) {
        this.start = start;
    }

    @Generated
    public void setEnd(Date end) {
        this.end = end;
    }

    @Generated
    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    @Generated
    public String toString() {
        return "Project(version=" + this.getVersion() + ", universityId=" + this.getUniversityId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", funding=" + String.valueOf((Object)this.getFunding()) + ", start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", acronym=" + this.getAcronym() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$universityId = this.getUniversityId();
        String other$universityId = other.getUniversityId();
        if (this$universityId == null ? other$universityId != null : !this$universityId.equals(other$universityId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Funding this$funding = this.getFunding();
        Funding other$funding = other.getFunding();
        if (this$funding == null ? other$funding != null : !((Object)((Object)this$funding)).equals((Object)other$funding)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Date this$end = this.getEnd();
        Date other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        String this$acronym = this.getAcronym();
        String other$acronym = other.getAcronym();
        return !(this$acronym == null ? other$acronym != null : !this$acronym.equals(other$acronym));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $universityId = this.getUniversityId();
        result = result * 59 + ($universityId == null ? 43 : $universityId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Funding $funding = this.getFunding();
        result = result * 59 + ($funding == null ? 43 : ((Object)((Object)$funding)).hashCode());
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Date $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        String $acronym = this.getAcronym();
        result = result * 59 + ($acronym == null ? 43 : $acronym.hashCode());
        return result;
    }
}

