/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.repo;

import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.panache.common.Parameters;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import org.damap.base.domain.InternalStorageTranslation;

@ApplicationScoped
public class InternalStorageTranslationRepo
implements PanacheRepository<InternalStorageTranslation> {
    public List<InternalStorageTranslation> getAllInternalStorageByLanguage(String languageCode) {
        return this.list("select storage from InternalStorageTranslation storage where storage.languageCode = :languageCode ", Parameters.with((String)"languageCode", (Object)languageCode));
    }

    public InternalStorageTranslation getInternalStorageById(Long storageId, String languageCode) {
        return (InternalStorageTranslation)((Object)this.find("select storage from InternalStorageTranslation storage where storage.internalStorageId.id = :storageId  and storage.languageCode = :languageCode ", Parameters.with((String)"storageId", (Object)storageId).and("languageCode", (Object)languageCode)).firstResult());
    }

    public List<InternalStorageTranslation> getAllInternalStorageTranslationsByStorageId(Long storageId) {
        return this.list("select storage from InternalStorageTranslation storage where storage.internalStorageId.id = :storageId ", Parameters.with((String)"storageId", (Object)storageId));
    }

    public boolean existsTranslationForStorageIdAndLanguageCode(Long storageId, String languageCode) {
        return this.count("internalStorageId.id = ?1 and languageCode = ?2", new Object[]{storageId, languageCode}) > 0L;
    }

    public boolean existsTranslationForStorageIdAndLanguageCodeExceptId(Long storageId, String languageCode, Long id) {
        return this.count("internalStorageId.id = ?1 and languageCode = ?2 and id != ?3", new Object[]{storageId, languageCode, id}) > 0L;
    }

    public void deleteAllTranslationsForInternalStorage(Long storageId) {
        this.delete("internalStorageId.id", new Object[]{storageId});
    }
}

