/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.access.domain.AccessDO;
import org.damap.base.rest.access.service.AccessService;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.validation.AccessValidator;
import org.jboss.logging.Logger;

@Path(value="/api/access")
@Authenticated
@Produces(value={"application/json"})
public class AccessResource {
    @Generated
    private static final Logger log = Logger.getLogger(AccessResource.class);
    @Inject
    AccessValidator accessValidator;
    @Inject
    AccessService accessService;

    @GET
    @Path(value="/dmps/{id}")
    public List<ContributorDO> getAccessForDmp(@PathParam(value="id") String id) {
        log.info((Object)("Return access list for dmp with id: " + id));
        long dmpId = Long.parseLong(id);
        if (!this.accessValidator.canViewAccess(dmpId)) {
            throw new ForbiddenException();
        }
        return this.accessService.getByDmpId(dmpId);
    }

    @POST
    @Consumes(value={"application/json"})
    public AccessDO create(@Valid AccessDO accessDO) {
        log.info((Object)"Create new access");
        if (accessDO.getUniversityId() == null) {
            throw new BadRequestException("University id is required");
        }
        if (!this.accessValidator.canCreateAccess(accessDO)) {
            throw new ForbiddenException();
        }
        return this.accessService.create(accessDO);
    }

    @DELETE
    @Path(value="/{id}")
    public void delete(@PathParam(value="id") String id) {
        log.info((Object)("Delete access with id: " + id));
        long accessId = Long.parseLong(id);
        if (!this.accessValidator.canDeleteAccess(accessId)) {
            throw new ForbiddenException();
        }
        this.accessService.delete(accessId);
    }
}

