/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import lombok.Generated;
import org.damap.base.rest.admin.domain.BannerDO;
import org.damap.base.rest.admin.service.AdminService;
import org.jboss.logging.Logger;

@Path(value="/api/admin")
@Produces(value={"application/json"})
@Authenticated
public class AdminResource {
    @Generated
    private static final Logger log = Logger.getLogger(AdminResource.class);
    @Inject
    AdminService adminService;

    @GET
    @Path(value="/banner")
    public BannerDO getAppBanner() {
        log.info((Object)"GET /admin/banner");
        return this.adminService.getAppBanner();
    }

    @POST
    @Path(value="/banner")
    @RolesAllowed(value={"Damap Admin"})
    public BannerDO createAppBanner(@Valid BannerDO bannerDO) {
        log.info((Object)"POST /admin/banner");
        log.info((Object)bannerDO);
        return this.adminService.createAppBanner(bannerDO);
    }

    @PUT
    @Path(value="/banner")
    @RolesAllowed(value={"Damap Admin"})
    public BannerDO updateAppBanner(@Valid BannerDO bannerDO) {
        log.info((Object)"PUT /admin/banner");
        log.info((Object)bannerDO);
        return this.adminService.updateAppBanner(bannerDO);
    }

    @DELETE
    @Path(value="/banner")
    @RolesAllowed(value={"Damap Admin"})
    public void deleteAppBanner() {
        log.info((Object)"DELETE /admin/banner");
        this.adminService.deleteAppBanner();
    }
}

