/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.damap.base.rest.base.ResultList;
import org.damap.base.rest.base.resource.ResourceCreate;
import org.damap.base.rest.base.resource.ResourceDelete;
import org.damap.base.rest.base.resource.ResourceRead;
import org.damap.base.rest.base.resource.ResourceSearch;
import org.damap.base.rest.base.resource.ResourceUpdate;
import org.damap.base.rest.storage.InternalStorageDO;
import org.damap.base.rest.storage.InternalStorageService;
import org.jboss.logging.Logger;

@Path(value="/api/storages")
@Authenticated
@Produces(value={"application/json"})
public class InternalStorageResource
implements ResourceRead<InternalStorageDO>,
ResourceCreate<InternalStorageDO, InternalStorageDO>,
ResourceUpdate<InternalStorageDO, InternalStorageDO>,
ResourceDelete,
ResourceSearch<InternalStorageDO> {
    @Generated
    private static final Logger log = Logger.getLogger(InternalStorageResource.class);
    @Inject
    InternalStorageService internalStorageService;

    @Override
    @POST
    @Path(value="")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"Damap Admin"})
    public InternalStorageDO create(@Valid InternalStorageDO data) {
        log.debug((Object)"Create internal storage option");
        log.debug((Object)data);
        try {
            return this.internalStorageService.create(data);
        }
        catch (ClientErrorException e) {
            throw new ClientErrorException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"message\":\"" + e.getMessage() + "\"}")).type("application/json").build());
        }
    }

    @Override
    @GET
    @Path(value="/{id}")
    public InternalStorageDO read(@PathParam(value="id") String id, @Context UriInfo uriInfo) {
        log.debug((Object)("Read internal storage option with id " + id));
        try {
            return this.internalStorageService.read(id, uriInfo.getQueryParameters());
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid internal storage ID: " + id));
            throw new ClientErrorException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"message\":\"Invalid internal storage ID: " + id + " - must be a number\"}")).type("application/json").build());
        }
    }

    @Override
    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"Damap Admin"})
    public InternalStorageDO update(@PathParam(value="id") String id, @Valid InternalStorageDO data) {
        log.debug((Object)("Update internal storage option with id " + id));
        log.debug((Object)data);
        return this.internalStorageService.update(id, data);
    }

    @Override
    @DELETE
    @RolesAllowed(value={"Damap Admin"})
    @Path(value="/{id}")
    public void delete(@PathParam(value="id") String id) {
        log.debug((Object)("Delete internal storage option with id " + id));
        this.internalStorageService.delete(id);
    }

    @Override
    @GET
    @Consumes(value={"application/json"})
    public ResultList<InternalStorageDO> search(@Context UriInfo uriInfo) {
        log.debug((Object)"Search internal storage options");
        return this.internalStorageService.search((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
    }
}

