/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.base.resource.ResourceCreate;
import org.damap.base.rest.base.resource.ResourceDelete;
import org.damap.base.rest.base.resource.ResourceRead;
import org.damap.base.rest.base.resource.ResourceUpdate;
import org.damap.base.rest.storage.InternalStorageTranslationDO;
import org.damap.base.rest.storage.InternalStorageTranslationService;
import org.jboss.logging.Logger;

@Path(value="/api/storages/{storageId}/translations")
@Authenticated
@Produces(value={"application/json"})
public class InternalStorageTranslationResource
implements ResourceRead<InternalStorageTranslationDO>,
ResourceCreate<InternalStorageTranslationDO, InternalStorageTranslationDO>,
ResourceUpdate<InternalStorageTranslationDO, InternalStorageTranslationDO>,
ResourceDelete {
    @Generated
    private static final Logger log = Logger.getLogger(InternalStorageTranslationResource.class);
    @Inject
    InternalStorageTranslationService internalStorageTranslationService;
    private static final String MESSAGE_START = "{\"message\":\"";

    @Override
    @RolesAllowed(value={"Damap Admin"})
    public InternalStorageTranslationDO create(@Valid InternalStorageTranslationDO data) {
        log.debug((Object)"Create internal storage translation");
        log.debug((Object)data);
        try {
            return this.internalStorageTranslationService.create(data);
        }
        catch (ClientErrorException e) {
            throw new ClientErrorException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(MESSAGE_START + e.getMessage() + "\"}")).type("application/json").build());
        }
    }

    @Override
    @RolesAllowed(value={"Damap Admin"})
    public void delete(String id) {
        log.info((Object)("Delete internal storage translation with id " + id));
        try {
            this.internalStorageTranslationService.delete(id);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (ClientErrorException e) {
            throw new ClientErrorException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(MESSAGE_START + e.getMessage() + "\"}")).type("application/json").build());
        }
    }

    @Override
    public InternalStorageTranslationDO read(String id, UriInfo uriInfo) {
        log.info((Object)("Read internal storage translation with id " + id));
        try {
            return this.internalStorageTranslationService.read(id, uriInfo.getQueryParameters());
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid internal storage translation ID: " + id));
            throw new ClientErrorException("Invalid internal storage translation ID: " + id + " - must be a number", Response.Status.BAD_REQUEST);
        }
    }

    @Override
    @RolesAllowed(value={"Damap Admin"})
    public InternalStorageTranslationDO update(String id, @Valid InternalStorageTranslationDO data) {
        log.info((Object)("Update internal storage translation with id " + id));
        log.info((Object)data);
        try {
            return this.internalStorageTranslationService.update(id, data);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (ClientErrorException e) {
            throw new ClientErrorException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(MESSAGE_START + e.getMessage() + "\"}")).type("application/json").build());
        }
    }

    @GET
    public List<InternalStorageTranslationDO> getAllByStorageId(@PathParam(value="storageId") String id) {
        log.info((Object)("getAll: " + id));
        return this.internalStorageTranslationService.getAllByStorageId(id);
    }
}

