/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.security.Authenticated;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import lombok.Generated;
import org.damap.base.rest.dmp.service.DmpService;
import org.damap.base.rest.madmp.dto.Dmp;
import org.damap.base.rest.madmp.service.MaDmpService;
import org.damap.base.security.SecurityService;
import org.damap.base.validation.AccessValidator;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/api/madmp")
@Authenticated
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class MaDmpResource {
    @Generated
    private static final Logger log = Logger.getLogger(MaDmpResource.class);
    @Inject
    SecurityService securityService;
    @Inject
    AccessValidator accessValidator;
    @Inject
    MaDmpService maDmpService;
    @Inject
    DmpService dmpService;
    @ConfigProperty(name="damap.auth.user")
    String authUser;

    @GET
    @Path(value="/{id}")
    public Dmp getById(@PathParam(value="id") long id) {
        log.info((Object)("Return maDMP for DMP with id: " + id));
        String personId = this.getPersonId();
        if (!this.accessValidator.canViewDmp(id, personId)) {
            throw new ForbiddenException("Not authorized to access dmp with id " + id);
        }
        return this.maDmpService.getById(id);
    }

    @GET
    @Path(value="/file/{id}")
    public Response getFileById(@PathParam(value="id") long id) {
        log.info((Object)("Return maDMP file for DMP with id: " + id));
        String personId = this.getPersonId();
        if (!this.accessValidator.canViewDmp(id, personId)) {
            throw new ForbiddenException("Not authorized to access dmp with id " + id);
        }
        String filename = this.dmpService.getDefaultFileName(id);
        Dmp maDMP = this.maDmpService.getById(id);
        String prettyMaDMP = maDMP.toString();
        ObjectMapper mapper = new ObjectMapper();
        try {
            prettyMaDMP = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)maDMP);
        }
        catch (JsonProcessingException e) {
            log.error((Object)("could not process maDMP with id: " + id + " into String"));
        }
        Response.ResponseBuilder response = Response.ok((Object)prettyMaDMP);
        response.header("Content-Disposition", (Object)("attachment; filename=" + filename + ".json")).header("Access-Control-Expose-Headers", (Object)"Content-Disposition");
        return response.build();
    }

    private String getPersonId() {
        if (this.securityService == null) {
            throw new AuthenticationFailedException("User ID is missing.");
        }
        return this.securityService.getUserId();
    }
}

