/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.dmp.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.damap.base.domain.Contributor;
import org.damap.base.domain.Cost;
import org.damap.base.domain.Dataset;
import org.damap.base.domain.Distribution;
import org.damap.base.domain.Dmp;
import org.damap.base.domain.ExternalStorage;
import org.damap.base.domain.Host;
import org.damap.base.domain.Project;
import org.damap.base.domain.Repository;
import org.damap.base.domain.Storage;
import org.damap.base.enums.EAgreement;
import org.damap.base.enums.EComplianceType;
import org.damap.base.enums.EDataQualityType;
import org.damap.base.enums.ESecurityMeasure;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.domain.CostDO;
import org.damap.base.rest.dmp.domain.DatasetDO;
import org.damap.base.rest.dmp.domain.DmpDO;
import org.damap.base.rest.dmp.domain.ExternalStorageDO;
import org.damap.base.rest.dmp.domain.HostDO;
import org.damap.base.rest.dmp.domain.ProjectDO;
import org.damap.base.rest.dmp.domain.RepositoryDO;
import org.damap.base.rest.dmp.domain.StorageDO;
import org.damap.base.rest.dmp.mapper.ContributorDOMapper;
import org.damap.base.rest.dmp.mapper.CostDOMapper;
import org.damap.base.rest.dmp.mapper.DatasetDOMapper;
import org.damap.base.rest.dmp.mapper.ExternalStorageDOMapper;
import org.damap.base.rest.dmp.mapper.HostDOMapper;
import org.damap.base.rest.dmp.mapper.MapperService;
import org.damap.base.rest.dmp.mapper.ProjectDOMapper;
import org.damap.base.rest.dmp.mapper.RepositoryDOMapper;
import org.damap.base.rest.dmp.mapper.StorageDOMapper;
import org.jboss.logging.Logger;

public final class DmpDOMapper {
    @Generated
    private static final Logger log = Logger.getLogger(DmpDOMapper.class);

    public static DmpDO mapEntityToDO(Dmp dmp, DmpDO dmpDO) {
        dmpDO.setId(dmp.id);
        dmpDO.setTitle(dmp.getTitle());
        dmpDO.setCreated(dmp.getCreated());
        dmpDO.setModified(dmp.getModified());
        dmpDO.setDescription(dmp.getDescription());
        if (dmp.getProject() != null) {
            ProjectDO projectDO = new ProjectDO();
            ProjectDOMapper.mapEntityToDO(dmp.getProject(), projectDO);
            dmpDO.setProject(projectDO);
        }
        dmpDO.setDataKind(dmp.getDataKind());
        dmpDO.setReusedDataKind(dmp.getReusedDataKind());
        dmpDO.setNoDataExplanation(dmp.getNoDataExplanation());
        dmpDO.setMetadata(dmp.getMetadata());
        dmpDO.setDataGeneration(dmp.getDataGeneration());
        dmpDO.setStructure(dmp.getStructure());
        dmpDO.setOtherDataQuality(dmp.getOtherDataQuality());
        dmpDO.setTargetAudience(dmp.getTargetAudience());
        dmpDO.setTools(dmp.getTools());
        dmpDO.setRestrictedDataAccess(dmp.getRestrictedDataAccess());
        dmpDO.setPersonalData(dmp.getPersonalData());
        dmpDO.setPersonalDataCris(dmp.getPersonalDataCris());
        dmpDO.setOtherPersonalDataCompliance(dmp.getOtherPersonalDataCompliance());
        dmpDO.setSensitiveData(dmp.getSensitiveData());
        dmpDO.setSensitiveDataCris(dmp.getSensitiveDataCris());
        dmpDO.setOtherDataSecurityMeasures(dmp.getOtherDataSecurityMeasures());
        dmpDO.setSensitiveDataAccess(dmp.getSensitiveDataAccess());
        dmpDO.setLegalRestrictions(dmp.getLegalRestrictions());
        dmpDO.setLegalRestrictionsCris(dmp.getLegalRestrictionsCris());
        dmpDO.setOtherLegalRestrictionsDocument(dmp.getOtherLegalRestrictionsDocument());
        dmpDO.setLegalRestrictionsComment(dmp.getLegalRestrictionsComment());
        dmpDO.setDataRightsAndAccessControl(dmp.getDataRightsAndAccessControl());
        dmpDO.setHumanParticipants(dmp.getHumanParticipants());
        dmpDO.setHumanParticipantsCris(dmp.getHumanParticipantsCris());
        dmpDO.setEthicalIssuesExist(dmp.getEthicalIssuesExist());
        dmpDO.setEthicalIssuesExistCris(dmp.getEthicalIssuesExistCris());
        dmpDO.setCommitteeReviewed(dmp.getCommitteeReviewed());
        dmpDO.setCommitteeReviewedCris(dmp.getCommitteeReviewedCris());
        dmpDO.setExternalStorageInfo(dmp.getExternalStorageInfo());
        dmpDO.setRestrictedAccessInfo(dmp.getRestrictedAccessInfo());
        dmpDO.setClosedAccessInfo(dmp.getClosedAccessInfo());
        dmpDO.setCostsExist(dmp.getCostsExist());
        dmpDO.setCostsExistCris(dmp.getCostsExistCris());
        dmpDO.setDocumentation(dmp.getDocumentation());
        dmpDO.setEthicalIssuesReport(dmp.getEthicalIssuesReport());
        ArrayList<ContributorDO> contributorDOList = new ArrayList<ContributorDO>();
        dmp.getContributorList().forEach(contributor -> {
            ContributorDO contributorDO = new ContributorDO();
            ContributorDOMapper.mapEntityToDO(contributor, contributorDO);
            contributorDOList.add(contributorDO);
        });
        dmpDO.setContributors(contributorDOList);
        ArrayList<EDataQualityType> dataQualityTypeDOList = new ArrayList<EDataQualityType>(dmp.getDataQuality());
        dmpDO.setDataQuality(dataQualityTypeDOList);
        ArrayList<EComplianceType> personalDataComplianceDOList = new ArrayList<EComplianceType>(dmp.getPersonalDataCompliance());
        dmpDO.setPersonalDataCompliance(personalDataComplianceDOList);
        ArrayList<ESecurityMeasure> sensitiveDataSecurityDOList = new ArrayList<ESecurityMeasure>(dmp.getSensitiveDataSecurity());
        dmpDO.setSensitiveDataSecurity(sensitiveDataSecurityDOList);
        ArrayList<EAgreement> legalRestrictionsDocumentsDOList = new ArrayList<EAgreement>(dmp.getLegalRestrictionsDocuments());
        dmpDO.setLegalRestrictionsDocuments(legalRestrictionsDocumentsDOList);
        ArrayList<DatasetDO> datasetDOList = new ArrayList<DatasetDO>();
        dmp.getDatasetList().forEach(dataset -> {
            DatasetDO datasetDO = new DatasetDO();
            DatasetDOMapper.mapEntityToDO(dataset, datasetDO);
            datasetDOList.add(datasetDO);
        });
        dmpDO.setDatasets(datasetDOList);
        ArrayList<RepositoryDO> repositoryDOList = new ArrayList<RepositoryDO>();
        ArrayList<StorageDO> storageDOList = new ArrayList<StorageDO>();
        ArrayList<ExternalStorageDO> externalStorageDOList = new ArrayList<ExternalStorageDO>();
        dmp.getHostList().forEach(host -> {
            HostDO hostDO = null;
            Class<?> hostClass = ((Object)host).getClass();
            if (Repository.class.isAssignableFrom(hostClass)) {
                hostDO = new RepositoryDO();
                HostDOMapper.mapEntityToDO(host, hostDO);
                RepositoryDOMapper.mapEntityToDO((Repository)((Object)host), (RepositoryDO)hostDO);
                repositoryDOList.add((RepositoryDO)hostDO);
            } else if (Storage.class.isAssignableFrom(hostClass)) {
                hostDO = new StorageDO();
                HostDOMapper.mapEntityToDO(host, hostDO);
                StorageDOMapper.mapEntityToDO((Storage)((Object)host), (StorageDO)hostDO);
                storageDOList.add((StorageDO)hostDO);
            } else if (ExternalStorage.class.isAssignableFrom(hostClass)) {
                hostDO = new ExternalStorageDO();
                HostDOMapper.mapEntityToDO(host, hostDO);
                ExternalStorageDOMapper.mapEntityToDO((ExternalStorage)((Object)host), (ExternalStorageDO)hostDO);
                externalStorageDOList.add((ExternalStorageDO)hostDO);
            } else {
                log.warn((Object)String.format("Could not infer host type from class %s", hostClass));
                return;
            }
            ArrayList<String> referenceHashList = new ArrayList<String>();
            host.getDistributionList().forEach(distribution -> referenceHashList.add(distribution.getDataset().getReferenceHash()));
            if (!referenceHashList.isEmpty()) {
                hostDO.setDatasets(referenceHashList);
            }
        });
        dmpDO.setRepositories(repositoryDOList);
        dmpDO.setStorage(storageDOList);
        dmpDO.setExternalStorage(externalStorageDOList);
        ArrayList<CostDO> costDOList = new ArrayList<CostDO>();
        dmp.getCosts().forEach(cost -> {
            CostDO costDO = new CostDO();
            CostDOMapper.mapEntityToDO(cost, costDO);
            costDOList.add(costDO);
        });
        dmpDO.setCosts(costDOList);
        return dmpDO;
    }

    public static Dmp mapDOtoEntity(DmpDO dmpDO, Dmp dmp, MapperService mapperService) {
        if (dmpDO.getId() != null) {
            dmp.id = dmpDO.getId();
        }
        dmp.setTitle(dmpDO.getTitle());
        dmp.setDescription(dmpDO.getDescription());
        if (dmpDO.getProject() != null) {
            Project project = new Project();
            if (dmp.getProject() != null) {
                project = dmp.getProject();
            }
            ProjectDOMapper.mapDOtoEntity(dmpDO.getProject(), project);
            dmp.setProject(project);
        } else {
            dmp.setProject(null);
        }
        dmp.setDataKind(dmpDO.getDataKind());
        dmp.setReusedDataKind(dmpDO.getReusedDataKind());
        dmp.setNoDataExplanation(dmpDO.getNoDataExplanation());
        dmp.setMetadata(dmpDO.getMetadata());
        dmp.setDataGeneration(dmpDO.getDataGeneration());
        dmp.setStructure(dmpDO.getStructure());
        dmp.setOtherDataQuality(dmpDO.getOtherDataQuality());
        dmp.setTargetAudience(dmpDO.getTargetAudience());
        dmp.setTools(dmpDO.getTools());
        dmp.setRestrictedDataAccess(dmpDO.getRestrictedDataAccess());
        dmp.setPersonalData(dmpDO.getPersonalData());
        dmp.setPersonalDataCris(dmpDO.getPersonalDataCris());
        dmp.setOtherPersonalDataCompliance(dmpDO.getOtherPersonalDataCompliance());
        dmp.setSensitiveData(dmpDO.getSensitiveData());
        dmp.setSensitiveDataCris(dmpDO.getSensitiveDataCris());
        dmp.setOtherDataSecurityMeasures(dmpDO.getOtherDataSecurityMeasures());
        dmp.setSensitiveDataAccess(dmpDO.getSensitiveDataAccess());
        dmp.setLegalRestrictions(dmpDO.getLegalRestrictions());
        dmp.setLegalRestrictionsCris(dmpDO.getLegalRestrictionsCris());
        dmp.setOtherLegalRestrictionsDocument(dmpDO.getOtherLegalRestrictionsDocument());
        dmp.setLegalRestrictionsComment(dmpDO.getLegalRestrictionsComment());
        dmp.setDataRightsAndAccessControl(dmpDO.getDataRightsAndAccessControl());
        dmp.setHumanParticipants(dmpDO.getHumanParticipants());
        dmp.setHumanParticipantsCris(dmpDO.getHumanParticipantsCris());
        dmp.setEthicalIssuesExist(dmpDO.getEthicalIssuesExist());
        dmp.setEthicalIssuesExistCris(dmpDO.getEthicalIssuesExistCris());
        dmp.setCommitteeReviewed(dmpDO.getCommitteeReviewed());
        dmp.setCommitteeReviewedCris(dmpDO.getCommitteeReviewedCris());
        dmp.setExternalStorageInfo(dmpDO.getExternalStorageInfo());
        dmp.setRestrictedAccessInfo(dmpDO.getRestrictedAccessInfo());
        dmp.setClosedAccessInfo(dmpDO.getClosedAccessInfo());
        dmp.setCostsExist(dmpDO.getCostsExist());
        dmp.setCostsExistCris(dmpDO.getCostsExistCris());
        dmp.setDocumentation(dmpDO.getDocumentation());
        dmp.setEthicalIssuesReport(dmpDO.getEthicalIssuesReport());
        List<Contributor> contributorList = dmp.getContributorList();
        ArrayList contributorListToRemove = new ArrayList();
        contributorList.forEach(contributor -> {
            Optional<ContributorDO> contributorDOOptional = dmpDO.getContributors().stream().filter(contributorDO -> contributorDO.getId() != null && contributorDO.getId().equals(contributor.id)).findFirst();
            if (contributorDOOptional.isEmpty()) {
                contributorListToRemove.add(contributor);
            }
        });
        contributorList.removeAll(contributorListToRemove);
        ArrayList<EDataQualityType> dataQualityTypeList = new ArrayList<EDataQualityType>();
        dmpDO.getDataQuality().forEach(option -> {
            if (option != null) {
                dataQualityTypeList.add((EDataQualityType)((Object)option));
            }
        });
        dmp.setDataQuality(dataQualityTypeList);
        ArrayList<EComplianceType> personalDataComplianceList = new ArrayList<EComplianceType>();
        dmpDO.getPersonalDataCompliance().forEach(option -> {
            if (option != null) {
                personalDataComplianceList.add((EComplianceType)((Object)option));
            }
        });
        dmp.setPersonalDataCompliance(personalDataComplianceList);
        ArrayList<ESecurityMeasure> sensitiveDataSecurityList = new ArrayList<ESecurityMeasure>();
        dmpDO.getSensitiveDataSecurity().forEach(option -> {
            if (option != null) {
                sensitiveDataSecurityList.add((ESecurityMeasure)((Object)option));
            }
        });
        dmp.setSensitiveDataSecurity(sensitiveDataSecurityList);
        ArrayList<EAgreement> legalRestrictionsDocumentsList = new ArrayList<EAgreement>();
        dmpDO.getLegalRestrictionsDocuments().forEach(option -> {
            if (option != null) {
                legalRestrictionsDocumentsList.add((EAgreement)((Object)option));
            }
        });
        dmp.setLegalRestrictionsDocuments(legalRestrictionsDocumentsList);
        dmpDO.getContributors().forEach(contributorDO -> {
            Optional<Contributor> contributorOptional = contributorList.stream().filter(contributor -> contributorDO.getId() != null && contributorDO.getId().equals(contributor.id)).findFirst();
            if (contributorOptional.isPresent()) {
                Contributor contributor2 = contributorOptional.get();
                ContributorDOMapper.mapDOtoEntity(contributorDO, contributor2);
            } else {
                Contributor contributor3 = new Contributor();
                ContributorDOMapper.mapDOtoEntity(contributorDO, contributor3);
                contributor3.setDmp(dmp);
                contributorList.add(contributor3);
            }
        });
        List<Dataset> datasetList = dmp.getDatasetList();
        ArrayList datasetListToRemove = new ArrayList();
        datasetList.forEach(dataset -> {
            Optional<DatasetDO> datasetDOOptional = dmpDO.getDatasets().stream().filter(datasetDO -> datasetDO.getId() != null && datasetDO.getId().equals(dataset.id)).findFirst();
            if (datasetDOOptional.isEmpty()) {
                datasetListToRemove.add(dataset);
            }
        });
        datasetList.removeAll(datasetListToRemove);
        dmpDO.getDatasets().forEach(datasetDO -> {
            Optional<Dataset> datasetOptional = datasetList.stream().filter(dataset -> datasetDO.getId() != null && datasetDO.getId().equals(dataset.id)).findFirst();
            if (datasetOptional.isPresent()) {
                Dataset dataset2 = datasetOptional.get();
                DatasetDOMapper.mapDOtoEntity(datasetDO, dataset2, mapperService);
            } else {
                Dataset dataset3 = new Dataset();
                DatasetDOMapper.mapDOtoEntity(datasetDO, dataset3, mapperService);
                dataset3.setDmp(dmp);
                datasetList.add(dataset3);
            }
        });
        for (Contributor con : contributorListToRemove) {
            datasetList.forEach(dataset -> {
                if (dataset.getDeletionPerson() != null && dataset.getDeletionPerson().id.equals(con.id)) {
                    dataset.setDeletionPerson(null);
                }
            });
        }
        List<Host> hostList = dmp.getHostList();
        ArrayList hostListToRemove = new ArrayList();
        hostList.forEach(host -> {
            boolean keep = false;
            if (Repository.class.isAssignableFrom(((Object)host).getClass())) {
                keep |= dmpDO.getRepositories().stream().anyMatch(hostDO -> hostDO.getId() != null && hostDO.getId().equals(host.id));
            }
            if (Storage.class.isAssignableFrom(((Object)host).getClass())) {
                keep |= dmpDO.getStorage().stream().anyMatch(hostDO -> hostDO.getId() != null && hostDO.getId().equals(host.id));
            }
            if (ExternalStorage.class.isAssignableFrom(((Object)host).getClass())) {
                keep |= dmpDO.getExternalStorage().stream().anyMatch(hostDO -> hostDO.getId() != null && hostDO.getId().equals(host.id));
            }
            if (!keep) {
                hostListToRemove.add(host);
            }
        });
        hostList.removeAll(hostListToRemove);
        dmpDO.getRepositories().forEach(hostDO -> {
            Repository host2;
            Optional<Host> hostOptional = hostList.stream().filter(host -> hostDO.getId() != null && hostDO.getId().equals(host.id)).findFirst();
            if (hostOptional.isPresent()) {
                host2 = (Repository)hostOptional.get();
                HostDOMapper.mapDOtoEntity(hostDO, host2);
                RepositoryDOMapper.mapDOtoEntity(hostDO, host2);
            } else {
                host2 = new Repository();
                HostDOMapper.mapDOtoEntity(hostDO, host2);
                RepositoryDOMapper.mapDOtoEntity(hostDO, host2);
                host2.setDmp(dmp);
                hostList.add(host2);
            }
            DmpDOMapper.determineDistributions(dmp, hostDO, host2);
        });
        dmpDO.getStorage().forEach(hostDO -> {
            Storage host2;
            Optional<Host> hostOptional = hostList.stream().filter(host -> hostDO.getId() != null && hostDO.getId().equals(host.id)).findFirst();
            if (hostOptional.isPresent()) {
                host2 = (Storage)hostOptional.get();
                HostDOMapper.mapDOtoEntity(hostDO, host2);
                StorageDOMapper.mapDOtoEntity(hostDO, host2, mapperService);
            } else {
                host2 = new Storage();
                HostDOMapper.mapDOtoEntity(hostDO, host2);
                StorageDOMapper.mapDOtoEntity(hostDO, host2, mapperService);
                host2.setDmp(dmp);
                hostList.add(host2);
            }
            DmpDOMapper.determineDistributions(dmp, hostDO, host2);
        });
        dmpDO.getExternalStorage().forEach(hostDO -> {
            ExternalStorage host2;
            Optional<Host> hostOptional = hostList.stream().filter(host -> hostDO.getId() != null && hostDO.getId().equals(host.id)).findFirst();
            if (hostOptional.isPresent()) {
                host2 = (ExternalStorage)hostOptional.get();
                HostDOMapper.mapDOtoEntity(hostDO, host2);
                ExternalStorageDOMapper.mapDOtoEntity(hostDO, host2);
            } else {
                host2 = new ExternalStorage();
                HostDOMapper.mapDOtoEntity(hostDO, host2);
                ExternalStorageDOMapper.mapDOtoEntity(hostDO, host2);
                host2.setDmp(dmp);
                hostList.add(host2);
            }
            DmpDOMapper.determineDistributions(dmp, hostDO, host2);
        });
        List<Cost> costList = dmp.getCosts();
        ArrayList costListToRemove = new ArrayList();
        costList.forEach(cost -> {
            Optional<CostDO> costDOOptional = dmpDO.getCosts().stream().filter(costDO -> costDO.getId() != null && costDO.getId().equals(cost.id)).findFirst();
            if (costDOOptional.isEmpty()) {
                costListToRemove.add(cost);
            }
        });
        costList.removeAll(costListToRemove);
        dmpDO.getCosts().forEach(costDO -> {
            Optional<Cost> costOptional = costList.stream().filter(cost -> costDO.getId() != null && costDO.getId().equals(cost.id)).findFirst();
            if (costOptional.isPresent()) {
                Cost cost2 = costOptional.get();
                CostDOMapper.mapDOtoEntity(costDO, cost2);
            } else {
                Cost cost3 = new Cost();
                CostDOMapper.mapDOtoEntity(costDO, cost3);
                cost3.setDmp(dmp);
                costList.add(cost3);
            }
        });
        return dmp;
    }

    private static void determineDistributions(Dmp dmp, HostDO hostDO, Host host) {
        List<Distribution> distributionList = host.getDistributionList();
        ArrayList distributionUpdatedList = new ArrayList();
        dmp.getDatasetList().forEach(dataset -> {
            if (hostDO.getDatasets().contains(dataset.getReferenceHash())) {
                Distribution distribution = new Distribution();
                distribution.setHost(host);
                distribution.setDataset((Dataset)((Object)dataset));
                Optional<Distribution> distributionOptional = distributionList.stream().filter(distribution1 -> Objects.equals(distribution1.getDataset().getId(), dataset.getId())).findFirst();
                if (distributionOptional.isEmpty()) {
                    distributionList.add(distribution);
                } else {
                    distribution = distributionOptional.get();
                }
                distributionUpdatedList.add(distribution);
            }
        });
        ArrayList distributionRemoveList = new ArrayList();
        distributionList.forEach(distribution -> {
            if (!distributionUpdatedList.contains(distribution)) {
                distributionRemoveList.add(distribution);
            }
        });
        distributionList.removeAll(distributionRemoveList);
    }

    @Generated
    private DmpDOMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

