/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.dmp.service;

import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.transaction.Transactional;
import jakarta.validation.Valid;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.damap.base.domain.Access;
import org.damap.base.domain.Contributor;
import org.damap.base.domain.Dmp;
import org.damap.base.domain.Identifier;
import org.damap.base.enums.EContributorRole;
import org.damap.base.enums.EFunctionRole;
import org.damap.base.enums.EIdentifierType;
import org.damap.base.repo.AccessRepo;
import org.damap.base.repo.DmpRepo;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.domain.DmpDO;
import org.damap.base.rest.dmp.domain.DmpListItemDO;
import org.damap.base.rest.dmp.domain.ProjectDO;
import org.damap.base.rest.dmp.mapper.ContributorDOMapper;
import org.damap.base.rest.dmp.mapper.DmpDOMapper;
import org.damap.base.rest.dmp.mapper.DmpListItemDOMapper;
import org.damap.base.rest.dmp.mapper.MapperService;
import org.damap.base.rest.dmp.mapper.ProjectSupplementDOMapper;
import org.damap.base.rest.dmp.service.DmpConsistencyUtility;
import org.damap.base.rest.persons.orcid.ORCIDPersonServiceImpl;
import org.damap.base.rest.projects.ProjectService;
import org.damap.base.rest.projects.ProjectSupplementDO;
import org.damap.base.rest.storage.InternalStorageService;
import org.damap.base.rest.version.VersionDO;
import org.damap.base.rest.version.VersionService;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DmpService {
    @Generated
    private static final Logger log = Logger.getLogger(DmpService.class);
    @Inject
    DmpRepo dmpRepo;
    @Inject
    AccessRepo accessRepo;
    @Inject
    ProjectService projectService;
    @Inject
    MapperService mapperService;
    @Inject
    VersionService versionService;
    @Inject
    ORCIDPersonServiceImpl orcidPersonService;
    @Inject
    InternalStorageService internalStorageService;

    public List<DmpListItemDO> getAll() {
        List<Dmp> dmpList = this.dmpRepo.getAll();
        ArrayList<DmpListItemDO> dmpListItemDOList = new ArrayList<DmpListItemDO>();
        dmpList.forEach(dmp -> dmpListItemDOList.add(DmpListItemDOMapper.mapEntityToDO(null, dmp, new DmpListItemDO(), this.versionService.getDmpVersions(dmp.id))));
        return dmpListItemDOList;
    }

    @Transactional
    public List<DmpListItemDO> getDmpListByPersonId(String personId) {
        List<Access> accessList = this.accessRepo.getAllDmpByUniversityId(personId);
        ArrayList<DmpListItemDO> dmpListItemDOS = new ArrayList<DmpListItemDO>();
        accessList.forEach(access -> dmpListItemDOS.add(DmpListItemDOMapper.mapEntityToDO(access, access.getDmp(), new DmpListItemDO(), this.versionService.getDmpVersions(access.getDmp().id))));
        dmpListItemDOS.sort(Comparator.comparing(DmpListItemDO::getId));
        return dmpListItemDOS;
    }

    @Transactional
    public DmpDO getDmpById(long dmpId) {
        return DmpDOMapper.mapEntityToDO((Dmp)((Object)this.dmpRepo.findById(dmpId)), new DmpDO());
    }

    @Transactional
    public List<DmpDO> getDmpDOListByPersonId(String personId) {
        List<Access> accessList = this.accessRepo.getAllDmpByUniversityId(personId);
        ArrayList<DmpDO> dmpDOS = new ArrayList<DmpDO>();
        accessList.forEach(access -> dmpDOS.add(DmpDOMapper.mapEntityToDO(access.getDmp(), new DmpDO())));
        return dmpDOS;
    }

    @Transactional
    public DmpDO create(@Valid DmpDO dmpDO, String editedBy) {
        log.info((Object)"Creating new DMP");
        DmpConsistencyUtility.enforceDmpConsistency(dmpDO);
        DmpConsistencyUtility.enforceActiveStorage(dmpDO, null, this.internalStorageService);
        Dmp dmp = DmpDOMapper.mapDOtoEntity(dmpDO, new Dmp(), this.mapperService);
        dmp.setCreated(new Date());
        this.fetchORCIDContributorInfo(dmp);
        this.updateDmpSupplementalInfo(dmp);
        this.updateProjectLead(dmp);
        dmp.persistAndFlush();
        this.createAccess(dmp, editedBy);
        return this.getDmpById(dmp.id);
    }

    @Transactional
    public DmpDO update(@Valid DmpDO dmpDO) {
        log.info((Object)("Updating DMP with id " + dmpDO.getId()));
        DmpConsistencyUtility.enforceDmpConsistency(dmpDO);
        Dmp dmp = (Dmp)((Object)this.dmpRepo.findById(dmpDO.getId()));
        DmpConsistencyUtility.enforceActiveStorage(dmpDO, dmp, this.internalStorageService);
        boolean projectSelectionChanged = this.projectSelectionChanged(dmp, dmpDO);
        DmpDOMapper.mapDOtoEntity(dmpDO, dmp, this.mapperService);
        dmp.setModified(new Date());
        this.fetchORCIDContributorInfo(dmp);
        if (projectSelectionChanged) {
            this.updateDmpSupplementalInfo(dmp);
            this.updateProjectLead(dmp);
        }
        dmp.persistAndFlush();
        return this.getDmpById(dmp.id);
    }

    @Transactional
    public void delete(long dmpId) {
        log.info((Object)("Deleting DMP with id " + dmpId));
        Dmp dmp = (Dmp)((Object)this.dmpRepo.findById(dmpId));
        this.removeAccess(dmp);
        this.removeVersions(dmp);
        this.dmpRepo.deleteById(dmpId);
    }

    public void createAccess(Dmp dmp, String editedById) {
        Access access = new Access();
        access.setUniversityId(editedById);
        access.setRole(EFunctionRole.OWNER);
        access.setDmp(dmp);
        access.setStart(new Date());
        access.persistAndFlush();
    }

    private void removeAccess(Dmp dmp) {
        List<Access> access = this.accessRepo.getAccessByDmp(dmp);
        access.forEach(PanacheEntityBase::delete);
    }

    private void removeVersions(Dmp dmp) {
        List<VersionDO> versionDOs = this.versionService.getDmpVersions(dmp.id);
        for (VersionDO versionDO : versionDOs) {
            this.versionService.delete(versionDO.getId());
        }
    }

    public String getDefaultFileName(long id) {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Object filename = "My Data Management Plan";
        Dmp dmp = (Dmp)((Object)this.dmpRepo.findById(id));
        if (dmp != null) {
            if (dmp.getProject() != null) {
                if (dmp.getProject().getUniversityId() != null && this.projectService.read(dmp.getProject().getUniversityId()) != null) {
                    filename = "DMP_" + ((ProjectDO)this.projectService.read(dmp.getProject().getUniversityId())).getAcronym() + "_" + formatter.format(date);
                } else if (dmp.getProject().getTitle() != null) {
                    filename = "DMP_" + dmp.getProject().getTitle() + "_" + formatter.format(date);
                }
            } else if (dmp.getTitle() != null) {
                filename = dmp.getTitle();
            }
        }
        filename = ((String)filename).replaceAll("[\"',\\s]+", "_");
        return filename;
    }

    public List<ProjectDO> checkExistingDmps(List<ProjectDO> projectDOList) {
        for (Dmp dmp : this.dmpRepo.getAll()) {
            for (ProjectDO projectDO : projectDOList) {
                if (dmp.getProject() == null || dmp.getProject().getUniversityId() == null || projectDO.getUniversityId() == null || !dmp.getProject().getUniversityId().equals(projectDO.getUniversityId())) continue;
                projectDO.setDmpExists(true);
            }
        }
        return projectDOList;
    }

    private void updateDmpSupplementalInfo(Dmp dmp) {
        if (dmp.getProject() != null) {
            ProjectSupplementDO projectSupplementDO = null;
            if (dmp.getProject().getUniversityId() != null) {
                projectSupplementDO = this.projectService.getProjectSupplement(dmp.getProject().getUniversityId());
            }
            if (projectSupplementDO == null) {
                projectSupplementDO = new ProjectSupplementDO();
            }
            ProjectSupplementDOMapper.mapDOtoEntity(projectSupplementDO, dmp);
        }
    }

    private void updateProjectLead(Dmp dmp) {
        if (dmp.getProject() == null || dmp.getProject().getUniversityId() == null) {
            return;
        }
        ContributorDO projectLeaderDO = this.projectService.getProjectLeader(dmp.getProject().getUniversityId());
        if (projectLeaderDO == null) {
            return;
        }
        List<Contributor> dmpContributors = dmp.getContributorList();
        Optional<Contributor> alreadyExistingContributorLeader = dmpContributors.stream().filter(c -> c.getUniversityId() != null && c.getUniversityId().equals(projectLeaderDO.getUniversityId())).findFirst();
        Contributor projectLeaderContributor = alreadyExistingContributorLeader.orElse(new Contributor());
        if (alreadyExistingContributorLeader.isEmpty()) {
            ContributorDOMapper.mapDOtoEntity(projectLeaderDO, projectLeaderContributor);
            projectLeaderContributor.setDmp(dmp);
            dmpContributors.add(projectLeaderContributor);
        }
        if (projectLeaderContributor.getContributorRole() == null) {
            projectLeaderContributor.setContributorRole(EContributorRole.PROJECT_LEADER);
        }
        if (dmpContributors.stream().noneMatch(c -> c.getContact())) {
            projectLeaderContributor.setContact(true);
        }
    }

    private void fetchORCIDContributorInfo(Dmp dmp) {
        dmp.getContributorList().forEach(contributor -> {
            if (contributor.id != null) {
                return;
            }
            Identifier identifier = contributor.getPersonIdentifier();
            if (identifier != null && identifier.getIdentifierType().equals((Object)EIdentifierType.ORCID)) {
                try {
                    ContributorDO contributorDO = (ContributorDO)this.orcidPersonService.read(identifier.getIdentifier());
                    if (contributor.getMbox() == null || contributor.getMbox().isEmpty()) {
                        contributor.setMbox(contributorDO.getMbox());
                    }
                    if (contributor.getAffiliation() == null || contributor.getAffiliation().isEmpty()) {
                        contributor.setAffiliation(contributorDO.getAffiliation());
                    }
                    if (contributor.getFirstName() == null || contributor.getFirstName().isEmpty()) {
                        contributor.setFirstName(contributorDO.getFirstName());
                    }
                    if (contributor.getLastName() == null || contributor.getLastName().isEmpty()) {
                        contributor.setLastName(contributorDO.getLastName());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)String.format("Could not fetch ORCID or map contributor info for identifier '%s'.%nDetail error message: %s", identifier.getIdentifier(), e));
                }
            }
        });
    }

    private boolean projectSelectionChanged(Dmp dmp, DmpDO dmpDO) {
        if (dmpDO.getProject() == null) {
            return false;
        }
        if (dmp.getProject() == null) {
            return true;
        }
        return !Objects.equals(dmp.getProject().id, dmpDO.getProject().getId()) || !Objects.equals(dmp.getProject().getUniversityId(), dmpDO.getProject().getUniversityId());
    }

    public DmpDO getDmpByIdAndRevision(long dmpId, long revision) {
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.dmpRepo.getEntityManager());
        Dmp dmpRevision = (Dmp)((Object)reader.find(Dmp.class, (Object)dmpId, (Number)revision));
        return DmpDOMapper.mapEntityToDO(dmpRevision, new DmpDO());
    }
}

