/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.document.service;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.damap.base.conversion.ExportTemplateBroker;
import org.damap.base.conversion.TemplateSelectorServiceImpl;
import org.damap.base.enums.ETemplateType;
import org.damap.base.rest.dmp.service.DmpService;
import org.damap.base.rest.document.dto.MultipartBodyDTO;
import org.damap.base.rest.document.service.GotenbergRestService;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DocumentService {
    @Generated
    private static final Logger log = Logger.getLogger(DocumentService.class);
    @Inject
    ExportTemplateBroker exportTemplateBroker;
    @Inject
    TemplateSelectorServiceImpl templateSelectorService;
    @Inject
    DmpService dmpService;
    @Inject
    @RestClient
    GotenbergRestService gotenbergRestService;

    public StreamingOutput getExportDocument(long dmpId, ETemplateType template, boolean download, String filetype) {
        XWPFDocument document;
        if (!filetype.equals("pdf") && !filetype.equals("docx")) {
            filetype = "docx";
        }
        XWPFDocument xWPFDocument = document = template != null ? this.exportTemplateBroker.exportTemplateByType(dmpId, template) : this.exportTemplateBroker.exportTemplate(dmpId);
        if (filetype.equals("pdf")) {
            return this.getPdfOf(document, dmpId);
        }
        if (filetype.equals("docx")) {
            return this.getWordDocumentOf(document);
        }
        throw new WebApplicationException("Invalid file type: " + filetype);
    }

    private StreamingOutput getPdfOf(XWPFDocument xwpfDocument, long dmpId) {
        byte[] pdfBytes;
        File tempFile;
        try {
            tempFile = File.createTempFile("dmp_" + dmpId + "_" + System.currentTimeMillis(), ".docx");
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                xwpfDocument.write((OutputStream)out);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error creating temporary file", (Throwable)e);
            throw new RuntimeException("Error creating temporary file");
        }
        try {
            MultipartBodyDTO multipartBodyDTO = new MultipartBodyDTO();
            multipartBodyDTO.file = tempFile;
            pdfBytes = this.gotenbergRestService.convertToPDF(multipartBodyDTO);
        }
        catch (Exception e) {
            log.error((Object)"Error converting document to PDF", (Throwable)e);
            throw new RuntimeException("Error converting document to PDF");
        }
        finally {
            if (tempFile.exists() && !tempFile.delete()) {
                log.warn((Object)("Failed to delete temporary file: " + tempFile.getAbsolutePath()));
            }
        }
        byte[] finalPdfBytes = pdfBytes;
        return output -> {
            output.write(finalPdfBytes);
            output.flush();
        };
    }

    private StreamingOutput getWordDocumentOf(XWPFDocument xwpfDocument) {
        return os -> {
            xwpfDocument.write(os);
            xwpfDocument.close();
        };
    }

    public ETemplateType getTemplateType(long dmpId) {
        return this.templateSelectorService.selectTemplate(this.dmpService.getDmpById(dmpId));
    }
}

