/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.gdpr.service;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.damap.base.annotations.gdpr.Gdpr;
import org.damap.base.repo.GdprRepo;
import org.damap.base.rest.gdpr.domain.GdprQuery;
import org.damap.base.rest.gdpr.domain.GdprResult;
import org.damap.base.rest.gdpr.domain.HqlQuery;
import org.damap.base.rest.gdpr.service.GdprQueryUtil;
import org.damap.base.rest.gdpr.service.HqlQueryUtil;
import org.hibernate.proxy.HibernateProxy;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@ApplicationScoped
public class GdprService {
    @Inject
    GdprRepo gdprRepo;
    private List<HqlQuery> baseQueries;
    private List<HqlQuery> extendedQueries;

    public GdprService() {
        this.init();
    }

    public List<GdprResult> getGdprBaseData(String universityId) {
        return this.gdprRepo.getGdprDataByUniversityId(this.baseQueries, universityId);
    }

    public List<GdprResult> getGdprExtendedData(String universityId) {
        return this.gdprRepo.getGdprDataByUniversityId(this.extendedQueries, universityId);
    }

    private void init() {
        String packageName = "org.damap.base.domain";
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set gdprClasses = reflections.getTypesAnnotatedWith(Gdpr.class);
        gdprClasses.removeIf(HibernateProxy.class::isAssignableFrom);
        this.baseQueries = new ArrayList<HqlQuery>();
        this.extendedQueries = new ArrayList<HqlQuery>();
        for (Class gdprClass : gdprClasses) {
            GdprQuery query = GdprQueryUtil.buildQueryObject(gdprClass);
            this.baseQueries.add(HqlQueryUtil.buildHqlQuery(query, false));
            this.extendedQueries.add(HqlQueryUtil.buildHqlQuery(query, true));
        }
    }
}

