/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.gdpr.service;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.gdpr.domain.GdprQuery;
import org.damap.base.rest.gdpr.domain.HqlQuery;

public final class HqlQueryUtil {
    public static HqlQuery buildHqlQuery(GdprQuery query, boolean extended) {
        HqlQuery hqlQuery = new HqlQuery();
        hqlQuery.setEntityName(query.getRoot().getSimpleName());
        String entityAlias = "e1";
        StringBuilder select = new StringBuilder();
        select.append(entityAlias).append(".").append(query.getKey()).append(" as userId");
        HqlQueryUtil.appendSelect(select, query.getContext(), entityAlias);
        StringBuilder contextJoin = new StringBuilder();
        for (int i = 0; i < query.getContextJoins().size(); ++i) {
            GdprQuery joinQ = query.getContextJoins().get(i);
            HqlQueryUtil.addContextJoin(entityAlias, select, contextJoin, joinQ, "c" + i, "", 0);
        }
        HqlQueryUtil.appendSelect(select, query.getBase(), entityAlias);
        StringBuilder baseJoin = new StringBuilder();
        for (int i = 0; i < query.getBaseJoins().size(); ++i) {
            GdprQuery joinQ = query.getBaseJoins().get(i);
            HqlQueryUtil.addJoin(entityAlias, select, baseJoin, joinQ, "j" + i);
        }
        StringBuilder extendedJoin = new StringBuilder();
        if (extended && !query.getExtended().isEmpty()) {
            HqlQueryUtil.appendSelect(select, query.getExtended(), entityAlias);
            for (int i = 0; i < query.getExtendedJoins().size(); ++i) {
                GdprQuery joinQ = query.getExtendedJoins().get(i);
                HqlQueryUtil.addJoin(entityAlias, select, extendedJoin, joinQ, "ej" + i);
            }
        }
        hqlQuery.setHql("SELECT new map(" + String.valueOf(select) + ") from " + query.getRoot().getSimpleName() + " " + entityAlias + String.valueOf(contextJoin) + String.valueOf(baseJoin) + String.valueOf(extendedJoin) + " where " + entityAlias + ".universityId = :id");
        return hqlQuery;
    }

    private static void addContextJoin(String entityAlias, StringBuilder select, StringBuilder join, GdprQuery joinQ, String joinAlias, String prefix, int i) {
        prefix = (String)prefix + joinQ.getFieldName() + "_";
        HqlQueryUtil.appendSelect(select, joinQ.getBase(), joinAlias, (String)prefix);
        join.append(" LEFT JOIN ").append(entityAlias).append(".").append(joinQ.getFieldName()).append(" ").append(joinAlias);
        if (joinQ.getContextJoins() != null) {
            for (int j = 0; j < joinQ.getContextJoins().size(); ++j) {
                GdprQuery joinQ2 = joinQ.getContextJoins().get(j);
                HqlQueryUtil.addContextJoin(joinAlias, select, join, joinQ2, joinAlias + j, (String)prefix, i++);
            }
        }
    }

    private static void addJoin(String entityAlias, StringBuilder select, StringBuilder join, GdprQuery joinQ, String joinAlias) {
        HqlQueryUtil.appendSelect(select, joinQ.getBase(), joinAlias, joinQ.getFieldName() + "_");
        join.append(" LEFT JOIN ").append(entityAlias).append(".").append(joinQ.getFieldName()).append(" ").append(joinAlias);
    }

    private static void appendSelect(StringBuilder select, List<String> properties, String alias) {
        HqlQueryUtil.appendSelect(select, properties, alias, "");
    }

    private static void appendSelect(StringBuilder select, List<String> properties, String alias, String prefix) {
        ArrayList<CallSite> columns = new ArrayList<CallSite>();
        for (String property : properties) {
            columns.add((CallSite)((Object)(alias + "." + property + " as " + prefix + property)));
        }
        if (!columns.isEmpty()) {
            select.append(", ").append(String.join((CharSequence)", ", columns));
        }
    }

    @Generated
    private HqlQueryUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

