/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.invenio_damap;

import io.quarkus.resteasy.reactive.server.EndpointDisabled;
import io.quarkus.security.ForbiddenException;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.AbstractMap;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.dmp.domain.DmpDO;
import org.damap.base.rest.invenio_damap.DMPPayload;
import org.damap.base.rest.invenio_damap.InvenioDAMAPService;
import org.damap.base.rest.madmp.dto.Dataset;
import org.damap.base.security.SecurityService;
import org.damap.base.validation.AccessValidator;
import org.jboss.logging.Logger;

@Path(value="/api/madmps")
@RequestScoped
@Produces(value={"application/json"})
@EndpointDisabled(name="invenio.disabled", stringValue="true")
public class InvenioDAMAPResource {
    @Generated
    private static final Logger log = Logger.getLogger(InvenioDAMAPResource.class);
    AccessValidator accessValidator;
    InvenioDAMAPService invenioDAMAPService;
    SecurityService securityService;

    @Inject
    public InvenioDAMAPResource(AccessValidator accessValidator, InvenioDAMAPService invenioDAMAPService, SecurityService securityService) {
        this.accessValidator = accessValidator;
        this.invenioDAMAPService = invenioDAMAPService;
        this.securityService = securityService;
    }

    @GET
    public List<DmpDO> getDmpListByPerson(@Context HttpHeaders headers) {
        AbstractMap.SimpleEntry<List<DmpDO>, String> result = this.invenioDAMAPService.resolveDmpsAndIds(this.securityService.checkIfUserIsAuthorized(headers));
        return result.getKey();
    }

    @POST
    @Consumes(value={"application/json"})
    public DmpDO addDataSetToDmp(@Context HttpHeaders headers, DMPPayload payload) {
        AbstractMap.SimpleEntry<List<DmpDO>, String> result = this.invenioDAMAPService.resolveDmpsAndIds(this.securityService.checkIfUserIsAuthorized(headers));
        long dmpId = payload.getDmpId();
        log.info((Object)("Add dataset to dmp with id: " + dmpId));
        Dataset dataset = payload.getDataset();
        if (result.getKey().stream().noneMatch(dmpDO -> dmpDO.getId().equals(dmpId))) {
            throw new NotFoundException("DMP with id " + dmpId + " could not be found.");
        }
        String personId = result.getValue();
        if (!this.accessValidator.canEditDmp(dmpId, personId)) {
            throw new ForbiddenException("Person " + personId + "Not authorized to access dmp with id " + dmpId);
        }
        return this.invenioDAMAPService.addDataSetToDMP(dmpId, dataset);
    }
}

