/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.invenio_damap;

import io.quarkus.security.UnauthorizedException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import jakarta.transaction.Transactional;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.List;
import org.damap.base.rest.dmp.domain.DatasetDO;
import org.damap.base.rest.dmp.domain.DmpDO;
import org.damap.base.rest.dmp.domain.IdentifierDO;
import org.damap.base.rest.dmp.service.DmpService;
import org.damap.base.rest.invenio_damap.InvenioDamapResourceMapper;
import org.damap.base.rest.madmp.dto.Dataset;
import org.damap.base.rest.madmp.dto.DatasetId;
import org.damap.base.rest.version.VersionDO;
import org.damap.base.rest.version.VersionService;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class InvenioDAMAPService {
    protected DmpService dmpService;
    protected VersionService versionService;

    @Inject
    InvenioDAMAPService(DmpService dmpService, VersionService versionService) {
        this.dmpService = dmpService;
        this.versionService = versionService;
    }

    public AbstractMap.SimpleEntry<List<DmpDO>, String> resolveDmpsAndIds(JsonWebToken jwt) {
        JsonObject invenioDamapClaim = (JsonObject)jwt.getClaim("invenio-damap");
        if (invenioDamapClaim == null) {
            throw new UnauthorizedException("Missing invenio-damap claim in jwt.");
        }
        JsonObject identifiers = invenioDamapClaim.getJsonObject("identifiers");
        if (identifiers == null || identifiers.isEmpty()) {
            throw new UnauthorizedException("No valid authentication schema was provided.");
        }
        List<DmpDO> personDmpList = null;
        String matchingIdentifier = null;
        for (String key : identifiers.keySet()) {
            String identifier = identifiers.getString(key);
            List<DmpDO> dmps = this.dmpService.getDmpDOListByPersonId(identifier);
            if (dmps.isEmpty()) continue;
            if (matchingIdentifier == null) {
                matchingIdentifier = identifier;
                personDmpList = dmps;
                continue;
            }
            throw new UnauthorizedException("Mismatch in resolved identities.");
        }
        if (matchingIdentifier == null) {
            throw new UnauthorizedException("Identities could not be resolved.");
        }
        return new AbstractMap.SimpleEntry<Object, Object>(personDmpList, matchingIdentifier);
    }

    @Transactional
    public DmpDO addDataSetToDMP(long dmpId, Dataset dataset) {
        DmpDO dmpDO = this.dmpService.getDmpById(dmpId);
        DatasetDO datasetDO = dmpDO.getDatasets().stream().filter(ds -> {
            IdentifierDO localIdentifier = ds.getDatasetId();
            DatasetId externalIdentifier = dataset.getDatasetId();
            if (localIdentifier == null || externalIdentifier == null) {
                return false;
            }
            return localIdentifier.getIdentifier() != null && externalIdentifier.getIdentifier() != null && localIdentifier.getType() != null && externalIdentifier.getType() != null && localIdentifier.getIdentifier().equals(externalIdentifier.getIdentifier()) && localIdentifier.getType().toString().equalsIgnoreCase(externalIdentifier.getType().name());
        }).findFirst().orElse(null);
        if (datasetDO == null) {
            datasetDO = new DatasetDO();
            dmpDO.getDatasets().add(datasetDO);
        }
        InvenioDamapResourceMapper.mapMaDMPDatasetToDatasetDO(dataset, datasetDO, dmpDO);
        dmpDO = this.dmpService.update(dmpDO);
        VersionDO version = new VersionDO();
        version.setDmpId(dmpId);
        version.setVersionName(MessageFormat.format("Added dataset `{0}` from remote datasource", dataset.getTitle()));
        version.setVersionDate(new Date());
        this.versionService.create(version);
        return dmpDO;
    }
}

