/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.madmp.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.damap.base.rest.madmp.dto.Host;
import org.damap.base.rest.madmp.dto.License;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"access_url", "available_until", "byte_size", "data_access", "description", "download_url", "format", "host", "license", "title"})
public class Distribution {
    @JsonProperty(value="access_url")
    @JsonPropertyDescription(value="A URL of the resource that gives access to a distribution of the dataset. e.g. landing page.")
    private String accessUrl;
    @JsonProperty(value="available_until")
    @JsonPropertyDescription(value="Indicates how long this distribution will be/ should be available. Encoded using the relevant ISO 8601 Date and Time compliant string.")
    private String availableUntil;
    @JsonProperty(value="byte_size")
    @JsonPropertyDescription(value="Size in bytes.")
    private Integer byteSize;
    @JsonProperty(value="data_access")
    @JsonPropertyDescription(value="Indicates access mode for data. Allowed values: open, shared, closed")
    private DataAccess dataAccess;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Description is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.")
    private String description;
    @JsonProperty(value="download_url")
    @JsonPropertyDescription(value="The URL of the downloadable file in a given format. E.g. CSV file or RDF file.")
    private URI downloadUrl;
    @JsonProperty(value="format")
    @JsonPropertyDescription(value="Format according to: https://www.iana.org/assignments/media-types/media-types.xhtml if appropriate, otherwise use the common name for this format.")
    private List<String> format = new ArrayList<String>();
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="To provide information on quality of service provided by infrastructure (e.g. repository) where data is stored.")
    private Host host;
    @JsonProperty(value="license")
    @JsonPropertyDescription(value="To list all licenses applied to a specific distribution of data.")
    private List<License> license = new ArrayList<License>();
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="Title is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.")
    private String title;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="access_url")
    public String getAccessUrl() {
        return this.accessUrl;
    }

    @JsonProperty(value="access_url")
    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }

    @JsonProperty(value="available_until")
    public String getAvailableUntil() {
        return this.availableUntil;
    }

    @JsonProperty(value="available_until")
    public void setAvailableUntil(String availableUntil) {
        this.availableUntil = availableUntil;
    }

    @JsonProperty(value="byte_size")
    public Integer getByteSize() {
        return this.byteSize;
    }

    @JsonProperty(value="byte_size")
    public void setByteSize(Integer byteSize) {
        this.byteSize = byteSize;
    }

    @JsonProperty(value="data_access")
    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    @JsonProperty(value="data_access")
    public void setDataAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="download_url")
    public URI getDownloadUrl() {
        return this.downloadUrl;
    }

    @JsonProperty(value="download_url")
    public void setDownloadUrl(URI downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @JsonProperty(value="format")
    public List<String> getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    public void setFormat(List<String> format) {
        this.format = format;
    }

    @JsonProperty(value="host")
    public Host getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(Host host) {
        this.host = host;
    }

    @JsonProperty(value="license")
    public List<License> getLicense() {
        return this.license;
    }

    @JsonProperty(value="license")
    public void setLicense(List<License> license) {
        this.license = license;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Distribution.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("accessUrl");
        sb.append('=');
        sb.append(this.accessUrl == null ? "<null>" : this.accessUrl);
        sb.append(',');
        sb.append("availableUntil");
        sb.append('=');
        sb.append(this.availableUntil == null ? "<null>" : this.availableUntil);
        sb.append(',');
        sb.append("byteSize");
        sb.append('=');
        sb.append(this.byteSize == null ? "<null>" : this.byteSize);
        sb.append(',');
        sb.append("dataAccess");
        sb.append('=');
        sb.append(this.dataAccess == null ? "<null>" : this.dataAccess);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("downloadUrl");
        sb.append('=');
        sb.append(this.downloadUrl == null ? "<null>" : this.downloadUrl);
        sb.append(',');
        sb.append("format");
        sb.append('=');
        sb.append(this.format == null ? "<null>" : this.format);
        sb.append(',');
        sb.append("host");
        sb.append('=');
        sb.append(this.host == null ? "<null>" : this.host);
        sb.append(',');
        sb.append("license");
        sb.append('=');
        sb.append(this.license == null ? "<null>" : this.license);
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(this.title == null ? "<null>" : this.title);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.availableUntil == null ? 0 : this.availableUntil.hashCode());
        result = result * 31 + (this.dataAccess == null ? 0 : this.dataAccess.hashCode());
        result = result * 31 + (this.license == null ? 0 : this.license.hashCode());
        result = result * 31 + (this.byteSize == null ? 0 : this.byteSize.hashCode());
        result = result * 31 + (this.accessUrl == null ? 0 : this.accessUrl.hashCode());
        result = result * 31 + (this.downloadUrl == null ? 0 : this.downloadUrl.hashCode());
        result = result * 31 + (this.format == null ? 0 : this.format.hashCode());
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Distribution)) {
            return false;
        }
        Distribution rhs = (Distribution)other;
        return (this.availableUntil == rhs.availableUntil || this.availableUntil != null && this.availableUntil.equals(rhs.availableUntil)) && (this.dataAccess == rhs.dataAccess || this.dataAccess != null && this.dataAccess.equals((Object)rhs.dataAccess)) && (this.license == rhs.license || this.license != null && this.license.equals(rhs.license)) && (this.byteSize == rhs.byteSize || this.byteSize != null && this.byteSize.equals(rhs.byteSize)) && (this.accessUrl == rhs.accessUrl || this.accessUrl != null && this.accessUrl.equals(rhs.accessUrl)) && (this.downloadUrl == rhs.downloadUrl || this.downloadUrl != null && this.downloadUrl.equals(rhs.downloadUrl)) && (this.format == rhs.format || this.format != null && this.format.equals(rhs.format)) && (this.host == rhs.host || this.host != null && this.host.equals(rhs.host)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.title == rhs.title || this.title != null && this.title.equals(rhs.title));
    }

    public static enum DataAccess {
        OPEN("open"),
        SHARED("shared"),
        CLOSED("closed");

        private final String value;
        private static final Map<String, DataAccess> CONSTANTS;

        private DataAccess(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataAccess fromValue(String value) {
            DataAccess constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DataAccess>();
            for (DataAccess c : DataAccess.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

