/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.madmp.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum PidSystem {
    ARK("ark"),
    ARXIV("arxiv"),
    BIBCODE("bibcode"),
    DOI("doi"),
    EAN_13("ean13"),
    EISSN("eissn"),
    HANDLE("handle"),
    IGSN("igsn"),
    ISBN("isbn"),
    ISSN("issn"),
    ISTC("istc"),
    LISSN("lissn"),
    LSID("lsid"),
    PMID("pmid"),
    PURL("purl"),
    UPC("upc"),
    URL("url"),
    URN("urn"),
    OTHER("other");

    private final String value;
    private static final Map<String, PidSystem> CONSTANTS;

    private PidSystem(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static PidSystem fromValue(String value) {
        PidSystem constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, PidSystem>();
        for (PidSystem c : PidSystem.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

