/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.madmp.mapper;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.damap.base.enums.EAgreement;
import org.damap.base.enums.EComplianceType;
import org.damap.base.enums.EDataAccessType;
import org.damap.base.enums.EDataType;
import org.damap.base.enums.ESecurityMeasure;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.domain.CostDO;
import org.damap.base.rest.dmp.domain.DatasetDO;
import org.damap.base.rest.dmp.domain.DmpDO;
import org.damap.base.rest.dmp.domain.ExternalStorageDO;
import org.damap.base.rest.dmp.domain.FundingDO;
import org.damap.base.rest.dmp.domain.IdentifierDO;
import org.damap.base.rest.dmp.domain.ProjectDO;
import org.damap.base.rest.dmp.domain.RepositoryDO;
import org.damap.base.rest.dmp.domain.StorageDO;
import org.damap.base.rest.dmp.domain.TechnicalResourceDO;
import org.damap.base.rest.dmp.mapper.MapperService;
import org.damap.base.rest.madmp.dto.Contact;
import org.damap.base.rest.madmp.dto.ContactId;
import org.damap.base.rest.madmp.dto.Contributor;
import org.damap.base.rest.madmp.dto.ContributorId;
import org.damap.base.rest.madmp.dto.Cost;
import org.damap.base.rest.madmp.dto.Dataset;
import org.damap.base.rest.madmp.dto.Distribution;
import org.damap.base.rest.madmp.dto.Dmp;
import org.damap.base.rest.madmp.dto.FunderId;
import org.damap.base.rest.madmp.dto.Funding;
import org.damap.base.rest.madmp.dto.GrantId;
import org.damap.base.rest.madmp.dto.Host;
import org.damap.base.rest.madmp.dto.License;
import org.damap.base.rest.madmp.dto.PidSystem;
import org.damap.base.rest.madmp.dto.Project;
import org.damap.base.rest.madmp.dto.SecurityAndPrivacy;
import org.damap.base.rest.madmp.dto.TechnicalResource;
import org.damap.base.rest.storage.InternalStorageDO;
import org.damap.base.rest.storage.InternalStorageTranslationDO;
import org.jboss.logging.Logger;
import org.re3data.schema._2_2.Certificates;
import org.re3data.schema._2_2.PidSystems;
import org.re3data.schema._2_2.Re3Data;
import org.re3data.schema._2_2.Yesno;

public final class MaDmpMapper {
    @Generated
    private static final Logger log = Logger.getLogger(MaDmpMapper.class);
    static final String DEFAULT_LANGUAGE_CODE = "eng";

    public static Dmp mapToMaDmp(DmpDO dmpDO, Dmp dmp, MapperService mapperService) {
        if (dmpDO.getContact() != null) {
            dmp.setContact(MaDmpMapper.mapToMaDmp(dmpDO.getContact(), new Contact()));
        }
        ArrayList<Contributor> contributorList = new ArrayList<Contributor>();
        dmpDO.getContributors().forEach(contributorDO -> contributorList.add(MaDmpMapper.mapToMaDmp(contributorDO, new Contributor())));
        dmp.setContributor(contributorList);
        ArrayList<Cost> costList = new ArrayList<Cost>();
        dmpDO.getCosts().forEach(costDO -> costList.add(MaDmpMapper.mapToMaDmp(costDO, new Cost())));
        dmp.setCost(costList);
        dmp.setCreated(dmpDO.getCreated());
        ArrayList<Dataset> datasetList = new ArrayList<Dataset>();
        dmpDO.getDatasets().forEach(datasetDO -> datasetList.add(MaDmpMapper.mapToMaDmp(dmpDO, datasetDO, new Dataset(), mapperService)));
        dmp.setDataset(datasetList);
        dmp.setDescription(dmpDO.getDescription());
        dmp.setDmpId(null);
        dmp.setEthicalIssuesDescription(null);
        dmp.setEthicalIssuesExist(MaDmpMapper.getEthicalIssuesExist(dmpDO));
        dmp.setEthicalIssuesReport(null);
        dmp.setLanguage(null);
        dmp.setModified(dmpDO.getModified());
        if (dmpDO.getProject() != null) {
            ArrayList<Project> projectList = new ArrayList<Project>();
            projectList.add(MaDmpMapper.mapToMaDmp(dmpDO.getProject(), new Project()));
            dmp.setProject(projectList);
        }
        dmp.setTitle(dmpDO.getTitle());
        return dmp;
    }

    public static Contact mapToMaDmp(ContributorDO contactDO, Contact contact) {
        if (contactDO.getPersonId() != null) {
            contact.setContactId(MaDmpMapper.mapToMaDmp(contactDO.getPersonId(), new ContactId()));
        }
        contact.setMbox(contactDO.getMbox());
        contact.setName(contactDO.getFirstName() + " " + contactDO.getLastName());
        return contact;
    }

    public static ContactId mapToMaDmp(IdentifierDO identifierDO, ContactId contactId) {
        contactId.setIdentifier(identifierDO.getIdentifier());
        switch (identifierDO.getType()) {
            case ORCID: {
                contactId.setType(ContactId.Type.ORCID);
                break;
            }
            case ISNI: {
                contactId.setType(ContactId.Type.ISNI);
                break;
            }
            case OPENID: {
                contactId.setType(ContactId.Type.OPENID);
                break;
            }
            default: {
                contactId.setType(ContactId.Type.OTHER);
            }
        }
        return contactId;
    }

    public static Contributor mapToMaDmp(ContributorDO contributorDO, Contributor contributor) {
        if (contributorDO.getPersonId() != null) {
            contributor.setContributorId(MaDmpMapper.mapToMaDmp(contributorDO.getPersonId(), new ContributorId()));
        }
        contributor.setMbox(contributorDO.getMbox());
        contributor.setName(contributorDO.getFirstName() + " " + contributorDO.getLastName());
        LinkedHashSet<String> role = new LinkedHashSet<String>();
        if (contributorDO.getRole() != null) {
            role.add(contributorDO.getRole().getRole());
        }
        contributor.setRole(role);
        return contributor;
    }

    public static ContributorId mapToMaDmp(IdentifierDO identifierDO, ContributorId contributorId) {
        contributorId.setIdentifier(identifierDO.getIdentifier());
        switch (identifierDO.getType()) {
            case ORCID: {
                contributorId.setType(ContributorId.Type.ORCID);
                break;
            }
            case ISNI: {
                contributorId.setType(ContributorId.Type.ISNI);
                break;
            }
            case OPENID: {
                contributorId.setType(ContributorId.Type.OPENID);
                break;
            }
            default: {
                contributorId.setType(ContributorId.Type.OTHER);
            }
        }
        return contributorId;
    }

    public static Cost mapToMaDmp(CostDO costDO, Cost cost) {
        if (costDO.getCurrencyCode() != null) {
            cost.setCurrencyCode(Cost.CurrencyCode.fromValue(costDO.getCurrencyCode()));
        }
        cost.setDescription(costDO.getDescription());
        cost.setTitle(costDO.getTitle());
        cost.setValue(cost.getValue());
        return cost;
    }

    public static Dataset mapToMaDmp(DmpDO dmpDO, DatasetDO datasetDO, Dataset dataset, MapperService mapperService) {
        dataset.setDataQualityAssurance(null);
        dataset.setDatasetId(null);
        dataset.setDescription(datasetDO.getDescription());
        ArrayList<Distribution> distributionList = new ArrayList<Distribution>();
        dmpDO.getRepositories().stream().filter(hostDO -> hostDO.getDatasets().contains(datasetDO.getReferenceHash())).forEach(repositoryDO -> {
            Distribution distribution = MaDmpMapper.mapToMaDmp(datasetDO, new Distribution());
            distributionList.add(MaDmpMapper.mapToMaDmpFromRepository(repositoryDO, distribution, mapperService));
        });
        dmpDO.getStorage().stream().filter(hostDO -> hostDO.getDatasets().contains(datasetDO.getReferenceHash())).forEach(storageDO -> {
            Distribution distribution = MaDmpMapper.mapToMaDmp(datasetDO, new Distribution());
            distributionList.add(MaDmpMapper.mapToMaDmpFromStorage(storageDO, distribution, mapperService));
        });
        dmpDO.getExternalStorage().stream().filter(hostDO -> hostDO.getDatasets().contains(datasetDO.getReferenceHash())).forEach(externalStorageDO -> {
            Distribution distribution = MaDmpMapper.mapToMaDmp(datasetDO, new Distribution());
            distributionList.add(MaDmpMapper.mapToMaDmpFromExternalStorage(externalStorageDO, distribution));
        });
        dataset.setDistribution(distributionList);
        dataset.setIssued(null);
        dataset.setKeyword(null);
        dataset.setLanguage(null);
        dataset.setMetadata(null);
        dataset.setPersonalData(MaDmpMapper.getPersonalData(datasetDO));
        dataset.setPreservationStatement(null);
        dataset.setSecurityAndPrivacy(MaDmpMapper.getSecurityAndPrivacyList(dmpDO, datasetDO));
        dataset.setSensitiveData(MaDmpMapper.getSensitiveData(datasetDO));
        dataset.setTechnicalResource(null);
        dataset.setTitle(datasetDO.getTitle());
        dataset.setType(MaDmpMapper.mapToMaDmpDatasetType(datasetDO.getType()));
        dataset.setTechnicalResource(MaDmpMapper.getTechnicalResource(datasetDO));
        return dataset;
    }

    private static List<TechnicalResource> getTechnicalResource(DatasetDO datasetDO) {
        ArrayList<TechnicalResource> technicalResources = new ArrayList<TechnicalResource>();
        for (TechnicalResourceDO technicalResourceDO : datasetDO.getTechnicalResources()) {
            TechnicalResource technicalResource = new TechnicalResource();
            technicalResource.setName(technicalResourceDO.getName());
            if (technicalResourceDO.getDescription() == null) {
                technicalResource.setDescription("");
            } else {
                technicalResource.setDescription(technicalResourceDO.getDescription());
            }
            technicalResources.add(technicalResource);
        }
        return technicalResources;
    }

    public static String mapToMaDmpDatasetType(List<EDataType> types) {
        if (types == null || types.isEmpty()) {
            return "";
        }
        return types.stream().map(EDataType::getValue).collect(Collectors.joining(", "));
    }

    public static Distribution mapToMaDmp(DatasetDO datasetDO, Distribution distribution) {
        if (datasetDO.getDateOfDeletion() != null) {
            distribution.setAvailableUntil(datasetDO.getDateOfDeletion().toString());
        }
        if (datasetDO.getSize() != null) {
            distribution.setByteSize(datasetDO.getSize().intValue());
        }
        if (datasetDO.getDataAccess() != null) {
            distribution.setDataAccess(MaDmpMapper.getDataAccess(datasetDO.getDataAccess()));
        }
        distribution.setDescription(datasetDO.getDescription());
        distribution.setDownloadUrl(null);
        if (datasetDO.getType() != null) {
            distribution.setFormat(MaDmpMapper.mapToMaDmpDatasetFormat(datasetDO.getType()));
        }
        if (datasetDO.getLicense() != null) {
            distribution.setLicense(List.of(MaDmpMapper.mapToMaDmp(datasetDO, new License())));
        }
        distribution.setTitle(datasetDO.getTitle());
        return distribution;
    }

    public static List<String> mapToMaDmpDatasetFormat(List<EDataType> types) {
        if (types == null || types.isEmpty()) {
            return new ArrayList<String>();
        }
        return types.stream().map(EDataType::getValue).collect(Collectors.toList());
    }

    public static Distribution mapToMaDmpFromRepository(RepositoryDO repositoryDO, Distribution distribution, MapperService mapperService) {
        Re3Data.Repository repository = mapperService.getRe3DataRepository(repositoryDO.getRepositoryId());
        distribution.setAccessUrl(repository.getRepositoryURL());
        distribution.setHost(MaDmpMapper.mapToMaDmpFromRepository(repository, new Host()));
        return distribution;
    }

    public static Distribution mapToMaDmpFromStorage(StorageDO storageDO, Distribution distribution, MapperService mapperService) {
        InternalStorageDO internalStorageDO = mapperService.getInternalStorageDOById(storageDO.getInternalStorageId(), DEFAULT_LANGUAGE_CODE);
        if (internalStorageDO != null) {
            distribution.setAccessUrl(internalStorageDO.getUrl());
            distribution.setHost(MaDmpMapper.mapToMaDmpFromInternalStorage(internalStorageDO, new Host()));
        }
        return distribution;
    }

    public static Distribution mapToMaDmpFromExternalStorage(ExternalStorageDO externalStorageDO, Distribution distribution) {
        distribution.setAccessUrl(externalStorageDO.getUrl());
        distribution.setHost(MaDmpMapper.mapToMaDmpFromExternalStorage(externalStorageDO, new Host()));
        return distribution;
    }

    public static Distribution.DataAccess getDataAccess(EDataAccessType eDataAccessType) {
        switch (eDataAccessType) {
            case CLOSED: {
                return Distribution.DataAccess.CLOSED;
            }
            case RESTRICTED: {
                return Distribution.DataAccess.SHARED;
            }
        }
        return Distribution.DataAccess.OPEN;
    }

    public static Host mapToMaDmpFromRepository(Re3Data.Repository repository, Host host) {
        host.setAvailability(null);
        host.setBackupFrequency(null);
        host.setBackupType(null);
        host.setCertifiedWith(MaDmpMapper.getCertifiedWith(repository.getCertificate()));
        if (repository.getDescription() != null) {
            host.setDescription(repository.getDescription().getValue());
        }
        host.setGeoLocation(null);
        ArrayList<PidSystem> pidSystemList = new ArrayList<PidSystem>();
        repository.getPidSystem().forEach(repoPidSystems -> pidSystemList.add(MaDmpMapper.getPidSystem(repoPidSystems)));
        host.setPidSystem(pidSystemList);
        repository.getType().stream().findFirst().ifPresent(repositoryTypes -> host.setStorageType(repositoryTypes.value()));
        host.setSupportVersioning(MaDmpMapper.getSupportVersioning(repository.getVersioning()));
        if (repository.getRepositoryName() != null) {
            host.setTitle(repository.getRepositoryName().getValue());
        }
        if (repository.getRepositoryURL() != null) {
            host.setUrl(URI.create(repository.getRepositoryURL()));
        }
        return host;
    }

    public static Host.CertifiedWith getCertifiedWith(List<Certificates> certificates) {
        for (Certificates certificate : certificates) {
            switch (certificate) {
                case DIN_31644: {
                    return Host.CertifiedWith.DIN_31644;
                }
                case DINI_CERTIFICATE: {
                    return Host.CertifiedWith.DINI_ZERTIFIKAT;
                }
                case DSA: {
                    return Host.CertifiedWith.DSA;
                }
                case ISO_16363: {
                    return Host.CertifiedWith.ISO_16363;
                }
                case ISO_16919: {
                    return Host.CertifiedWith.ISO_16919;
                }
                case TRAC: {
                    return Host.CertifiedWith.TRAC;
                }
                case WDS: {
                    return Host.CertifiedWith.WDS;
                }
            }
        }
        return null;
    }

    public static PidSystem getPidSystem(PidSystems pidSystems) {
        switch (pidSystems) {
            case ARK: {
                return PidSystem.ARK;
            }
            case DOI: {
                return PidSystem.DOI;
            }
            case HDL: {
                return PidSystem.HANDLE;
            }
            case PURL: {
                return PidSystem.PURL;
            }
            case URN: {
                return PidSystem.URN;
            }
            case OTHER: {
                return PidSystem.OTHER;
            }
        }
        return null;
    }

    public static Host.SupportVersioning getSupportVersioning(Yesno versioning) {
        if (versioning == Yesno.YES) {
            return Host.SupportVersioning.YES;
        }
        if (versioning == Yesno.NO) {
            return Host.SupportVersioning.NO;
        }
        return Host.SupportVersioning.UNKNOWN;
    }

    public static Host mapToMaDmpFromInternalStorage(InternalStorageDO internalStorageDO, Host host) {
        host.setAvailability(null);
        host.setBackupType(null);
        host.setCertifiedWith(null);
        host.setGeoLocation(null);
        host.setPidSystem(null);
        host.setStorageType(null);
        host.setSupportVersioning(null);
        List<InternalStorageTranslationDO> translations = internalStorageDO.getTranslations();
        InternalStorageTranslationDO internalStorageTranslationDO = null;
        if (!translations.isEmpty()) {
            internalStorageTranslationDO = translations.get(0);
        }
        for (InternalStorageTranslationDO translationDO : translations) {
            if (!translationDO.getLanguageCode().equals(DEFAULT_LANGUAGE_CODE)) continue;
            internalStorageTranslationDO = translationDO;
            break;
        }
        host.setTitle(internalStorageTranslationDO.getTitle());
        host.setDescription(internalStorageTranslationDO.getDescription());
        host.setBackupFrequency(internalStorageTranslationDO.getBackupFrequency());
        if (internalStorageDO.getUrl() != null) {
            host.setUrl(URI.create(internalStorageDO.getUrl()));
        }
        return host;
    }

    public static Host mapToMaDmpFromExternalStorage(ExternalStorageDO externalStorageDO, Host host) {
        host.setAvailability(null);
        host.setBackupFrequency(externalStorageDO.getBackupFrequency());
        host.setBackupType(null);
        host.setCertifiedWith(null);
        host.setDescription(null);
        host.setGeoLocation(null);
        host.setPidSystem(null);
        host.setStorageType(null);
        host.setSupportVersioning(null);
        host.setTitle(null);
        if (externalStorageDO.getUrl() != null) {
            host.setUrl(URI.create(externalStorageDO.getUrl()));
        }
        return host;
    }

    public static License mapToMaDmp(DatasetDO datasetDO, License license) {
        if (datasetDO.getLicense() != null) {
            license.setLicenseRef(URI.create(datasetDO.getLicense().getUrl()));
        }
        if (datasetDO.getStartDate() != null) {
            license.setStartDate(datasetDO.getStartDate().toString());
        }
        return license;
    }

    public static Dataset.PersonalData getPersonalData(DatasetDO datasetDO) {
        if (Boolean.TRUE.equals(datasetDO.getPersonalData())) {
            return Dataset.PersonalData.YES;
        }
        if (Boolean.FALSE.equals(datasetDO.getPersonalData())) {
            return Dataset.PersonalData.NO;
        }
        return Dataset.PersonalData.UNKNOWN;
    }

    public static List<SecurityAndPrivacy> getSecurityAndPrivacyList(DmpDO dmpDO, DatasetDO datasetDO) {
        ArrayList<SecurityAndPrivacy> securityAndPrivacyList = new ArrayList<SecurityAndPrivacy>();
        if (datasetDO.getSensitiveData() != null && datasetDO.getSensitiveData().booleanValue()) {
            dmpDO.getSensitiveDataSecurity().forEach(eSecurityMeasure -> securityAndPrivacyList.add(MaDmpMapper.mapToMaDmp(eSecurityMeasure, new SecurityAndPrivacy())));
        }
        if (datasetDO.getPersonalData() != null && datasetDO.getPersonalData().booleanValue()) {
            dmpDO.getPersonalDataCompliance().forEach(eComplianceType -> securityAndPrivacyList.add(MaDmpMapper.mapToMaDmp(eComplianceType, new SecurityAndPrivacy())));
        }
        if (datasetDO.getLegalRestrictions() != null && datasetDO.getLegalRestrictions().booleanValue()) {
            dmpDO.getLegalRestrictionsDocuments().forEach(eAgreement -> securityAndPrivacyList.add(MaDmpMapper.mapToMaDmp(eAgreement, new SecurityAndPrivacy())));
        }
        return securityAndPrivacyList;
    }

    public static SecurityAndPrivacy mapToMaDmp(ESecurityMeasure eSecurityMeasure, SecurityAndPrivacy securityAndPrivacy) {
        securityAndPrivacy.setDescription(eSecurityMeasure.getValue());
        securityAndPrivacy.setTitle(eSecurityMeasure.name());
        return securityAndPrivacy;
    }

    public static SecurityAndPrivacy mapToMaDmp(EComplianceType eComplianceType, SecurityAndPrivacy securityAndPrivacy) {
        securityAndPrivacy.setDescription(eComplianceType.getValue());
        securityAndPrivacy.setTitle(eComplianceType.name());
        return securityAndPrivacy;
    }

    public static SecurityAndPrivacy mapToMaDmp(EAgreement eAgreement, SecurityAndPrivacy securityAndPrivacy) {
        securityAndPrivacy.setDescription(eAgreement.getValue());
        securityAndPrivacy.setTitle(eAgreement.name());
        return securityAndPrivacy;
    }

    public static Dataset.SensitiveData getSensitiveData(DatasetDO datasetDO) {
        if (Boolean.TRUE.equals(datasetDO.getSensitiveData())) {
            return Dataset.SensitiveData.YES;
        }
        if (Boolean.FALSE.equals(datasetDO.getSensitiveData())) {
            return Dataset.SensitiveData.NO;
        }
        return Dataset.SensitiveData.UNKNOWN;
    }

    public static Dmp.EthicalIssuesExist getEthicalIssuesExist(DmpDO dmpDO) {
        if (Boolean.TRUE.equals(dmpDO.getEthicalIssuesExist()) || Boolean.TRUE.equals(dmpDO.getHumanParticipants())) {
            return Dmp.EthicalIssuesExist.YES;
        }
        if (Boolean.FALSE.equals(dmpDO.getEthicalIssuesExist()) || Boolean.FALSE.equals(dmpDO.getHumanParticipants())) {
            return Dmp.EthicalIssuesExist.NO;
        }
        return Dmp.EthicalIssuesExist.UNKNOWN;
    }

    public static Project mapToMaDmp(ProjectDO projectDO, Project project) {
        project.setDescription(projectDO.getDescription());
        if (projectDO.getEnd() != null) {
            project.setEnd(projectDO.getEnd().toString());
        }
        if (projectDO.getFunding() != null) {
            ArrayList<Funding> fundingList = new ArrayList<Funding>();
            fundingList.add(MaDmpMapper.mapToMaDmp(projectDO.getFunding(), new Funding()));
            project.setFunding(fundingList);
        }
        if (projectDO.getStart() != null) {
            project.setStart(projectDO.getStart().toString());
        }
        project.setTitle(projectDO.getTitle());
        return project;
    }

    public static Funding mapToMaDmp(FundingDO fundingDO, Funding funding) {
        if (fundingDO.getFunderId() != null) {
            funding.setFunderId(MaDmpMapper.mapToMaDmp(fundingDO.getFunderId(), new FunderId()));
        }
        switch (fundingDO.getFundingStatus()) {
            case PLANNED: {
                funding.setFundingStatus(Funding.FundingStatus.PLANNED);
                break;
            }
            case APPLIED: {
                funding.setFundingStatus(Funding.FundingStatus.APPLIED);
                break;
            }
            case GRANTED: {
                funding.setFundingStatus(Funding.FundingStatus.GRANTED);
                break;
            }
            case REJECTED: {
                funding.setFundingStatus(Funding.FundingStatus.REJECTED);
                break;
            }
            default: {
                funding.setFundingStatus(null);
            }
        }
        if (fundingDO.getGrantId() != null) {
            funding.setGrantId(MaDmpMapper.mapToMaDmp(fundingDO.getGrantId(), new GrantId()));
        }
        return funding;
    }

    public static FunderId mapToMaDmp(IdentifierDO identifierDO, FunderId funderId) {
        funderId.setIdentifier(identifierDO.getIdentifier());
        if (identifierDO.getType() != null) {
            switch (identifierDO.getType()) {
                case FUNDREF: {
                    funderId.setType(FunderId.Type.FUNDREF);
                    break;
                }
                case URL: {
                    funderId.setType(FunderId.Type.URL);
                    break;
                }
                default: {
                    funderId.setType(FunderId.Type.OTHER);
                }
            }
        }
        return funderId;
    }

    public static GrantId mapToMaDmp(IdentifierDO identifierDO, GrantId grantId) {
        grantId.setIdentifier(identifierDO.getIdentifier());
        if (identifierDO.getType() != null) {
            switch (identifierDO.getType()) {
                case URL: {
                    grantId.setType(GrantId.Type.URL);
                    break;
                }
                default: {
                    grantId.setType(GrantId.Type.OTHER);
                }
            }
        }
        return grantId;
    }

    @Generated
    private MaDmpMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

