/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.persons.orcid;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.damap.base.enums.EIdentifierType;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.domain.IdentifierDO;
import org.damap.base.rest.persons.orcid.models.ORCIDAffiliationSummary;
import org.damap.base.rest.persons.orcid.models.ORCIDExpandedSearchPerson;
import org.damap.base.rest.persons.orcid.models.ORCIDGroup;
import org.damap.base.rest.persons.orcid.models.ORCIDRecord;
import org.damap.base.rest.persons.orcid.models.base.ORCIDAffiliation;
import org.damap.base.rest.persons.orcid.models.base.ORCIDDate;
import org.damap.base.rest.persons.orcid.models.base.ORCIDEmail;

public final class ORCIDMapper {
    private static final Comparator<? super ORCIDAffiliation> sortByCurrentStartDate = (a, b) -> {
        ORCIDDate aEndDate = a.getEndDate();
        ORCIDDate bEndDate = b.getEndDate();
        if (aEndDate != null && bEndDate != null) {
            return aEndDate.getAsDate().compareTo(bEndDate.getAsDate());
        }
        if (aEndDate != null || bEndDate != null) {
            if (aEndDate == null) {
                return 1;
            }
            if (bEndDate == null) {
                return -1;
            }
        }
        ORCIDDate aStartDate = a.getStartDate();
        ORCIDDate bStartDate = b.getStartDate();
        if (aStartDate != null && bStartDate != null) {
            return aStartDate.getAsDate().compareTo(bStartDate.getAsDate());
        }
        if (aStartDate == null && bStartDate == null) {
            return 0;
        }
        if (aStartDate == null) {
            return 1;
        }
        if (bStartDate == null) {
            return -1;
        }
        return 0;
    };

    public static ContributorDO mapExpandedSearchPersonEntityToDO(ORCIDExpandedSearchPerson orcidPerson, ContributorDO contributorDO) {
        contributorDO.setId(null);
        contributorDO.setFirstName(orcidPerson.getGivenNames());
        contributorDO.setLastName(orcidPerson.getFamilyNames());
        String firstMail = orcidPerson.getEmails().isEmpty() ? null : orcidPerson.getEmails().get(0);
        contributorDO.setMbox(firstMail);
        String firstAffiliation = orcidPerson.getAffiliations().isEmpty() ? null : orcidPerson.getAffiliations().get(0);
        contributorDO.setAffiliation(firstAffiliation);
        IdentifierDO identifierContributorDO = new IdentifierDO();
        identifierContributorDO.setIdentifier(orcidPerson.getOrcidId());
        identifierContributorDO.setType(EIdentifierType.ORCID);
        contributorDO.setPersonId(identifierContributorDO);
        return contributorDO;
    }

    public static ContributorDO mapRecordEntityToPersonDO(ORCIDRecord orcidRecord, ContributorDO contributorDO) {
        contributorDO.setId(null);
        contributorDO.setFirstName(orcidRecord.getPerson().getName().getGivenNames().getValue());
        contributorDO.setLastName(orcidRecord.getPerson().getName().getFamilyName().getValue());
        List<ORCIDEmail> emails = orcidRecord.getPerson().getEmails().getEmail();
        if (!emails.isEmpty()) {
            Optional<ORCIDEmail> primaryMail = emails.stream().filter(ORCIDEmail::isPrimary).findFirst();
            String mail = primaryMail.isPresent() ? primaryMail.get().getEmail() : emails.get(0).getEmail();
            contributorDO.setMbox(mail);
        }
        ArrayList<? super ORCIDAffiliation> affiliations = new ArrayList<ORCIDAffiliation>();
        for (List list : List.of(orcidRecord.getActivitiesSummary().getEducations().getAffiliationGroup(), orcidRecord.getActivitiesSummary().getEmployments().getAffiliationGroup())) {
            for (ORCIDGroup group : list) {
                for (ORCIDAffiliationSummary summary : group.getSummaries()) {
                    affiliations.add(summary.getSummary());
                }
            }
        }
        if (!affiliations.isEmpty()) {
            affiliations.sort(sortByCurrentStartDate);
            contributorDO.setAffiliation(((ORCIDAffiliation)affiliations.get(affiliations.size() - 1)).getOrganization().getName());
        }
        IdentifierDO identifierContributorDO = new IdentifierDO();
        identifierContributorDO.setIdentifier(orcidRecord.getPerson().getName().getPath());
        identifierContributorDO.setType(EIdentifierType.ORCID);
        contributorDO.setPersonId(identifierContributorDO);
        return contributorDO;
    }

    @Generated
    private ORCIDMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

