/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.storage;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.damap.base.domain.InternalStorage;
import org.damap.base.domain.InternalStorageTranslation;
import org.damap.base.domain.Storage;
import org.damap.base.repo.InternalStorageRepo;
import org.damap.base.repo.InternalStorageTranslationRepo;
import org.damap.base.repo.StorageRepo;
import org.damap.base.rest.base.ResultList;
import org.damap.base.rest.base.Search;
import org.damap.base.rest.base.service.ServiceCreate;
import org.damap.base.rest.base.service.ServiceDelete;
import org.damap.base.rest.base.service.ServiceRead;
import org.damap.base.rest.base.service.ServiceSearch;
import org.damap.base.rest.base.service.ServiceUpdate;
import org.damap.base.rest.storage.InternalStorageDO;
import org.damap.base.rest.storage.InternalStorageDOMapper;
import org.damap.base.rest.storage.InternalStorageTranslationDO;
import org.damap.base.rest.storage.InternalStorageTranslationDOMapper;
import org.damap.base.rest.storage.InternalStorageTranslationValidator;
import org.damap.base.rest.storage.InternalStorageValidator;
import org.jboss.logging.Logger;

@ApplicationScoped
public class InternalStorageService
implements ServiceCreate<InternalStorageDO, InternalStorageDO>,
ServiceDelete,
ServiceRead<InternalStorageDO>,
ServiceSearch<InternalStorageDO>,
ServiceUpdate<InternalStorageDO, InternalStorageDO> {
    @Generated
    private static final Logger log = Logger.getLogger(InternalStorageService.class);
    @Inject
    InternalStorageTranslationRepo internalStorageTranslationRepo;
    @Inject
    InternalStorageRepo internalStorageRepo;
    @Inject
    StorageRepo storageRepo;

    @Override
    @Transactional
    public InternalStorageDO create(InternalStorageDO data) {
        InternalStorageValidator.validateForCreation(data);
        InternalStorage internalStorage = InternalStorageDOMapper.mapDOToEntity(data, new InternalStorage());
        internalStorage.persist();
        for (InternalStorageTranslationDO translationDO : data.getTranslations()) {
            translationDO.setStorageId(internalStorage.id);
            InternalStorageTranslationValidator.validateForCreation(translationDO, this.internalStorageRepo, this.internalStorageTranslationRepo);
            InternalStorageTranslation translation = InternalStorageTranslationDOMapper.mapDOToTranslationEntityForCreation(translationDO, internalStorage);
            translation.setInternalStorageId(internalStorage);
            translation.persist();
        }
        return (InternalStorageDO)this.read(String.valueOf(internalStorage.id));
    }

    @Override
    public InternalStorageDO read(String id, MultivaluedMap<String, String> queryParams) {
        InternalStorage internalStorage = (InternalStorage)((Object)this.internalStorageRepo.findByIdOptional(Long.parseLong(id)).orElseThrow(() -> new NotFoundException("No internal storage with ID " + id + " found")));
        List<InternalStorageTranslation> translations = this.internalStorageTranslationRepo.getAllInternalStorageTranslationsByStorageId(Long.parseLong(id));
        return InternalStorageDOMapper.mapEntityToDO(internalStorage, new InternalStorageDO(), translations);
    }

    @Override
    @Transactional
    public InternalStorageDO update(String id, InternalStorageDO data) {
        InternalStorageValidator.validateForUpdate(id, this.internalStorageRepo, data);
        InternalStorage internalStorage = (InternalStorage)((Object)this.internalStorageRepo.findById(Long.parseLong(id)));
        InternalStorageDOMapper.mapDOToEntity(data, internalStorage);
        internalStorage.persistAndFlush();
        return (InternalStorageDO)this.read(String.valueOf(internalStorage.id));
    }

    @Override
    @Transactional
    public void delete(String id) {
        InternalStorage internalStorage = (InternalStorage)((Object)this.internalStorageRepo.findByIdOptional(Long.parseLong(id)).orElseThrow(() -> new NotFoundException("No internal storage with ID " + id + " found")));
        List<Storage> storages = this.storageRepo.findByInternalStorageId(internalStorage);
        if (!storages.isEmpty()) {
            throw new ClientErrorException("Internal storage with ID " + id + " is still in use by " + storages.size() + " storages", Response.Status.CONFLICT);
        }
        this.internalStorageTranslationRepo.deleteAllTranslationsForInternalStorage(internalStorage.id);
        this.internalStorageRepo.delete((Object)internalStorage);
    }

    @Override
    public ResultList<InternalStorageDO> search(MultivaluedMap<String, String> queryParams) {
        queryParams = InternalStorageValidator.validateSearchParameters(queryParams);
        MultivaluedMap<String, Class> fields = this.getEntityFields();
        MultivaluedHashMap searchParams = new MultivaluedHashMap();
        for (Map.Entry entry : queryParams.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (!fields.containsKey((Object)key)) continue;
            searchParams.addAll((Object)key, values.stream().map(v -> this.convertValue((Class)fields.getFirst((Object)key), (String)v)).toList());
        }
        List internalStorageList = this.internalStorageRepo.searchByParameters((MultivaluedMap<String, Object>)searchParams);
        ArrayList<InternalStorageDO> internalStorageDOList = new ArrayList<InternalStorageDO>();
        for (InternalStorage internalStorage : internalStorageList) {
            List<InternalStorageTranslation> translations = this.internalStorageTranslationRepo.getAllInternalStorageTranslationsByStorageId(internalStorage.id);
            internalStorageDOList.add(InternalStorageDOMapper.mapEntityToDO(internalStorage, new InternalStorageDO(), translations));
        }
        Search search = Search.fromMap(queryParams);
        return ResultList.fromItemsAndSearch(internalStorageDOList, search);
    }

    @Override
    public MultivaluedMap<String, Class> getEntityFields() {
        MultivaluedHashMap fields = new MultivaluedHashMap();
        fields.add((Object)"id", Long.class);
        fields.add((Object)"version", Long.class);
        fields.add((Object)"url", String.class);
        fields.add((Object)"storageLocation", String.class);
        fields.add((Object)"backupLocation", String.class);
        fields.add((Object)"active", Boolean.class);
        return fields;
    }
}

