/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.storage;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import lombok.Generated;
import org.damap.base.domain.InternalStorage;
import org.damap.base.domain.InternalStorageTranslation;
import org.damap.base.domain.Storage;
import org.damap.base.repo.InternalStorageRepo;
import org.damap.base.repo.InternalStorageTranslationRepo;
import org.damap.base.repo.StorageRepo;
import org.damap.base.rest.base.ResultList;
import org.damap.base.rest.base.service.ServiceCreate;
import org.damap.base.rest.base.service.ServiceDelete;
import org.damap.base.rest.base.service.ServiceRead;
import org.damap.base.rest.base.service.ServiceSearch;
import org.damap.base.rest.base.service.ServiceUpdate;
import org.damap.base.rest.storage.InternalStorageTranslationDO;
import org.damap.base.rest.storage.InternalStorageTranslationDOMapper;
import org.damap.base.rest.storage.InternalStorageTranslationValidator;
import org.damap.base.rest.storage.InternalStorageValidator;
import org.jboss.logging.Logger;

@ApplicationScoped
public class InternalStorageTranslationService
implements ServiceCreate<InternalStorageTranslationDO, InternalStorageTranslationDO>,
ServiceDelete,
ServiceRead<InternalStorageTranslationDO>,
ServiceSearch<InternalStorageTranslationDO>,
ServiceUpdate<InternalStorageTranslationDO, InternalStorageTranslationDO> {
    @Generated
    private static final Logger log = Logger.getLogger(InternalStorageTranslationService.class);
    @Inject
    InternalStorageTranslationRepo internalStorageTranslationRepo;
    @Inject
    InternalStorageRepo internalStorageRepo;
    @Inject
    StorageRepo storageRepo;
    static final String DEFAULT_LANGUAGE_CODE = "eng";

    @Override
    @Transactional
    public InternalStorageTranslationDO create(InternalStorageTranslationDO data) throws ClientErrorException {
        InternalStorageTranslationValidator.validateForCreation(data, this.internalStorageRepo, this.internalStorageTranslationRepo);
        InternalStorage internalStorage = (InternalStorage)((Object)this.internalStorageRepo.findById(data.getStorageId()));
        InternalStorageTranslation internalStorageTranslation = InternalStorageTranslationDOMapper.mapDOToTranslationEntityForCreation(data, internalStorage);
        internalStorageTranslation.persistAndFlush();
        List<InternalStorageTranslation> translations = this.internalStorageTranslationRepo.getAllInternalStorageTranslationsByStorageId(internalStorageTranslation.getInternalStorageId().id);
        this.enforceHostTitleConsistencyWithTranslations(translations, internalStorageTranslation.getInternalStorageId());
        return this.getInternalStorageTranslationById(internalStorageTranslation.id);
    }

    @Override
    public InternalStorageTranslationDO read(String id, MultivaluedMap<String, String> queryParams) throws NumberFormatException {
        InternalStorageTranslation internalStorageTranslation = (InternalStorageTranslation)((Object)this.internalStorageTranslationRepo.findById(Long.parseLong(id)));
        if (internalStorageTranslation == null) {
            throw new NotFoundException("No internal storage translation found for id " + id);
        }
        return InternalStorageTranslationDOMapper.mapEntityToDO(internalStorageTranslation, new InternalStorageTranslationDO());
    }

    @Override
    public InternalStorageTranslationDO read(String id) {
        return this.read(id, (MultivaluedMap)null);
    }

    @Override
    @Transactional
    public InternalStorageTranslationDO update(String id, InternalStorageTranslationDO data) {
        InternalStorageTranslationValidator.validateForUpdate(id, data, this.internalStorageTranslationRepo, this.internalStorageRepo);
        InternalStorageTranslation internalStorageTranslation = (InternalStorageTranslation)((Object)this.internalStorageTranslationRepo.findById(Long.parseLong(id)));
        internalStorageTranslation = InternalStorageTranslationDOMapper.mapDOToEntity(data, internalStorageTranslation);
        internalStorageTranslation.persistAndFlush();
        List<InternalStorageTranslation> translations = this.internalStorageTranslationRepo.getAllInternalStorageTranslationsByStorageId(internalStorageTranslation.getInternalStorageId().id);
        this.enforceHostTitleConsistencyWithTranslations(translations, internalStorageTranslation.getInternalStorageId());
        return this.getInternalStorageTranslationById(internalStorageTranslation.id);
    }

    @Override
    @Transactional
    public void delete(String id) {
        InternalStorageTranslation internalStorageTranslation = (InternalStorageTranslation)((Object)this.internalStorageTranslationRepo.findById(Long.parseLong(id)));
        if (internalStorageTranslation == null) {
            throw new NotFoundException("No internal storage translation found for id " + id);
        }
        List<InternalStorageTranslation> translations = this.internalStorageTranslationRepo.getAllInternalStorageTranslationsByStorageId(internalStorageTranslation.getInternalStorageId().id);
        if (translations.size() == 1) {
            throw new ClientErrorException("Cannot delete the last translation for an internal storage", 400);
        }
        this.internalStorageTranslationRepo.delete((Object)internalStorageTranslation);
        translations.remove((Object)internalStorageTranslation);
        this.enforceHostTitleConsistencyWithTranslations(translations, internalStorageTranslation.getInternalStorageId());
    }

    @Override
    public ResultList<InternalStorageTranslationDO> search(MultivaluedMap<String, String> queryParams) {
        return null;
    }

    public List<InternalStorageTranslationDO> getAllByStorageId(String storageId) {
        if (!InternalStorageValidator.storageIdExists(Long.valueOf(storageId))) {
            throw new NotFoundException("No internal storage found for id " + storageId);
        }
        List<InternalStorageTranslation> translations = this.internalStorageTranslationRepo.getAllInternalStorageTranslationsByStorageId(Long.valueOf(storageId));
        return translations.stream().map(translation -> InternalStorageTranslationDOMapper.mapEntityToDO(translation, new InternalStorageTranslationDO())).toList();
    }

    @Transactional
    public InternalStorageTranslationDO getInternalStorageTranslationById(long internalStorageTranslationId) {
        return InternalStorageTranslationDOMapper.mapEntityToDO((InternalStorageTranslation)((Object)this.internalStorageTranslationRepo.findById(internalStorageTranslationId)), new InternalStorageTranslationDO());
    }

    private String getMainTitle(List<InternalStorageTranslation> translations) {
        for (InternalStorageTranslation translation : translations) {
            if (!translation.getLanguageCode().equals(DEFAULT_LANGUAGE_CODE)) continue;
            return translation.getTitle();
        }
        return translations.get(0).getTitle();
    }

    private void enforceHostTitleConsistencyWithTranslations(List<InternalStorageTranslation> translations, InternalStorage internalStorage) {
        List<Storage> storagesToUpdate = this.storageRepo.findByInternalStorageId(internalStorage);
        String newTitle = this.getMainTitle(translations);
        for (Storage storage : storagesToUpdate) {
            storage.setTitle(newTitle);
            storage.persist();
        }
        this.storageRepo.flush();
    }
}

