/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.storage;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import lombok.Generated;
import org.damap.base.domain.InternalStorage;
import org.damap.base.domain.InternalStorageTranslation;
import org.damap.base.repo.InternalStorageRepo;
import org.damap.base.repo.InternalStorageTranslationRepo;
import org.damap.base.rest.storage.InternalStorageTranslationDO;
import org.jboss.logging.Logger;

public final class InternalStorageTranslationValidator {
    @Generated
    private static final Logger log = Logger.getLogger(InternalStorageTranslationValidator.class);

    public static void validateForCreation(InternalStorageTranslationDO internalStorageTranslationDO, InternalStorageRepo internalStorageRepo, InternalStorageTranslationRepo internalStorageTranslationRepo) throws ClientErrorException {
        log.info((Object)"Validating internal storage translation for creation");
        if (internalStorageTranslationRepo.existsTranslationForStorageIdAndLanguageCode(internalStorageTranslationDO.getStorageId(), internalStorageTranslationDO.getLanguageCode())) {
            throw new ClientErrorException("Translation for language code " + internalStorageTranslationDO.getLanguageCode() + " already exists", Response.Status.BAD_REQUEST);
        }
        InternalStorageTranslationValidator.validationCommon(internalStorageTranslationDO, internalStorageRepo);
    }

    public static void validateForUpdate(String id, InternalStorageTranslationDO internalStorageTranslationDO, InternalStorageTranslationRepo internalStorageTranslationRepo, InternalStorageRepo internalStorageRepo) throws ClientErrorException {
        log.info((Object)"Validating internal storage translation for update");
        InternalStorageTranslation internalStorageTranslation = (InternalStorageTranslation)((Object)internalStorageTranslationRepo.findById(Long.parseLong(id)));
        if (internalStorageTranslation == null) {
            throw new NotFoundException("No internal storage translation with ID " + id + " found");
        }
        if (internalStorageTranslationRepo.existsTranslationForStorageIdAndLanguageCodeExceptId(internalStorageTranslationDO.getStorageId(), internalStorageTranslationDO.getLanguageCode(), Long.parseLong(id))) {
            throw new ClientErrorException("Translation for language code " + internalStorageTranslationDO.getLanguageCode() + " already exists", Response.Status.BAD_REQUEST);
        }
        InternalStorageTranslationValidator.validationCommon(internalStorageTranslationDO, internalStorageRepo);
    }

    public static void validationCommon(InternalStorageTranslationDO internalStorageTranslationDO, InternalStorageRepo internalStorageRepo) throws ClientErrorException {
        log.info((Object)"Validating common internal storage translation");
        InternalStorage internalStorage = (InternalStorage)((Object)internalStorageRepo.findById(internalStorageTranslationDO.getStorageId()));
        if (internalStorage == null) {
            throw new NotFoundException("No internal storage found for id " + internalStorageTranslationDO.getStorageId());
        }
        if (!internalStorageTranslationDO.getLanguageCode().equals("deu") && !internalStorageTranslationDO.getLanguageCode().equals("eng")) {
            throw new ClientErrorException("Language code must be 'deu' or 'eng'", Response.Status.BAD_REQUEST);
        }
    }

    @Generated
    private InternalStorageTranslationValidator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

