/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.version;

import jakarta.persistence.EntityManager;
import lombok.Generated;
import org.damap.base.domain.DamapRevisionEntity;
import org.damap.base.domain.Dmp;
import org.damap.base.domain.DmpVersion;
import org.damap.base.repo.DmpRepo;
import org.damap.base.rest.version.VersionDO;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;

public final class VersionDOMapper {
    public static VersionDO mapEntityToDO(DmpVersion version, VersionDO versionDO) {
        versionDO.setId(version.id);
        versionDO.setDmpId(version.getDmp().id);
        versionDO.setRevisionNumber(version.getRevisionEntity().getId());
        versionDO.setVersionName(version.getVersionName());
        versionDO.setVersionDate(version.getVersionDate());
        versionDO.setEditor(version.getRevisionEntity().getChangedBy());
        return versionDO;
    }

    public static DmpVersion mapDOtoEntity(VersionDO versionDO, DmpVersion version, DmpRepo dmpRepo) {
        if (versionDO.getId() != null) {
            version.id = versionDO.getId();
        }
        version.setDmp((Dmp)((Object)dmpRepo.findById(versionDO.getDmpId())));
        version.setVersionDate(versionDO.getVersionDate());
        version.setVersionName(versionDO.getVersionName());
        if (versionDO.getRevisionNumber() != null) {
            version.setRevisionEntity(VersionDOMapper.getRevisionByRevisionNumber(dmpRepo, versionDO.getRevisionNumber()));
        }
        return version;
    }

    private static DamapRevisionEntity getRevisionByRevisionNumber(DmpRepo dmpRepo, long revisionNumber) {
        AuditReader reader = AuditReaderFactory.get((EntityManager)dmpRepo.getEntityManager());
        return (DamapRevisionEntity)reader.findRevision(DamapRevisionEntity.class, (Number)revisionNumber);
    }

    @Generated
    private VersionDOMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

