
package org.damap.base.rest.madmp.dto;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;


/**
 * The Contributor Items Schema
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "contributor_id",
    "mbox",
    "name",
    "role"
})
@Generated("jsonschema2pojo")
public class Contributor {

    /**
     * The Contributor_id Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("contributor_id")
    private ContributorId contributorId;
    /**
     * The Contributor Mailbox Schema
     * <p>
     * Contributor Mail address
     * 
     */
    @JsonProperty("mbox")
    @JsonPropertyDescription("Contributor Mail address")
    private String mbox;
    /**
     * The Name Schema
     * <p>
     * Name of the contributor
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Name of the contributor")
    private String name;
    /**
     * The Role Schema
     * <p>
     * Type of contributor
     * (Required)
     * 
     */
    @JsonProperty("role")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @JsonPropertyDescription("Type of contributor")
    private Set<String> role = new LinkedHashSet<String>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The Contributor_id Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("contributor_id")
    public ContributorId getContributorId() {
        return contributorId;
    }

    /**
     * The Contributor_id Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("contributor_id")
    public void setContributorId(ContributorId contributorId) {
        this.contributorId = contributorId;
    }

    /**
     * The Contributor Mailbox Schema
     * <p>
     * Contributor Mail address
     * 
     */
    @JsonProperty("mbox")
    public String getMbox() {
        return mbox;
    }

    /**
     * The Contributor Mailbox Schema
     * <p>
     * Contributor Mail address
     * 
     */
    @JsonProperty("mbox")
    public void setMbox(String mbox) {
        this.mbox = mbox;
    }

    /**
     * The Name Schema
     * <p>
     * Name of the contributor
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * The Name Schema
     * <p>
     * Name of the contributor
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * The Role Schema
     * <p>
     * Type of contributor
     * (Required)
     * 
     */
    @JsonProperty("role")
    public Set<String> getRole() {
        return role;
    }

    /**
     * The Role Schema
     * <p>
     * Type of contributor
     * (Required)
     * 
     */
    @JsonProperty("role")
    public void setRole(Set<String> role) {
        this.role = role;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Contributor.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("contributorId");
        sb.append('=');
        sb.append(((this.contributorId == null)?"<null>":this.contributorId));
        sb.append(',');
        sb.append("mbox");
        sb.append('=');
        sb.append(((this.mbox == null)?"<null>":this.mbox));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("role");
        sb.append('=');
        sb.append(((this.role == null)?"<null>":this.role));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.role == null)? 0 :this.role.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.contributorId == null)? 0 :this.contributorId.hashCode()));
        result = ((result* 31)+((this.mbox == null)? 0 :this.mbox.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Contributor) == false) {
            return false;
        }
        Contributor rhs = ((Contributor) other);
        return ((((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.role == rhs.role)||((this.role!= null)&&this.role.equals(rhs.role))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.contributorId == rhs.contributorId)||((this.contributorId!= null)&&this.contributorId.equals(rhs.contributorId))))&&((this.mbox == rhs.mbox)||((this.mbox!= null)&&this.mbox.equals(rhs.mbox))));
    }

}
