/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.conversion;

import jakarta.enterprise.context.RequestScoped;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.damap.base.conversion.AbstractTemplateExportScienceEuropeComponents;
import org.damap.base.domain.Contributor;
import org.damap.base.domain.Dataset;
import org.damap.base.domain.Host;
import org.damap.base.domain.Repository;
import org.damap.base.enums.EContributorRole;
import org.jboss.logging.Logger;

@RequestScoped
public class ExportHorizonEuropeTemplate
extends AbstractTemplateExportScienceEuropeComponents {
    @Generated
    private static final Logger log = Logger.getLogger(ExportHorizonEuropeTemplate.class);

    public XWPFDocument exportTemplate(long dmpId) {
        log.info((Object)("Exporting Horzion Europe document for DMP with ID: " + dmpId));
        this.exportSetup(dmpId);
        String startChar = "[";
        String endChar = "]";
        this.prop = this.templateFileBrokerService.getHorizonEuropeTemplateResource();
        XWPFDocument document = null;
        try {
            document = this.loadTemplate(this.templateFileBrokerService.loadHorizonEuropeTemplate(), startChar, endChar);
        }
        catch (Exception e) {
            log.error((Object)"Template file not found!");
            return null;
        }
        this.xwpfParagraphs = document.getParagraphs();
        this.xwpfTables = document.getTables();
        this.loadHorizonEuropeContent();
        log.debug((Object)"Export steps: Replace in paragraph");
        ExportHorizonEuropeTemplate.replaceInParagraphs(this.xwpfParagraphs, this.replacements);
        log.debug((Object)"Export steps: Replace in table");
        this.tableContent(document, this.xwpfTables);
        log.debug((Object)"Export steps: Replace in footer");
        this.replaceTextInFooter(document, this.footerMap);
        return document;
    }

    public void loadHorizonEuropeContent() {
        super.loadScienceEuropeContent();
        this.workPackageLeadersInformation();
    }

    @Override
    public void datasetsInformation() {
        super.datasetsInformation();
        List<Contributor> dataManagers = this.getContributorsByRole(this.dmp.getContributorList(), EContributorRole.DATA_MANAGER);
        if (dataManagers.isEmpty()) {
            this.addReplacement(this.replacements, "[datamanager]", this.loadResourceService.loadVariableFromResource(this.prop, "datamanager.none"));
            this.addReplacement(this.replacements, "[datamanagerInfo]", this.loadResourceService.loadVariableFromResource(this.prop, "datamanagerInfo.singular"));
        } else {
            this.addReplacement(this.replacements, "[datamanager]", this.getContributorsText(dataManagers));
            if (dataManagers.size() > 1) {
                this.addReplacement(this.replacements, "[datamanagerInfo]", this.loadResourceService.loadVariableFromResource(this.prop, "datamanagerInfo.plural"));
            } else {
                this.addReplacement(this.replacements, "[datamanagerInfo]", this.loadResourceService.loadVariableFromResource(this.prop, "datamanagerInfo.singular"));
            }
        }
    }

    public void workPackageLeadersInformation() {
        List<Contributor> workPackageLeaders = this.getContributorsByRole(this.dmp.getContributorList(), EContributorRole.WORK_PACKAGE_LEADER);
        if (workPackageLeaders.isEmpty()) {
            this.addReplacement(this.replacements, "[workPackageLeaders]", this.loadResourceService.loadVariableFromResource(this.prop, "workPackageManger.none"));
        } else {
            this.addReplacement(this.replacements, "[workPackageLeaders]", this.getContributorsText(workPackageLeaders));
        }
    }

    @Override
    public void composeTableDatasetRepository(XWPFTable xwpfTable) {
        log.debug((Object)"Export steps: Dataset Repository Table");
        List<Dataset> newDatasets = this.getNewDatasets().stream().filter(dataset -> dataset.getDelete() == false).toList();
        if (!newDatasets.isEmpty()) {
            for (int i = 0; i < newDatasets.size(); ++i) {
                XWPFTableRow sourceTableRow = xwpfTable.getRow(2);
                XWPFTableRow newRow = new XWPFTableRow(sourceTableRow.getCtRow(), xwpfTable);
                try {
                    newRow = this.insertNewTableRow(sourceTableRow, i + 2);
                }
                catch (Exception e) {
                    log.error((Object)"Could not insert row into dataset table", (Throwable)e);
                    continue;
                }
                ArrayList<String> docVar = new ArrayList<String>();
                docVar.add((String)this.datasetTableIDs.get(newDatasets.get((int)i).id));
                List<Repository> repositories = newDatasets.get(i).getRepositories();
                if (!repositories.isEmpty()) {
                    List<String> repositoryTitles = repositories.stream().map(Host::getTitle).toList();
                    docVar.add(this.joinWithComma(repositoryTitles));
                } else {
                    docVar.add("");
                }
                if (newDatasets.get(i).getRetentionPeriod() != null) {
                    docVar.add(newDatasets.get(i).getRetentionPeriod() + " years");
                } else {
                    docVar.add("");
                }
                ExportHorizonEuropeTemplate.insertTableCells(xwpfTable, newRow, docVar);
            }
            xwpfTable.removeRow(xwpfTable.getRows().size() - 1);
        } else {
            ArrayList<String> emptyContent = new ArrayList<String>(List.of("", "", ""));
            ExportHorizonEuropeTemplate.insertTableCells(xwpfTable, (XWPFTableRow)xwpfTable.getRows().get(xwpfTable.getRows().size() - 1), emptyContent);
        }
        xwpfTable.removeRow(1);
        ExportHorizonEuropeTemplate.commitTableRows(xwpfTable);
    }
}

