/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.conversion;

import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.context.ApplicationScoped;
import lombok.Generated;
import org.damap.base.conversion.TemplateSelectorService;
import org.damap.base.enums.EFunderIds;
import org.damap.base.enums.EIdentifierType;
import org.damap.base.enums.ETemplateType;
import org.damap.base.rest.dmp.domain.DmpDO;
import org.damap.base.rest.dmp.domain.IdentifierDO;
import org.jboss.logging.Logger;

@ApplicationScoped
@DefaultBean
public class TemplateSelectorServiceImpl
implements TemplateSelectorService {
    @Generated
    private static final Logger log = Logger.getLogger(TemplateSelectorServiceImpl.class);

    @Override
    public ETemplateType selectTemplate(DmpDO dmpDO) {
        IdentifierDO funderIdentifier;
        if (dmpDO.getProject() != null && dmpDO.getProject().getFunding() != null && (funderIdentifier = dmpDO.getProject().getFunding().getFunderId()) != null && EIdentifierType.getFunderIdentifierTypeList().contains((Object)funderIdentifier.getType())) {
            if (this.isHorizonEuropeTemplate(funderIdentifier)) {
                return ETemplateType.HORIZON_EUROPE;
            }
            if (this.isFWFTemplate(funderIdentifier)) {
                return ETemplateType.FWF;
            }
        }
        return ETemplateType.SCIENCE_EUROPE;
    }

    @Override
    public boolean isHorizonEuropeTemplate(IdentifierDO identifierDO) {
        return EFunderIds.getEUFunderIds().contains(identifierDO.getIdentifier());
    }

    @Override
    public boolean isFWFTemplate(IdentifierDO identifierDO) {
        return EFunderIds.getFWFFunderIds().contains(identifierDO.getIdentifier());
    }
}

