/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.domain;

import io.quarkus.hibernate.orm.panache.PanacheEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.util.Date;
import lombok.Generated;
import org.damap.base.annotations.gdpr.Gdpr;
import org.damap.base.annotations.gdpr.GdprBase;
import org.damap.base.annotations.gdpr.GdprContext;
import org.damap.base.annotations.gdpr.GdprExtended;
import org.damap.base.annotations.gdpr.GdprKey;
import org.damap.base.domain.Dmp;
import org.damap.base.domain.Identifier;
import org.damap.base.enums.EFunctionRole;
import org.hibernate.envers.Audited;

@Gdpr
@Entity
@Audited
@Table(name="access_management")
public class Access
extends PanacheEntity {
    @Version
    private long version;
    @GdprContext(properties={"id", "project.title"})
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dmp_id", nullable=false, updatable=false)
    private Dmp dmp;
    @GdprKey
    @Column(name="university_id")
    private String universityId;
    @GdprBase
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="identifier_id", updatable=false)
    private Identifier personIdentifier;
    @GdprExtended
    @Enumerated(value=EnumType.STRING)
    private EFunctionRole role;
    @Column(name="start_date")
    private Date start;
    @Column(name="until_date")
    private Date until;

    @Generated
    public Access() {
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public Dmp getDmp() {
        return this.dmp;
    }

    @Generated
    public String getUniversityId() {
        return this.universityId;
    }

    @Generated
    public Identifier getPersonIdentifier() {
        return this.personIdentifier;
    }

    @Generated
    public EFunctionRole getRole() {
        return this.role;
    }

    @Generated
    public Date getStart() {
        return this.start;
    }

    @Generated
    public Date getUntil() {
        return this.until;
    }

    @Generated
    public void setDmp(Dmp dmp) {
        this.dmp = dmp;
    }

    @Generated
    public void setUniversityId(String universityId) {
        this.universityId = universityId;
    }

    @Generated
    public void setPersonIdentifier(Identifier personIdentifier) {
        this.personIdentifier = personIdentifier;
    }

    @Generated
    public void setRole(EFunctionRole role) {
        this.role = role;
    }

    @Generated
    public void setStart(Date start) {
        this.start = start;
    }

    @Generated
    public void setUntil(Date until) {
        this.until = until;
    }

    @Generated
    public String toString() {
        return "Access(version=" + this.getVersion() + ", dmp=" + String.valueOf((Object)this.getDmp()) + ", universityId=" + this.getUniversityId() + ", personIdentifier=" + String.valueOf((Object)this.getPersonIdentifier()) + ", role=" + String.valueOf((Object)this.getRole()) + ", start=" + String.valueOf(this.getStart()) + ", until=" + String.valueOf(this.getUntil()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Access)) {
            return false;
        }
        Access other = (Access)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Dmp this$dmp = this.getDmp();
        Dmp other$dmp = other.getDmp();
        if (this$dmp == null ? other$dmp != null : !((Object)((Object)this$dmp)).equals((Object)other$dmp)) {
            return false;
        }
        String this$universityId = this.getUniversityId();
        String other$universityId = other.getUniversityId();
        if (this$universityId == null ? other$universityId != null : !this$universityId.equals(other$universityId)) {
            return false;
        }
        Identifier this$personIdentifier = this.getPersonIdentifier();
        Identifier other$personIdentifier = other.getPersonIdentifier();
        if (this$personIdentifier == null ? other$personIdentifier != null : !((Object)((Object)this$personIdentifier)).equals((Object)other$personIdentifier)) {
            return false;
        }
        EFunctionRole this$role = this.getRole();
        EFunctionRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Date this$until = this.getUntil();
        Date other$until = other.getUntil();
        return !(this$until == null ? other$until != null : !((Object)this$until).equals(other$until));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Access;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Dmp $dmp = this.getDmp();
        result = result * 59 + ($dmp == null ? 43 : ((Object)((Object)$dmp)).hashCode());
        String $universityId = this.getUniversityId();
        result = result * 59 + ($universityId == null ? 43 : $universityId.hashCode());
        Identifier $personIdentifier = this.getPersonIdentifier();
        result = result * 59 + ($personIdentifier == null ? 43 : ((Object)((Object)$personIdentifier)).hashCode());
        EFunctionRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Date $until = this.getUntil();
        result = result * 59 + ($until == null ? 43 : ((Object)$until).hashCode());
        return result;
    }
}

