/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.domain;

import io.quarkus.hibernate.orm.panache.PanacheEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.damap.base.domain.Contributor;
import org.damap.base.domain.Cost;
import org.damap.base.domain.Dataset;
import org.damap.base.domain.Host;
import org.damap.base.domain.Project;
import org.damap.base.enums.EAgreement;
import org.damap.base.enums.EComplianceType;
import org.damap.base.enums.EDataKind;
import org.damap.base.enums.EDataQualityType;
import org.damap.base.enums.ESecurityMeasure;
import org.hibernate.envers.Audited;

@Entity
@Audited
@Table
public class Dmp
extends PanacheEntity {
    @Version
    private long version;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modified;
    private String title;
    @Column(length=0x7FFFFFFF)
    private String description;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="project_id")
    private Project project;
    @Enumerated(value=EnumType.STRING)
    @Column(name="data_kind")
    private EDataKind dataKind;
    @Enumerated(value=EnumType.STRING)
    @Column(name="reused_data_kind")
    private EDataKind reusedDataKind;
    @Column(name="no_data_explanation")
    private String noDataExplanation;
    private String metadata;
    @Column(name="data_generation")
    private String dataGeneration;
    private String structure;
    @ElementCollection(targetClass=EDataQualityType.class, fetch=FetchType.LAZY)
    @CollectionTable(name="data_quality")
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    private List<EDataQualityType> dataQuality;
    @Column(name="other_data_quality")
    private String otherDataQuality;
    @Column(name="target_audience")
    private String targetAudience;
    private String tools;
    @Column(name="restricted_data_access")
    private String restrictedDataAccess;
    @Column(name="personal_data")
    private Boolean personalData;
    @Column(name="personal_data_cris")
    private Boolean personalDataCris;
    @ElementCollection(targetClass=EComplianceType.class, fetch=FetchType.LAZY)
    @CollectionTable(name="personal_data_compliance")
    @Column(name="compliance_type")
    @Enumerated(value=EnumType.STRING)
    private List<EComplianceType> personalDataCompliance;
    @Column(name="other_personal_data_compliance")
    private String otherPersonalDataCompliance;
    @Column(name="sensitive_data")
    private Boolean sensitiveData;
    @Column(name="sensitive_data_cris")
    private Boolean sensitiveDataCris;
    @ElementCollection(targetClass=ESecurityMeasure.class, fetch=FetchType.LAZY)
    @CollectionTable(name="sensitive_data_security")
    @Column(name="security_measure")
    @Enumerated(value=EnumType.STRING)
    private List<ESecurityMeasure> sensitiveDataSecurity;
    @Column(name="other_data_sec_measures")
    private String otherDataSecurityMeasures;
    @Column(name="sensitive_data_access")
    private String sensitiveDataAccess;
    @Column(name="legal_restrictions")
    private Boolean legalRestrictions;
    @Column(name="legal_restrictions_cris")
    private Boolean legalRestrictionsCris;
    @ElementCollection(targetClass=EAgreement.class, fetch=FetchType.LAZY)
    @CollectionTable(name="legal_restr_documents")
    @Column(name="agreement")
    @Enumerated(value=EnumType.STRING)
    private List<EAgreement> legalRestrictionsDocuments;
    @Column(name="other_legal_r_documents")
    private String otherLegalRestrictionsDocument;
    @Column(name="legal_restrictions_comment")
    private String legalRestrictionsComment;
    @Column(name="data_rights_access_control")
    private String dataRightsAndAccessControl;
    @Column(name="human_participants")
    private Boolean humanParticipants;
    @Column(name="human_participants_cris")
    private Boolean humanParticipantsCris;
    @Column(name="ethical_issues_exist")
    private Boolean ethicalIssuesExist;
    @Column(name="ethical_issues_exist_cris")
    private Boolean ethicalIssuesExistCris;
    @Column(name="committee_reviewed")
    private Boolean committeeReviewed;
    @Column(name="committee_reviewed_cris")
    private Boolean committeeReviewedCris;
    @Column(name="ethical_issues_report")
    private String ethicalIssuesReport;
    @OneToMany(mappedBy="dmp", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @OrderBy(value="id")
    private List<Contributor> contributorList = new ArrayList<Contributor>();
    @OneToMany(mappedBy="dmp", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @OrderBy(value="id")
    private List<Dataset> datasetList = new ArrayList<Dataset>();
    @OneToMany(mappedBy="dmp", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private List<Host> hostList = new ArrayList<Host>();
    @Column(name="external_storage_info")
    private String externalStorageInfo;
    @Column(name="restricted_access_info")
    private String restrictedAccessInfo;
    @Column(name="closed_access_info")
    private String closedAccessInfo;
    @Column(name="costs_exist")
    private Boolean costsExist;
    @Column(name="costs_exist_cris")
    private Boolean costsExistCris;
    @OneToMany(mappedBy="dmp", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @OrderBy(value="id")
    private List<Cost> costs = new ArrayList<Cost>();
    private String documentation;

    public Contributor getContact() {
        Optional<Contributor> contact = this.contributorList.stream().filter(contributor -> contributor.getContact() != null).filter(Contributor::getContact).findFirst();
        return contact.orElse(null);
    }

    public String getProjectUniversityId() {
        if (this.getProject() == null || this.getProject().getUniversityId() == null) {
            return null;
        }
        return this.getProject().getUniversityId();
    }

    @Generated
    public Dmp() {
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public Date getModified() {
        return this.modified;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public EDataKind getDataKind() {
        return this.dataKind;
    }

    @Generated
    public EDataKind getReusedDataKind() {
        return this.reusedDataKind;
    }

    @Generated
    public String getNoDataExplanation() {
        return this.noDataExplanation;
    }

    @Generated
    public String getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getDataGeneration() {
        return this.dataGeneration;
    }

    @Generated
    public String getStructure() {
        return this.structure;
    }

    @Generated
    public List<EDataQualityType> getDataQuality() {
        return this.dataQuality;
    }

    @Generated
    public String getOtherDataQuality() {
        return this.otherDataQuality;
    }

    @Generated
    public String getTargetAudience() {
        return this.targetAudience;
    }

    @Generated
    public String getTools() {
        return this.tools;
    }

    @Generated
    public String getRestrictedDataAccess() {
        return this.restrictedDataAccess;
    }

    @Generated
    public Boolean getPersonalData() {
        return this.personalData;
    }

    @Generated
    public Boolean getPersonalDataCris() {
        return this.personalDataCris;
    }

    @Generated
    public List<EComplianceType> getPersonalDataCompliance() {
        return this.personalDataCompliance;
    }

    @Generated
    public String getOtherPersonalDataCompliance() {
        return this.otherPersonalDataCompliance;
    }

    @Generated
    public Boolean getSensitiveData() {
        return this.sensitiveData;
    }

    @Generated
    public Boolean getSensitiveDataCris() {
        return this.sensitiveDataCris;
    }

    @Generated
    public List<ESecurityMeasure> getSensitiveDataSecurity() {
        return this.sensitiveDataSecurity;
    }

    @Generated
    public String getOtherDataSecurityMeasures() {
        return this.otherDataSecurityMeasures;
    }

    @Generated
    public String getSensitiveDataAccess() {
        return this.sensitiveDataAccess;
    }

    @Generated
    public Boolean getLegalRestrictions() {
        return this.legalRestrictions;
    }

    @Generated
    public Boolean getLegalRestrictionsCris() {
        return this.legalRestrictionsCris;
    }

    @Generated
    public List<EAgreement> getLegalRestrictionsDocuments() {
        return this.legalRestrictionsDocuments;
    }

    @Generated
    public String getOtherLegalRestrictionsDocument() {
        return this.otherLegalRestrictionsDocument;
    }

    @Generated
    public String getLegalRestrictionsComment() {
        return this.legalRestrictionsComment;
    }

    @Generated
    public String getDataRightsAndAccessControl() {
        return this.dataRightsAndAccessControl;
    }

    @Generated
    public Boolean getHumanParticipants() {
        return this.humanParticipants;
    }

    @Generated
    public Boolean getHumanParticipantsCris() {
        return this.humanParticipantsCris;
    }

    @Generated
    public Boolean getEthicalIssuesExist() {
        return this.ethicalIssuesExist;
    }

    @Generated
    public Boolean getEthicalIssuesExistCris() {
        return this.ethicalIssuesExistCris;
    }

    @Generated
    public Boolean getCommitteeReviewed() {
        return this.committeeReviewed;
    }

    @Generated
    public Boolean getCommitteeReviewedCris() {
        return this.committeeReviewedCris;
    }

    @Generated
    public String getEthicalIssuesReport() {
        return this.ethicalIssuesReport;
    }

    @Generated
    public List<Contributor> getContributorList() {
        return this.contributorList;
    }

    @Generated
    public List<Dataset> getDatasetList() {
        return this.datasetList;
    }

    @Generated
    public List<Host> getHostList() {
        return this.hostList;
    }

    @Generated
    public String getExternalStorageInfo() {
        return this.externalStorageInfo;
    }

    @Generated
    public String getRestrictedAccessInfo() {
        return this.restrictedAccessInfo;
    }

    @Generated
    public String getClosedAccessInfo() {
        return this.closedAccessInfo;
    }

    @Generated
    public Boolean getCostsExist() {
        return this.costsExist;
    }

    @Generated
    public Boolean getCostsExistCris() {
        return this.costsExistCris;
    }

    @Generated
    public List<Cost> getCosts() {
        return this.costs;
    }

    @Generated
    public String getDocumentation() {
        return this.documentation;
    }

    @Generated
    public void setCreated(Date created) {
        this.created = created;
    }

    @Generated
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setDataKind(EDataKind dataKind) {
        this.dataKind = dataKind;
    }

    @Generated
    public void setReusedDataKind(EDataKind reusedDataKind) {
        this.reusedDataKind = reusedDataKind;
    }

    @Generated
    public void setNoDataExplanation(String noDataExplanation) {
        this.noDataExplanation = noDataExplanation;
    }

    @Generated
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setDataGeneration(String dataGeneration) {
        this.dataGeneration = dataGeneration;
    }

    @Generated
    public void setStructure(String structure) {
        this.structure = structure;
    }

    @Generated
    public void setDataQuality(List<EDataQualityType> dataQuality) {
        this.dataQuality = dataQuality;
    }

    @Generated
    public void setOtherDataQuality(String otherDataQuality) {
        this.otherDataQuality = otherDataQuality;
    }

    @Generated
    public void setTargetAudience(String targetAudience) {
        this.targetAudience = targetAudience;
    }

    @Generated
    public void setTools(String tools) {
        this.tools = tools;
    }

    @Generated
    public void setRestrictedDataAccess(String restrictedDataAccess) {
        this.restrictedDataAccess = restrictedDataAccess;
    }

    @Generated
    public void setPersonalData(Boolean personalData) {
        this.personalData = personalData;
    }

    @Generated
    public void setPersonalDataCris(Boolean personalDataCris) {
        this.personalDataCris = personalDataCris;
    }

    @Generated
    public void setPersonalDataCompliance(List<EComplianceType> personalDataCompliance) {
        this.personalDataCompliance = personalDataCompliance;
    }

    @Generated
    public void setOtherPersonalDataCompliance(String otherPersonalDataCompliance) {
        this.otherPersonalDataCompliance = otherPersonalDataCompliance;
    }

    @Generated
    public void setSensitiveData(Boolean sensitiveData) {
        this.sensitiveData = sensitiveData;
    }

    @Generated
    public void setSensitiveDataCris(Boolean sensitiveDataCris) {
        this.sensitiveDataCris = sensitiveDataCris;
    }

    @Generated
    public void setSensitiveDataSecurity(List<ESecurityMeasure> sensitiveDataSecurity) {
        this.sensitiveDataSecurity = sensitiveDataSecurity;
    }

    @Generated
    public void setOtherDataSecurityMeasures(String otherDataSecurityMeasures) {
        this.otherDataSecurityMeasures = otherDataSecurityMeasures;
    }

    @Generated
    public void setSensitiveDataAccess(String sensitiveDataAccess) {
        this.sensitiveDataAccess = sensitiveDataAccess;
    }

    @Generated
    public void setLegalRestrictions(Boolean legalRestrictions) {
        this.legalRestrictions = legalRestrictions;
    }

    @Generated
    public void setLegalRestrictionsCris(Boolean legalRestrictionsCris) {
        this.legalRestrictionsCris = legalRestrictionsCris;
    }

    @Generated
    public void setLegalRestrictionsDocuments(List<EAgreement> legalRestrictionsDocuments) {
        this.legalRestrictionsDocuments = legalRestrictionsDocuments;
    }

    @Generated
    public void setOtherLegalRestrictionsDocument(String otherLegalRestrictionsDocument) {
        this.otherLegalRestrictionsDocument = otherLegalRestrictionsDocument;
    }

    @Generated
    public void setLegalRestrictionsComment(String legalRestrictionsComment) {
        this.legalRestrictionsComment = legalRestrictionsComment;
    }

    @Generated
    public void setDataRightsAndAccessControl(String dataRightsAndAccessControl) {
        this.dataRightsAndAccessControl = dataRightsAndAccessControl;
    }

    @Generated
    public void setHumanParticipants(Boolean humanParticipants) {
        this.humanParticipants = humanParticipants;
    }

    @Generated
    public void setHumanParticipantsCris(Boolean humanParticipantsCris) {
        this.humanParticipantsCris = humanParticipantsCris;
    }

    @Generated
    public void setEthicalIssuesExist(Boolean ethicalIssuesExist) {
        this.ethicalIssuesExist = ethicalIssuesExist;
    }

    @Generated
    public void setEthicalIssuesExistCris(Boolean ethicalIssuesExistCris) {
        this.ethicalIssuesExistCris = ethicalIssuesExistCris;
    }

    @Generated
    public void setCommitteeReviewed(Boolean committeeReviewed) {
        this.committeeReviewed = committeeReviewed;
    }

    @Generated
    public void setCommitteeReviewedCris(Boolean committeeReviewedCris) {
        this.committeeReviewedCris = committeeReviewedCris;
    }

    @Generated
    public void setEthicalIssuesReport(String ethicalIssuesReport) {
        this.ethicalIssuesReport = ethicalIssuesReport;
    }

    @Generated
    public void setContributorList(List<Contributor> contributorList) {
        this.contributorList = contributorList;
    }

    @Generated
    public void setDatasetList(List<Dataset> datasetList) {
        this.datasetList = datasetList;
    }

    @Generated
    public void setHostList(List<Host> hostList) {
        this.hostList = hostList;
    }

    @Generated
    public void setExternalStorageInfo(String externalStorageInfo) {
        this.externalStorageInfo = externalStorageInfo;
    }

    @Generated
    public void setRestrictedAccessInfo(String restrictedAccessInfo) {
        this.restrictedAccessInfo = restrictedAccessInfo;
    }

    @Generated
    public void setClosedAccessInfo(String closedAccessInfo) {
        this.closedAccessInfo = closedAccessInfo;
    }

    @Generated
    public void setCostsExist(Boolean costsExist) {
        this.costsExist = costsExist;
    }

    @Generated
    public void setCostsExistCris(Boolean costsExistCris) {
        this.costsExistCris = costsExistCris;
    }

    @Generated
    public void setCosts(List<Cost> costs) {
        this.costs = costs;
    }

    @Generated
    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Generated
    public String toString() {
        return "Dmp(version=" + this.getVersion() + ", created=" + String.valueOf(this.getCreated()) + ", modified=" + String.valueOf(this.getModified()) + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", project=" + String.valueOf((Object)this.getProject()) + ", dataKind=" + String.valueOf((Object)this.getDataKind()) + ", reusedDataKind=" + String.valueOf((Object)this.getReusedDataKind()) + ", noDataExplanation=" + this.getNoDataExplanation() + ", metadata=" + this.getMetadata() + ", dataGeneration=" + this.getDataGeneration() + ", structure=" + this.getStructure() + ", dataQuality=" + String.valueOf(this.getDataQuality()) + ", otherDataQuality=" + this.getOtherDataQuality() + ", targetAudience=" + this.getTargetAudience() + ", tools=" + this.getTools() + ", restrictedDataAccess=" + this.getRestrictedDataAccess() + ", personalData=" + this.getPersonalData() + ", personalDataCris=" + this.getPersonalDataCris() + ", personalDataCompliance=" + String.valueOf(this.getPersonalDataCompliance()) + ", otherPersonalDataCompliance=" + this.getOtherPersonalDataCompliance() + ", sensitiveData=" + this.getSensitiveData() + ", sensitiveDataCris=" + this.getSensitiveDataCris() + ", sensitiveDataSecurity=" + String.valueOf(this.getSensitiveDataSecurity()) + ", otherDataSecurityMeasures=" + this.getOtherDataSecurityMeasures() + ", sensitiveDataAccess=" + this.getSensitiveDataAccess() + ", legalRestrictions=" + this.getLegalRestrictions() + ", legalRestrictionsCris=" + this.getLegalRestrictionsCris() + ", legalRestrictionsDocuments=" + String.valueOf(this.getLegalRestrictionsDocuments()) + ", otherLegalRestrictionsDocument=" + this.getOtherLegalRestrictionsDocument() + ", legalRestrictionsComment=" + this.getLegalRestrictionsComment() + ", dataRightsAndAccessControl=" + this.getDataRightsAndAccessControl() + ", humanParticipants=" + this.getHumanParticipants() + ", humanParticipantsCris=" + this.getHumanParticipantsCris() + ", ethicalIssuesExist=" + this.getEthicalIssuesExist() + ", ethicalIssuesExistCris=" + this.getEthicalIssuesExistCris() + ", committeeReviewed=" + this.getCommitteeReviewed() + ", committeeReviewedCris=" + this.getCommitteeReviewedCris() + ", ethicalIssuesReport=" + this.getEthicalIssuesReport() + ", contributorList=" + String.valueOf(this.getContributorList()) + ", datasetList=" + String.valueOf(this.getDatasetList()) + ", hostList=" + String.valueOf(this.getHostList()) + ", externalStorageInfo=" + this.getExternalStorageInfo() + ", restrictedAccessInfo=" + this.getRestrictedAccessInfo() + ", closedAccessInfo=" + this.getClosedAccessInfo() + ", costsExist=" + this.getCostsExist() + ", costsExistCris=" + this.getCostsExistCris() + ", costs=" + String.valueOf(this.getCosts()) + ", documentation=" + this.getDocumentation() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dmp)) {
            return false;
        }
        Dmp other = (Dmp)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Boolean this$personalData = this.getPersonalData();
        Boolean other$personalData = other.getPersonalData();
        if (this$personalData == null ? other$personalData != null : !((Object)this$personalData).equals(other$personalData)) {
            return false;
        }
        Boolean this$personalDataCris = this.getPersonalDataCris();
        Boolean other$personalDataCris = other.getPersonalDataCris();
        if (this$personalDataCris == null ? other$personalDataCris != null : !((Object)this$personalDataCris).equals(other$personalDataCris)) {
            return false;
        }
        Boolean this$sensitiveData = this.getSensitiveData();
        Boolean other$sensitiveData = other.getSensitiveData();
        if (this$sensitiveData == null ? other$sensitiveData != null : !((Object)this$sensitiveData).equals(other$sensitiveData)) {
            return false;
        }
        Boolean this$sensitiveDataCris = this.getSensitiveDataCris();
        Boolean other$sensitiveDataCris = other.getSensitiveDataCris();
        if (this$sensitiveDataCris == null ? other$sensitiveDataCris != null : !((Object)this$sensitiveDataCris).equals(other$sensitiveDataCris)) {
            return false;
        }
        Boolean this$legalRestrictions = this.getLegalRestrictions();
        Boolean other$legalRestrictions = other.getLegalRestrictions();
        if (this$legalRestrictions == null ? other$legalRestrictions != null : !((Object)this$legalRestrictions).equals(other$legalRestrictions)) {
            return false;
        }
        Boolean this$legalRestrictionsCris = this.getLegalRestrictionsCris();
        Boolean other$legalRestrictionsCris = other.getLegalRestrictionsCris();
        if (this$legalRestrictionsCris == null ? other$legalRestrictionsCris != null : !((Object)this$legalRestrictionsCris).equals(other$legalRestrictionsCris)) {
            return false;
        }
        Boolean this$humanParticipants = this.getHumanParticipants();
        Boolean other$humanParticipants = other.getHumanParticipants();
        if (this$humanParticipants == null ? other$humanParticipants != null : !((Object)this$humanParticipants).equals(other$humanParticipants)) {
            return false;
        }
        Boolean this$humanParticipantsCris = this.getHumanParticipantsCris();
        Boolean other$humanParticipantsCris = other.getHumanParticipantsCris();
        if (this$humanParticipantsCris == null ? other$humanParticipantsCris != null : !((Object)this$humanParticipantsCris).equals(other$humanParticipantsCris)) {
            return false;
        }
        Boolean this$ethicalIssuesExist = this.getEthicalIssuesExist();
        Boolean other$ethicalIssuesExist = other.getEthicalIssuesExist();
        if (this$ethicalIssuesExist == null ? other$ethicalIssuesExist != null : !((Object)this$ethicalIssuesExist).equals(other$ethicalIssuesExist)) {
            return false;
        }
        Boolean this$ethicalIssuesExistCris = this.getEthicalIssuesExistCris();
        Boolean other$ethicalIssuesExistCris = other.getEthicalIssuesExistCris();
        if (this$ethicalIssuesExistCris == null ? other$ethicalIssuesExistCris != null : !((Object)this$ethicalIssuesExistCris).equals(other$ethicalIssuesExistCris)) {
            return false;
        }
        Boolean this$committeeReviewed = this.getCommitteeReviewed();
        Boolean other$committeeReviewed = other.getCommitteeReviewed();
        if (this$committeeReviewed == null ? other$committeeReviewed != null : !((Object)this$committeeReviewed).equals(other$committeeReviewed)) {
            return false;
        }
        Boolean this$committeeReviewedCris = this.getCommitteeReviewedCris();
        Boolean other$committeeReviewedCris = other.getCommitteeReviewedCris();
        if (this$committeeReviewedCris == null ? other$committeeReviewedCris != null : !((Object)this$committeeReviewedCris).equals(other$committeeReviewedCris)) {
            return false;
        }
        Boolean this$costsExist = this.getCostsExist();
        Boolean other$costsExist = other.getCostsExist();
        if (this$costsExist == null ? other$costsExist != null : !((Object)this$costsExist).equals(other$costsExist)) {
            return false;
        }
        Boolean this$costsExistCris = this.getCostsExistCris();
        Boolean other$costsExistCris = other.getCostsExistCris();
        if (this$costsExistCris == null ? other$costsExistCris != null : !((Object)this$costsExistCris).equals(other$costsExistCris)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Date this$modified = this.getModified();
        Date other$modified = other.getModified();
        if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Project this$project = this.getProject();
        Project other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)((Object)this$project)).equals((Object)other$project)) {
            return false;
        }
        EDataKind this$dataKind = this.getDataKind();
        EDataKind other$dataKind = other.getDataKind();
        if (this$dataKind == null ? other$dataKind != null : !((Object)((Object)this$dataKind)).equals((Object)other$dataKind)) {
            return false;
        }
        EDataKind this$reusedDataKind = this.getReusedDataKind();
        EDataKind other$reusedDataKind = other.getReusedDataKind();
        if (this$reusedDataKind == null ? other$reusedDataKind != null : !((Object)((Object)this$reusedDataKind)).equals((Object)other$reusedDataKind)) {
            return false;
        }
        String this$noDataExplanation = this.getNoDataExplanation();
        String other$noDataExplanation = other.getNoDataExplanation();
        if (this$noDataExplanation == null ? other$noDataExplanation != null : !this$noDataExplanation.equals(other$noDataExplanation)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$dataGeneration = this.getDataGeneration();
        String other$dataGeneration = other.getDataGeneration();
        if (this$dataGeneration == null ? other$dataGeneration != null : !this$dataGeneration.equals(other$dataGeneration)) {
            return false;
        }
        String this$structure = this.getStructure();
        String other$structure = other.getStructure();
        if (this$structure == null ? other$structure != null : !this$structure.equals(other$structure)) {
            return false;
        }
        List<EDataQualityType> this$dataQuality = this.getDataQuality();
        List<EDataQualityType> other$dataQuality = other.getDataQuality();
        if (this$dataQuality == null ? other$dataQuality != null : !((Object)this$dataQuality).equals(other$dataQuality)) {
            return false;
        }
        String this$otherDataQuality = this.getOtherDataQuality();
        String other$otherDataQuality = other.getOtherDataQuality();
        if (this$otherDataQuality == null ? other$otherDataQuality != null : !this$otherDataQuality.equals(other$otherDataQuality)) {
            return false;
        }
        String this$targetAudience = this.getTargetAudience();
        String other$targetAudience = other.getTargetAudience();
        if (this$targetAudience == null ? other$targetAudience != null : !this$targetAudience.equals(other$targetAudience)) {
            return false;
        }
        String this$tools = this.getTools();
        String other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !this$tools.equals(other$tools)) {
            return false;
        }
        String this$restrictedDataAccess = this.getRestrictedDataAccess();
        String other$restrictedDataAccess = other.getRestrictedDataAccess();
        if (this$restrictedDataAccess == null ? other$restrictedDataAccess != null : !this$restrictedDataAccess.equals(other$restrictedDataAccess)) {
            return false;
        }
        List<EComplianceType> this$personalDataCompliance = this.getPersonalDataCompliance();
        List<EComplianceType> other$personalDataCompliance = other.getPersonalDataCompliance();
        if (this$personalDataCompliance == null ? other$personalDataCompliance != null : !((Object)this$personalDataCompliance).equals(other$personalDataCompliance)) {
            return false;
        }
        String this$otherPersonalDataCompliance = this.getOtherPersonalDataCompliance();
        String other$otherPersonalDataCompliance = other.getOtherPersonalDataCompliance();
        if (this$otherPersonalDataCompliance == null ? other$otherPersonalDataCompliance != null : !this$otherPersonalDataCompliance.equals(other$otherPersonalDataCompliance)) {
            return false;
        }
        List<ESecurityMeasure> this$sensitiveDataSecurity = this.getSensitiveDataSecurity();
        List<ESecurityMeasure> other$sensitiveDataSecurity = other.getSensitiveDataSecurity();
        if (this$sensitiveDataSecurity == null ? other$sensitiveDataSecurity != null : !((Object)this$sensitiveDataSecurity).equals(other$sensitiveDataSecurity)) {
            return false;
        }
        String this$otherDataSecurityMeasures = this.getOtherDataSecurityMeasures();
        String other$otherDataSecurityMeasures = other.getOtherDataSecurityMeasures();
        if (this$otherDataSecurityMeasures == null ? other$otherDataSecurityMeasures != null : !this$otherDataSecurityMeasures.equals(other$otherDataSecurityMeasures)) {
            return false;
        }
        String this$sensitiveDataAccess = this.getSensitiveDataAccess();
        String other$sensitiveDataAccess = other.getSensitiveDataAccess();
        if (this$sensitiveDataAccess == null ? other$sensitiveDataAccess != null : !this$sensitiveDataAccess.equals(other$sensitiveDataAccess)) {
            return false;
        }
        List<EAgreement> this$legalRestrictionsDocuments = this.getLegalRestrictionsDocuments();
        List<EAgreement> other$legalRestrictionsDocuments = other.getLegalRestrictionsDocuments();
        if (this$legalRestrictionsDocuments == null ? other$legalRestrictionsDocuments != null : !((Object)this$legalRestrictionsDocuments).equals(other$legalRestrictionsDocuments)) {
            return false;
        }
        String this$otherLegalRestrictionsDocument = this.getOtherLegalRestrictionsDocument();
        String other$otherLegalRestrictionsDocument = other.getOtherLegalRestrictionsDocument();
        if (this$otherLegalRestrictionsDocument == null ? other$otherLegalRestrictionsDocument != null : !this$otherLegalRestrictionsDocument.equals(other$otherLegalRestrictionsDocument)) {
            return false;
        }
        String this$legalRestrictionsComment = this.getLegalRestrictionsComment();
        String other$legalRestrictionsComment = other.getLegalRestrictionsComment();
        if (this$legalRestrictionsComment == null ? other$legalRestrictionsComment != null : !this$legalRestrictionsComment.equals(other$legalRestrictionsComment)) {
            return false;
        }
        String this$dataRightsAndAccessControl = this.getDataRightsAndAccessControl();
        String other$dataRightsAndAccessControl = other.getDataRightsAndAccessControl();
        if (this$dataRightsAndAccessControl == null ? other$dataRightsAndAccessControl != null : !this$dataRightsAndAccessControl.equals(other$dataRightsAndAccessControl)) {
            return false;
        }
        String this$ethicalIssuesReport = this.getEthicalIssuesReport();
        String other$ethicalIssuesReport = other.getEthicalIssuesReport();
        if (this$ethicalIssuesReport == null ? other$ethicalIssuesReport != null : !this$ethicalIssuesReport.equals(other$ethicalIssuesReport)) {
            return false;
        }
        List<Contributor> this$contributorList = this.getContributorList();
        List<Contributor> other$contributorList = other.getContributorList();
        if (this$contributorList == null ? other$contributorList != null : !((Object)this$contributorList).equals(other$contributorList)) {
            return false;
        }
        List<Dataset> this$datasetList = this.getDatasetList();
        List<Dataset> other$datasetList = other.getDatasetList();
        if (this$datasetList == null ? other$datasetList != null : !((Object)this$datasetList).equals(other$datasetList)) {
            return false;
        }
        List<Host> this$hostList = this.getHostList();
        List<Host> other$hostList = other.getHostList();
        if (this$hostList == null ? other$hostList != null : !((Object)this$hostList).equals(other$hostList)) {
            return false;
        }
        String this$externalStorageInfo = this.getExternalStorageInfo();
        String other$externalStorageInfo = other.getExternalStorageInfo();
        if (this$externalStorageInfo == null ? other$externalStorageInfo != null : !this$externalStorageInfo.equals(other$externalStorageInfo)) {
            return false;
        }
        String this$restrictedAccessInfo = this.getRestrictedAccessInfo();
        String other$restrictedAccessInfo = other.getRestrictedAccessInfo();
        if (this$restrictedAccessInfo == null ? other$restrictedAccessInfo != null : !this$restrictedAccessInfo.equals(other$restrictedAccessInfo)) {
            return false;
        }
        String this$closedAccessInfo = this.getClosedAccessInfo();
        String other$closedAccessInfo = other.getClosedAccessInfo();
        if (this$closedAccessInfo == null ? other$closedAccessInfo != null : !this$closedAccessInfo.equals(other$closedAccessInfo)) {
            return false;
        }
        List<Cost> this$costs = this.getCosts();
        List<Cost> other$costs = other.getCosts();
        if (this$costs == null ? other$costs != null : !((Object)this$costs).equals(other$costs)) {
            return false;
        }
        String this$documentation = this.getDocumentation();
        String other$documentation = other.getDocumentation();
        return !(this$documentation == null ? other$documentation != null : !this$documentation.equals(other$documentation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dmp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Boolean $personalData = this.getPersonalData();
        result = result * 59 + ($personalData == null ? 43 : ((Object)$personalData).hashCode());
        Boolean $personalDataCris = this.getPersonalDataCris();
        result = result * 59 + ($personalDataCris == null ? 43 : ((Object)$personalDataCris).hashCode());
        Boolean $sensitiveData = this.getSensitiveData();
        result = result * 59 + ($sensitiveData == null ? 43 : ((Object)$sensitiveData).hashCode());
        Boolean $sensitiveDataCris = this.getSensitiveDataCris();
        result = result * 59 + ($sensitiveDataCris == null ? 43 : ((Object)$sensitiveDataCris).hashCode());
        Boolean $legalRestrictions = this.getLegalRestrictions();
        result = result * 59 + ($legalRestrictions == null ? 43 : ((Object)$legalRestrictions).hashCode());
        Boolean $legalRestrictionsCris = this.getLegalRestrictionsCris();
        result = result * 59 + ($legalRestrictionsCris == null ? 43 : ((Object)$legalRestrictionsCris).hashCode());
        Boolean $humanParticipants = this.getHumanParticipants();
        result = result * 59 + ($humanParticipants == null ? 43 : ((Object)$humanParticipants).hashCode());
        Boolean $humanParticipantsCris = this.getHumanParticipantsCris();
        result = result * 59 + ($humanParticipantsCris == null ? 43 : ((Object)$humanParticipantsCris).hashCode());
        Boolean $ethicalIssuesExist = this.getEthicalIssuesExist();
        result = result * 59 + ($ethicalIssuesExist == null ? 43 : ((Object)$ethicalIssuesExist).hashCode());
        Boolean $ethicalIssuesExistCris = this.getEthicalIssuesExistCris();
        result = result * 59 + ($ethicalIssuesExistCris == null ? 43 : ((Object)$ethicalIssuesExistCris).hashCode());
        Boolean $committeeReviewed = this.getCommitteeReviewed();
        result = result * 59 + ($committeeReviewed == null ? 43 : ((Object)$committeeReviewed).hashCode());
        Boolean $committeeReviewedCris = this.getCommitteeReviewedCris();
        result = result * 59 + ($committeeReviewedCris == null ? 43 : ((Object)$committeeReviewedCris).hashCode());
        Boolean $costsExist = this.getCostsExist();
        result = result * 59 + ($costsExist == null ? 43 : ((Object)$costsExist).hashCode());
        Boolean $costsExistCris = this.getCostsExistCris();
        result = result * 59 + ($costsExistCris == null ? 43 : ((Object)$costsExistCris).hashCode());
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Date $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Project $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)((Object)$project)).hashCode());
        EDataKind $dataKind = this.getDataKind();
        result = result * 59 + ($dataKind == null ? 43 : ((Object)((Object)$dataKind)).hashCode());
        EDataKind $reusedDataKind = this.getReusedDataKind();
        result = result * 59 + ($reusedDataKind == null ? 43 : ((Object)((Object)$reusedDataKind)).hashCode());
        String $noDataExplanation = this.getNoDataExplanation();
        result = result * 59 + ($noDataExplanation == null ? 43 : $noDataExplanation.hashCode());
        String $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $dataGeneration = this.getDataGeneration();
        result = result * 59 + ($dataGeneration == null ? 43 : $dataGeneration.hashCode());
        String $structure = this.getStructure();
        result = result * 59 + ($structure == null ? 43 : $structure.hashCode());
        List<EDataQualityType> $dataQuality = this.getDataQuality();
        result = result * 59 + ($dataQuality == null ? 43 : ((Object)$dataQuality).hashCode());
        String $otherDataQuality = this.getOtherDataQuality();
        result = result * 59 + ($otherDataQuality == null ? 43 : $otherDataQuality.hashCode());
        String $targetAudience = this.getTargetAudience();
        result = result * 59 + ($targetAudience == null ? 43 : $targetAudience.hashCode());
        String $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : $tools.hashCode());
        String $restrictedDataAccess = this.getRestrictedDataAccess();
        result = result * 59 + ($restrictedDataAccess == null ? 43 : $restrictedDataAccess.hashCode());
        List<EComplianceType> $personalDataCompliance = this.getPersonalDataCompliance();
        result = result * 59 + ($personalDataCompliance == null ? 43 : ((Object)$personalDataCompliance).hashCode());
        String $otherPersonalDataCompliance = this.getOtherPersonalDataCompliance();
        result = result * 59 + ($otherPersonalDataCompliance == null ? 43 : $otherPersonalDataCompliance.hashCode());
        List<ESecurityMeasure> $sensitiveDataSecurity = this.getSensitiveDataSecurity();
        result = result * 59 + ($sensitiveDataSecurity == null ? 43 : ((Object)$sensitiveDataSecurity).hashCode());
        String $otherDataSecurityMeasures = this.getOtherDataSecurityMeasures();
        result = result * 59 + ($otherDataSecurityMeasures == null ? 43 : $otherDataSecurityMeasures.hashCode());
        String $sensitiveDataAccess = this.getSensitiveDataAccess();
        result = result * 59 + ($sensitiveDataAccess == null ? 43 : $sensitiveDataAccess.hashCode());
        List<EAgreement> $legalRestrictionsDocuments = this.getLegalRestrictionsDocuments();
        result = result * 59 + ($legalRestrictionsDocuments == null ? 43 : ((Object)$legalRestrictionsDocuments).hashCode());
        String $otherLegalRestrictionsDocument = this.getOtherLegalRestrictionsDocument();
        result = result * 59 + ($otherLegalRestrictionsDocument == null ? 43 : $otherLegalRestrictionsDocument.hashCode());
        String $legalRestrictionsComment = this.getLegalRestrictionsComment();
        result = result * 59 + ($legalRestrictionsComment == null ? 43 : $legalRestrictionsComment.hashCode());
        String $dataRightsAndAccessControl = this.getDataRightsAndAccessControl();
        result = result * 59 + ($dataRightsAndAccessControl == null ? 43 : $dataRightsAndAccessControl.hashCode());
        String $ethicalIssuesReport = this.getEthicalIssuesReport();
        result = result * 59 + ($ethicalIssuesReport == null ? 43 : $ethicalIssuesReport.hashCode());
        List<Contributor> $contributorList = this.getContributorList();
        result = result * 59 + ($contributorList == null ? 43 : ((Object)$contributorList).hashCode());
        List<Dataset> $datasetList = this.getDatasetList();
        result = result * 59 + ($datasetList == null ? 43 : ((Object)$datasetList).hashCode());
        List<Host> $hostList = this.getHostList();
        result = result * 59 + ($hostList == null ? 43 : ((Object)$hostList).hashCode());
        String $externalStorageInfo = this.getExternalStorageInfo();
        result = result * 59 + ($externalStorageInfo == null ? 43 : $externalStorageInfo.hashCode());
        String $restrictedAccessInfo = this.getRestrictedAccessInfo();
        result = result * 59 + ($restrictedAccessInfo == null ? 43 : $restrictedAccessInfo.hashCode());
        String $closedAccessInfo = this.getClosedAccessInfo();
        result = result * 59 + ($closedAccessInfo == null ? 43 : $closedAccessInfo.hashCode());
        List<Cost> $costs = this.getCosts();
        result = result * 59 + ($costs == null ? 43 : ((Object)$costs).hashCode());
        String $documentation = this.getDocumentation();
        result = result * 59 + ($documentation == null ? 43 : $documentation.hashCode());
        return result;
    }
}

