/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkus.hibernate.orm.panache.PanacheEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Version;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.damap.base.domain.Distribution;
import org.damap.base.domain.Dmp;
import org.hibernate.envers.Audited;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="discriminator", discriminatorType=DiscriminatorType.STRING)
@Audited
public class Host
extends PanacheEntity {
    @Version
    private long version;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dmp_id")
    private Dmp dmp;
    private String title;
    @OneToMany(mappedBy="host", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Distribution> distributionList = new ArrayList<Distribution>();

    @Generated
    public Host() {
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public Dmp getDmp() {
        return this.dmp;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public List<Distribution> getDistributionList() {
        return this.distributionList;
    }

    @JsonIgnore
    @Generated
    public void setDmp(Dmp dmp) {
        this.dmp = dmp;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDistributionList(List<Distribution> distributionList) {
        this.distributionList = distributionList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Host)) {
            return false;
        }
        Host other = (Host)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Host;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Host(version=" + this.getVersion() + ", title=" + this.getTitle() + ")";
    }
}

