/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.enums;

import java.util.HashMap;

public enum EDataAccessType {
    OPEN("Open"),
    RESTRICTED("Restricted"),
    CLOSED("Closed");

    private final String value;
    private static final HashMap<String, EDataAccessType> MAP;

    private EDataAccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public static EDataAccessType getByValue(String value) {
        return MAP.get(value);
    }

    public int compare(EDataAccessType other) {
        if (other == null) {
            return 1;
        }
        if (this == other) {
            return 0;
        }
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case CLOSED -> 1;
            case RESTRICTED -> {
                if (other == CLOSED) {
                    yield -1;
                }
                yield 1;
            }
            case OPEN -> -1;
        };
    }

    static {
        MAP = new HashMap();
        for (EDataAccessType type : EDataAccessType.values()) {
            MAP.put(type.getValue(), type);
        }
    }
}

