/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.enums;

import java.util.ArrayList;
import java.util.List;

public enum EIdentifierType {
    ORCID("ORCID"),
    ISNI("ISNI"),
    OPENID("OpenId"),
    OTHER("Other"),
    HANDLE("Handle"),
    DOI("DOI"),
    ARK("ARK"),
    URL("URL"),
    HDL("HDL"),
    PURL("PURL"),
    URN("URN"),
    FUNDREF("FundRef"),
    ROR("ROR");

    private final String type;
    private static final List<EIdentifierType> personIdentifierType;
    private static final List<EIdentifierType> datasetIdentifierType;
    private static final List<EIdentifierType> funderIdentifierType;
    private static final List<EIdentifierType> grantIdentifierType;
    private static final List<EIdentifierType> metadataIdentifierType;

    private EIdentifierType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static List<EIdentifierType> getPersonIdentifierTypeList() {
        return personIdentifierType;
    }

    public static List<EIdentifierType> getDatasetIdentifierTypeList() {
        return datasetIdentifierType;
    }

    public static List<EIdentifierType> getFunderIdentifierTypeList() {
        return funderIdentifierType;
    }

    public static List<EIdentifierType> getGrantIdentifierTypeList() {
        return grantIdentifierType;
    }

    public static List<EIdentifierType> getMetadataIdentifierTypeList() {
        return metadataIdentifierType;
    }

    public String toString() {
        return this.type;
    }

    static {
        personIdentifierType = new ArrayList<EIdentifierType>();
        datasetIdentifierType = new ArrayList<EIdentifierType>();
        funderIdentifierType = new ArrayList<EIdentifierType>();
        grantIdentifierType = new ArrayList<EIdentifierType>();
        metadataIdentifierType = new ArrayList<EIdentifierType>();
        personIdentifierType.add(ORCID);
        personIdentifierType.add(ISNI);
        personIdentifierType.add(OPENID);
        personIdentifierType.add(OTHER);
        datasetIdentifierType.add(HANDLE);
        datasetIdentifierType.add(DOI);
        datasetIdentifierType.add(ARK);
        datasetIdentifierType.add(URL);
        datasetIdentifierType.add(OTHER);
        datasetIdentifierType.add(HDL);
        datasetIdentifierType.add(PURL);
        datasetIdentifierType.add(URN);
        funderIdentifierType.add(FUNDREF);
        funderIdentifierType.add(URL);
        funderIdentifierType.add(ROR);
        funderIdentifierType.add(ISNI);
        funderIdentifierType.add(OTHER);
        grantIdentifierType.add(URL);
        grantIdentifierType.add(OTHER);
        metadataIdentifierType.add(URL);
        metadataIdentifierType.add(OTHER);
    }
}

