/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.r3data.mapper;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.damap.base.enums.EIdentifierType;
import org.damap.base.r3data.dto.RepositoryDetails;
import org.damap.base.utils.EqualityUtils;
import org.re3data.schema._2_2.Languages;
import org.re3data.schema._2_2.PidSystems;
import org.re3data.schema._2_2.Re3Data;
import org.re3data.schema._2_2.Yesno;

public final class RepositoryMapper {
    public static RepositoryDetails mapToRepositoryDetails(Re3Data re3Data, String id) {
        RepositoryDetails repositoryDetails = new RepositoryDetails();
        if (re3Data.getRepository().isEmpty()) {
            return repositoryDetails;
        }
        Re3Data.Repository repo = re3Data.getRepository().get(0);
        repositoryDetails.setId(id);
        repositoryDetails.setName(repo.getRepositoryName().getValue());
        repositoryDetails.setRepositoryURL(repo.getRepositoryURL());
        repositoryDetails.setDescription(repo.getDescription().getValue());
        repositoryDetails.setVersioning(RepositoryMapper.mapYesNoToBoolean(repo.getVersioning()));
        repositoryDetails.setRepositoryIdentifier(repo.getRepositoryIdentifier());
        if (!repo.getRepositoryLanguage().isEmpty()) {
            ArrayList<String> languages = new ArrayList<String>();
            for (Languages lang : repo.getRepositoryLanguage()) {
                languages.add(lang.value());
            }
            repositoryDetails.setRepositoryLanguages(languages);
        }
        if (!repo.getMetadataStandard().isEmpty()) {
            ArrayList<String> metadata = new ArrayList<String>();
            for (Re3Data.Repository.MetadataStandard mds : repo.getMetadataStandard()) {
                metadata.add(mds.getMetadataStandardName().getValue().value());
            }
            repositoryDetails.setMetadataStandards(metadata);
        }
        if (!repo.getContentType().isEmpty()) {
            ArrayList<String> types = new ArrayList<String>();
            for (Re3Data.Repository.ContentType ct : repo.getContentType()) {
                types.add(ct.getValue().value());
            }
            repositoryDetails.setContentTypes(types);
        }
        List<PidSystems> pidSystems = repo.getPidSystem();
        ArrayList<EIdentifierType> pidIdentifiers = new ArrayList<EIdentifierType>();
        for (PidSystems pidSystem : pidSystems) {
            if (EqualityUtils.nullExclusiveEquals(pidSystem.name(), "NONE")) continue;
            pidIdentifiers.add(EIdentifierType.valueOf(pidSystem.name()));
        }
        repositoryDetails.setPidSystems(pidIdentifiers);
        return repositoryDetails;
    }

    @Nullable
    public static Boolean mapYesNoToBoolean(Yesno value) {
        if (value == null) {
            return null;
        }
        return EqualityUtils.nullExclusiveEquals(value.value(), Yesno.YES.value());
    }

    @Generated
    private RepositoryMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

