/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.repo;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.damap.base.rest.gdpr.domain.GdprResult;
import org.damap.base.rest.gdpr.domain.HqlQuery;

@ApplicationScoped
public class GdprRepo {
    @Inject
    EntityManager entityManager;

    public List<GdprResult> getGdprDataByUniversityId(List<HqlQuery> queries, String universityId) {
        ArrayList<GdprResult> results = new ArrayList<GdprResult>();
        for (HqlQuery query : queries) {
            results.add(this.getGdprEntityDataByUniversityId(query, universityId));
        }
        return results;
    }

    private GdprResult getGdprEntityDataByUniversityId(HqlQuery query, String universityId) {
        GdprResult gdprResult = new GdprResult();
        gdprResult.setEntity(query.getEntityName());
        List result = this.entityManager.createQuery(query.getHql(), Map.class).setParameter("id", (Object)universityId).getResultList();
        result.forEach(map -> map.values().removeIf(Objects::isNull));
        gdprResult.setEntries(result);
        return gdprResult;
    }
}

