/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import io.quarkus.security.AuthenticationFailedException;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Date;
import lombok.Generated;
import org.damap.base.repo.ConsentRepo;
import org.damap.base.rest.administration.domain.ConsentDO;
import org.damap.base.rest.administration.service.ConsentService;
import org.damap.base.security.SecurityService;
import org.jboss.logging.Logger;

@Path(value="/api/consent")
@Authenticated
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConsentResource {
    @Generated
    private static final Logger log = Logger.getLogger(ConsentResource.class);
    @Inject
    ConsentService consentService;
    @Inject
    SecurityService securityService;
    @Inject
    ConsentRepo consentRepo;

    @GET
    public ConsentDO getConsent() {
        if (this.consentRepo.getConsentByUniversityId(this.getPersonId()) != null) {
            return this.consentService.getConsentByUser(this.getPersonId());
        }
        ConsentDO consent = new ConsentDO();
        String personId = this.getPersonId();
        consent.setUniversityId(personId);
        consent.setGivenDate(new Date());
        consent.setConsentGiven(false);
        return this.consentService.create(consent);
    }

    @POST
    @Consumes(value={"application/json"})
    public ConsentDO saveConsent(ConsentDO consentDO) {
        String personId = this.getPersonId();
        consentDO.setUniversityId(personId);
        consentDO.setGivenDate(new Date());
        if (this.consentService.getConsentByUser(this.getPersonId()) != null) {
            return this.consentService.update(consentDO);
        }
        return this.consentService.create(consentDO);
    }

    private String getPersonId() {
        if (this.securityService == null) {
            throw new AuthenticationFailedException("User ID is missing.");
        }
        return this.securityService.getUserId();
    }
}

