/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import lombok.Generated;
import org.damap.base.conversion.ExportTemplateBroker;
import org.damap.base.enums.ETemplateType;
import org.damap.base.rest.dmp.service.DmpService;
import org.damap.base.rest.document.service.DocumentService;
import org.damap.base.security.SecurityService;
import org.damap.base.validation.AccessValidator;
import org.jboss.logging.Logger;

@Path(value="/api/document")
@Authenticated
@Produces(value={"application/octet-stream"})
public class DmpDocumentResource {
    @Generated
    private static final Logger log = Logger.getLogger(DmpDocumentResource.class);
    @Inject
    SecurityService securityService;
    @Inject
    AccessValidator accessValidator;
    @Inject
    ExportTemplateBroker exportTemplateBroker;
    @Inject
    DmpService dmpService;
    @Inject
    DocumentService documentService;

    @GET
    @Path(value="/{dmpId}")
    @Deprecated(since="4.3.0", forRemoval=true)
    public Response exportTemplate(@PathParam(value="dmpId") long dmpId, @QueryParam(value="template") ETemplateType template) {
        log.info((Object)("Return DMP document file for DMP with id=" + dmpId));
        return this.export(dmpId, template, true, "docx");
    }

    @GET
    @Path(value="/{dmpId}/export")
    @Produces(value={"application/octet-stream"})
    public Response export(@PathParam(value="dmpId") long dmpId, @QueryParam(value="template") ETemplateType template, @QueryParam(value="download") @DefaultValue(value="true") Boolean download, @QueryParam(value="filetype") @DefaultValue(value="docx") String filetype) {
        StreamingOutput document;
        log.info((Object)("Returning DMP document file for DMP with id=" + dmpId));
        String personId = this.getPersonId();
        if (!this.accessValidator.canViewDmp(dmpId, personId)) {
            throw new ForbiddenException("Not authorized to access dmp with id " + dmpId);
        }
        try {
            document = this.documentService.getExportDocument(dmpId, template, download, filetype);
        }
        catch (Exception e) {
            log.error((Object)"Error exporting DMP document", (Throwable)e);
            return Response.serverError().entity((Object)"Error exporting DMP document").build();
        }
        String filename = this.dmpService.getDefaultFileName(dmpId);
        Response response = Response.ok((Object)document).header("Content-Disposition", (Object)("attachment;filename=" + filename + "." + filetype)).header("Access-Control-Expose-Headers", (Object)"Content-Disposition").build();
        if (filetype.equals("pdf")) {
            response.getHeaders().add((Object)"Content-Type", (Object)"application/pdf");
        }
        return response;
    }

    @GET
    @Path(value="/{dmpId}/template_type")
    @Produces(value={"application/json"})
    public ETemplateType getTemplateType(@PathParam(value="dmpId") long dmpId) {
        log.info((Object)("Return template type for DMP with id=" + dmpId));
        String personId = this.getPersonId();
        if (!this.accessValidator.canViewDmp(dmpId, personId)) {
            throw new ForbiddenException("Not authorized to access dmp with id " + dmpId);
        }
        return this.documentService.getTemplateType(dmpId);
    }

    private String getPersonId() {
        if (this.securityService == null) {
            throw new AuthenticationFailedException("User ID is missing.");
        }
        return this.securityService.getUserId();
    }
}

