/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.damap.base.rest.PersonServiceBroker;
import org.damap.base.rest.base.ResultList;
import org.damap.base.rest.base.Search;
import org.damap.base.rest.base.resource.ResourceRead;
import org.damap.base.rest.base.resource.ResourceSearch;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.persons.PersonService;
import org.jboss.logging.Logger;

@Path(value="/api/persons")
@Authenticated
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PersonResource
implements ResourceRead<ContributorDO>,
ResourceSearch<ContributorDO> {
    @Generated
    private static final Logger log = Logger.getLogger(PersonResource.class);
    @Inject
    PersonServiceBroker personServiceBroker;

    @Override
    public ContributorDO read(String id, UriInfo uriInfo) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        log.info((Object)("Return person details for id=" + id + " and query=" + queryParams.toString()));
        PersonService searchService = this.personServiceBroker.getServiceFromQueryParams((MultivaluedMap<String, String>)queryParams);
        ContributorDO result = null;
        if (searchService != null) {
            result = (ContributorDO)searchService.read(id, (MultivaluedMap<String, String>)queryParams);
        }
        return result;
    }

    @Override
    public ResultList<ContributorDO> search(UriInfo uriInfo) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        log.info((Object)("Return person list for query=" + queryParams.toString()));
        PersonService searchService = this.personServiceBroker.getServiceFromQueryParams((MultivaluedMap<String, String>)queryParams);
        Search search = Search.fromMap((MultivaluedMap<String, String>)queryParams);
        ResultList<ContributorDO> result = ResultList.fromItemsAndSearch(null, search);
        if (searchService != null) {
            result = searchService.search((MultivaluedMap<String, String>)queryParams);
        }
        return result;
    }
}

