/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.arc.All;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.ConfigResource;
import org.damap.base.rest.config.domain.ServiceConfig;
import org.damap.base.rest.persons.PersonService;
import org.jboss.logging.Logger;

@ApplicationScoped
public class PersonServiceBroker {
    @Generated
    private static final Logger log = Logger.getLogger(PersonServiceBroker.class);
    LinkedHashMap<String, PersonService> personServices = new LinkedHashMap();

    @Inject
    public PersonServiceBroker(ConfigResource config, @All List<PersonService> availableServices) {
        List<ServiceConfig> configuredServices = config.personServiceConfigurations.getConfigs();
        configuredServices.forEach(serviceConfig -> {
            boolean found = false;
            String configClassName = serviceConfig.getClassName();
            for (PersonService service : availableServices) {
                try {
                    String serviceClassName = service.getClass().getCanonicalName().split("_ClientProxy")[0];
                    if (!configClassName.equals(serviceClassName)) continue;
                    this.personServices.put(serviceConfig.getQueryValue(), service);
                    found = true;
                    break;
                }
                catch (Exception e) {
                    log.error((Object)String.format("Issue trying to initialize person service %s", configClassName), (Throwable)e);
                }
            }
            if (!found) {
                log.warn((Object)String.format("Service '%s' configured but is not available", configClassName));
            }
        });
    }

    public PersonService getServiceFromQueryParams(MultivaluedMap<String, String> queryParams) {
        return this.getServiceForQueryParam((String)queryParams.getFirst((Object)"searchService"));
    }

    public PersonService getServiceForQueryParam(String searchServiceType) {
        PersonService searchService = this.personServices.get(searchServiceType);
        if (searchService == null && !this.personServices.isEmpty()) {
            searchService = this.personServices.entrySet().iterator().next().getValue();
        }
        return searchService;
    }
}

