/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.base.ResultList;
import org.damap.base.rest.base.resource.ResourceSearch;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.domain.ProjectDO;
import org.damap.base.rest.dmp.service.DmpService;
import org.damap.base.rest.projects.ProjectService;
import org.jboss.logging.Logger;

@Path(value="/api/projects")
@Authenticated
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ProjectResource
implements ResourceSearch<ProjectDO> {
    @Generated
    private static final Logger log = Logger.getLogger(ProjectResource.class);
    @Inject
    ProjectService projectService;
    @Inject
    DmpService dmpService;

    @GET
    @Path(value="/{id}/staff")
    public List<ContributorDO> getProjectMembers(@PathParam(value="id") String projectId) {
        log.info((Object)String.format("Get Project Staff for Project ID=%s", projectId));
        return this.projectService.getProjectStaff(projectId);
    }

    @Override
    public ResultList<ProjectDO> search(UriInfo uriInfo) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        log.info((Object)("Return projects for query=" + queryParams.toString()));
        ResultList<ProjectDO> resultList = this.projectService.search((MultivaluedMap<String, String>)queryParams);
        resultList.setItems(this.dmpService.checkExistingDmps(resultList.getItems()));
        return resultList;
    }

    @GET
    @Path(value="/recommended")
    public ResultList<ProjectDO> recommended(@Context UriInfo uriInfo) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        log.info((Object)("Return recommended projects for query=" + queryParams.toString()));
        ResultList<ProjectDO> resultList = this.projectService.getRecommended((MultivaluedMap<String, String>)queryParams);
        resultList.setItems(this.dmpService.checkExistingDmps(resultList.getItems()));
        return resultList;
    }
}

