/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.administration.service;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import lombok.Generated;
import org.damap.base.domain.Consent;
import org.damap.base.repo.ConsentRepo;
import org.damap.base.rest.administration.domain.ConsentDO;
import org.damap.base.rest.administration.mapper.ConsentDOMapper;
import org.jboss.logging.Logger;

@ApplicationScoped
public class ConsentService {
    @Generated
    private static final Logger log = Logger.getLogger(ConsentService.class);
    @Inject
    ConsentRepo consentRepo;

    public ConsentDO getConsentByUser(String universityId) {
        return ConsentDOMapper.mapEntityToDO(this.consentRepo.getConsentByUniversityId(universityId), new ConsentDO());
    }

    @Transactional
    public ConsentDO create(ConsentDO consentDO) {
        Consent consent = ConsentDOMapper.mapDOtoEntity(consentDO, new Consent());
        consent.persistAndFlush();
        return this.getConsentByUser(consent.getUniversityId());
    }

    @Transactional
    public ConsentDO update(ConsentDO consentDO) {
        Consent consent = this.consentRepo.getConsentByUniversityId(consentDO.getUniversityId());
        ConsentDOMapper.mapDOtoEntity(consentDO, consent);
        consent.persistAndFlush();
        return this.getConsentByUser(consent.getUniversityId());
    }
}

